/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.WebBrowserView;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.WebBrowserSource;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;

public class WebImageViewer {
    private static final ILogger logger = GlobalLog.getLogger(WebImageViewer.class);
    private static boolean DEBUG_MODE = false;
    private WebBrowserView webview;

    public WebImageViewer(Composite parent, final IWebBrowserSource input, final Consumer<Image> callback) {
        this.webview = new WebBrowserView(parent, input, null, new ProgressListener(){

            public void completed(ProgressEvent event) {
                WebImageViewer.retrieveImageSafe(event, input, image -> {
                    if (!DEBUG_MODE) {
                        WebImageViewer.this.webview.dispose();
                        WebImageViewer.this.webview = null;
                    }
                    callback.accept(image);
                });
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    private static void retrieveImageSafe(ProgressEvent event, IWebBrowserSource input, Consumer<Image> callback) {
        try {
            new Thread(() -> {
                DelayedImageCheckedRunnable r = new DelayedImageCheckedRunnable(event, input);
                for (int i = 0; i < 3; ++i) {
                    event.widget.getDisplay().syncExec((Runnable)r);
                    if (r.lastGen != null) {
                        event.widget.getDisplay().syncExec(() -> callback.accept(r.lastGen));
                        break;
                    }
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }).start();
        }
        catch (RuntimeException e) {
            logger.catching(e, "Can not render " + input.getName());
        }
    }

    public static Image onProgressCompleted(ProgressEvent event, IWebBrowserSource input) {
        Browser browser = (Browser)event.widget;
        return WebImageViewer.onProgressCompleted(browser, input);
    }

    public static Image onProgressCompleted(Browser browser, IWebBrowserSource input) {
        int width = input.getWidthHint();
        int height = input.getHeightHint();
        if (width == 0 || height == 0) {
            return null;
        }
        Image image = WebImageViewer.convertToImage(browser);
        if (WebImageViewer.equalsDefaultBrowserImage(image, browser)) {
            image.dispose();
            Object[] cfr_ignored_0 = new Object[0];
            return null;
        }
        try {
            ImageData transparentImage = image.getImageData();
            transparentImage.transparentPixel = Integer.parseInt(input.getBackground().substring(1), 16);
            if (width != -1 && height != -1 && (transparentImage.width != width || transparentImage.height != height)) {
                browser.setBounds(0, 0, width, height);
                browser.update();
                image.dispose();
                Object[] objectArray = new Object[]{width, height, transparentImage.width, transparentImage.height};
                return null;
            }
            Image image2 = new Image((Device)browser.getDisplay(), transparentImage);
            image.dispose();
            image = image2;
            Object[] cfr_ignored_1 = new Object[0];
        }
        catch (NumberFormatException e) {
            logger.catchingSilent(e);
        }
        UIUtil.dbgImageResTrack(image);
        return image;
    }

    private static Image convertToImage(Browser browser) {
        Image image = new Image((Device)browser.getDisplay(), browser.getBounds().width, browser.getBounds().height);
        GC gc = null;
        try {
            gc = new GC((Drawable)image);
            browser.print(gc);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return image;
    }

    private static boolean equalsDefaultBrowserImage(Image image, Browser browser) {
        Image imageCheck = new Image((Device)browser.getDisplay(), browser.getBounds().width, browser.getBounds().height);
        try {
            byte[] imgCheckData = imageCheck.getImageData().data;
            boolean bl = ArrayUtil.equalsBytes(image.getImageData().data, 0, imgCheckData, 0, imgCheckData.length);
            return bl;
        }
        finally {
            imageCheck.dispose();
        }
    }

    public static byte[] export(IBinaryUnit unit) {
        byte[] byArray;
        block8: {
            IInput input = unit.getInput();
            InputStream in = input.getStream();
            try {
                byte[] data;
                byArray = data = IO.readInputStream(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.catching(e);
                    return null;
                }
            }
            in.close();
        }
        return byArray;
    }

    private static class DelayedImageCheckedRunnable
    implements Runnable {
        private ProgressEvent event;
        private IWebBrowserSource input;
        private Image lastGen = null;

        public DelayedImageCheckedRunnable(ProgressEvent event, IWebBrowserSource input) {
            this.event = event;
            this.input = input;
        }

        @Override
        public void run() {
            this.lastGen = WebImageViewer.onProgressCompleted(this.event, this.input);
        }
    }

    public static class WebpDocument
    extends WebBrowserSource {
        public WebpDocument(IRcpClientContext context, IBinaryUnit unit) throws IOException {
            super(unit.getName(), WebImageViewer.export(unit), WebpDocument.getBgColor(context));
        }

        @Override
        public boolean isImage() {
            return false;
        }

        private static String getBgColor(IRcpClientContext context) {
            Color c = context.getThemeManager().getBackgroundColor();
            return c == null ? "#E8E8E7" : "#" + Formatter.byteArrayToHexString(new byte[]{(byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue()});
        }
    }
}

