/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.extensions.AbstractRefresher;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ViewerRefresher
extends AbstractRefresher {
    private static final ILogger logger = GlobalLog.getLogger(ViewerRefresher.class);
    private Viewer viewer;

    public ViewerRefresher(Display display, Viewer viewer) {
        super(display, viewer.getClass().getName());
        this.viewer = viewer;
    }

    public ViewerRefresher(Viewer viewer) {
        super(viewer.getControl().getDisplay(), viewer.getClass().getName());
        this.viewer = viewer;
    }

    @Override
    protected boolean shouldPerformRefresh() {
        return this.viewer.getControl() != null && !this.viewer.getControl().isDisposed();
    }

    @Override
    protected void performRefresh() {
        this.viewer.refresh();
    }

    public static final IEventListener buildRefreshListener(Viewer viewer, final Predicate<IEvent> predicate, final Runnable uiRunnable) {
        final ViewerRefresher refresher = new ViewerRefresher(viewer.getControl().getDisplay(), viewer){

            @Override
            protected void performRefresh() {
                uiRunnable.run();
                super.performRefresh();
            }
        };
        return new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (predicate.test(e)) {
                    refresher.request();
                }
            }
        };
    }
}

