/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.SwtRegistry;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.collect.IdentityHashSet;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class UIUtil {
    private static final ILogger logger = GlobalLog.getLogger(UIUtil.class);
    private static boolean warnedArraySort;
    static final Comparator<Control> cmpTop;
    static final Comparator<Control> cmpCenterY;
    static final Comparator<Control> cmpLeft;
    static final Comparator<Control> cmpCenterX;
    private static final String jebCustomVerticalScrollingEnabled = "jebCustomVerticalScrollingEnabled";
    private static final String jebCustomHorizontalScrollingEnabled = "jebCustomHorizontalScrollingEnabled";
    private static Font codefont;
    private static boolean browserDoNotUse;
    private static boolean browserChecked;
    private static boolean browserSupported;
    private static IdentityHashSet<Image> trackedImages;

    public static boolean isUIThread(Display display) {
        return Thread.currentThread() == display.getThread();
    }

    public static Combo createLabeledCombo(Composite parent, String label, String ... values) {
        Composite c1 = new Composite(parent, 0);
        c1.setLayout((Layout)new RowLayout(256));
        Label lbl_sc = new Label(c1, 0);
        lbl_sc.setText(label + ":  ");
        Combo combo = new Combo(c1, 0x800008);
        for (String value : values) {
            combo.add(value);
        }
        return combo;
    }

    public static Button createPushbox(Composite parent, String name, SelectionListener listener) {
        Button btn = new Button(parent, 8);
        btn.setText("     " + name + "     ");
        if (listener != null) {
            btn.addSelectionListener(listener);
        }
        return btn;
    }

    public static Button createPushbox(Composite parent, String name, final Consumer<SelectionEvent> listener) {
        Button btn = new Button(parent, 8);
        btn.setText("     " + name + "     ");
        if (listener != null) {
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.accept(e);
                }
            });
        }
        return btn;
    }

    public static Button createTightPushbox(Composite parent, String name, SelectionListener listener) {
        Button btn = new Button(parent, 8);
        btn.setText(name);
        if (listener != null) {
            btn.addSelectionListener(listener);
        }
        return btn;
    }

    public static Button createCheckbox(Composite parent, String name, SelectionListener listener) {
        Button btn = new Button(parent, 32);
        btn.setText(name);
        if (listener != null) {
            btn.addSelectionListener(listener);
        }
        return btn;
    }

    public static List<Button> createRadioButtons(Composite parent, List<String> names, SelectionListener listener) {
        ArrayList<Button> btns = new ArrayList<Button>(names.size());
        int id = 0;
        for (String name : names) {
            Button btn = new Button(parent, 16);
            btn.setText(name);
            if (listener != null) {
                btn.addSelectionListener(listener);
            }
            btn.setData("radio_id", (Object)id);
            btns.add(btn);
            ++id;
        }
        return btns;
    }

    public static int getRadioButtonIndex(Button btn) {
        Object o = btn.getData("radio_id");
        if (!(o instanceof Integer)) {
            return -1;
        }
        return (Integer)o;
    }

    public static Button createTightPushboxImage(Composite parent, String iconRelPath, final Consumer<SelectionEvent> listener) {
        Button btn = new Button(parent, 8);
        btn.setText(" ");
        btn.setImage(UIAssetManager.getInstance().getImage(iconRelPath, null));
        if (listener != null) {
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.accept(e);
                }
            });
        }
        return btn;
    }

    public static Button createCheckboxImage(Composite parent, String iconRelPath, final Consumer<SelectionEvent> listener) {
        Button btn = new Button(parent, 32);
        btn.setText(" ");
        btn.setImage(UIAssetManager.getInstance().getImage(iconRelPath, null));
        if (listener != null) {
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    listener.accept(e);
                }
            });
        }
        return btn;
    }

    public static Label createLabel(Composite parent, String text) {
        return UIUtil.createLabel(parent, 0, text);
    }

    public static Label createLabel(Composite parent, int addStyle, String text) {
        Label label = new Label(parent, 0x4200 | addStyle);
        label.setText(text);
        return label;
    }

    public static Label createWrappedLabel(Composite parent, String text) {
        Label label = new Label(parent, 16960);
        label.setText(text);
        return label;
    }

    public static Label createWrappedLabel(Composite parent, int addStyle, String text) {
        Label label = new Label(parent, addStyle | 0x40);
        label.setText(text);
        return label;
    }

    public static Label createWrappedLabelInGridLayout(Composite parent, int addStyle, String text, int span) {
        Label label = new Label(parent, addStyle | 0x4000 | 0x200 | 0x40);
        label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(span, true, false));
        label.setText(text);
        return label;
    }

    public static Label createLabelInGridLayout(Composite parent, int addStyle, String text, int span) {
        Label label = new Label(parent, addStyle | 0x4000 | 0x200 | 0x40);
        label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(span, false, false));
        label.setText(text);
        return label;
    }

    public static Label createSeparator(Composite parent, boolean horizontal) {
        Label label = new Label(parent, 2 | (horizontal ? 256 : 512));
        label.setLayoutData((Object)UIUtil.createGridDataFill(true, false));
        return label;
    }

    public static Text createTextbox(Composite parent, int length, String init, SelectionListener listener) {
        Text text = new Text(parent, 2052);
        if (parent.getLayout() instanceof RowLayout) {
            RowData data;
            GC gc = new GC((Drawable)text);
            try {
                gc.setFont(text.getFont());
                FontMetrics fm = gc.getFontMetrics();
                data = new RowData((int)((double)length * fm.getAverageCharacterWidth()), 1 * fm.getHeight());
            }
            finally {
                gc.dispose();
            }
            text.setLayoutData((Object)data);
        } else if (parent.getLayout() instanceof GridLayout) {
            GridData data = new GridData();
            data.widthHint = length;
            text.setLayoutData((Object)data);
        }
        if (init != null) {
            text.setText(init);
            text.selectAll();
        }
        text.pack(false);
        if (listener != null) {
            text.addSelectionListener(listener);
        }
        return text;
    }

    public static Text createTextboxInGrid(Composite parent, int flags, Integer columns, Integer lines) {
        return UIUtil.createTextboxInGrid(parent, flags, columns, lines, false, false);
    }

    public static Text createTextboxInGrid(Composite parent, int flags, Integer columns, Integer lines, boolean fillHorizontally, boolean fillVertically) {
        final Text text = new Text(parent, flags);
        if ((flags & 4) != 0) {
            lines = 1;
        }
        if (parent.getLayout() instanceof GridLayout) {
            GridData data = new GridData();
            if (columns != null || lines != null) {
                GC gc = new GC((Drawable)text);
                try {
                    gc.setFont(text.getFont());
                    FontMetrics fm = gc.getFontMetrics();
                    if (columns != null && columns >= 1) {
                        data.widthHint = (int)((double)columns.intValue() * fm.getAverageCharacterWidth());
                    }
                    if (lines != null && lines > 1) {
                        data.heightHint = lines * fm.getHeight();
                    }
                }
                finally {
                    gc.dispose();
                }
            }
            if (fillHorizontally) {
                data.horizontalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
            }
            if (fillVertically) {
                data.verticalAlignment = 4;
                data.grabExcessVerticalSpace = true;
            }
            text.setLayoutData((Object)data);
        }
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 97 && (e.stateMask & SWT.MOD1) == SWT.MOD1) {
                    text.selectAll();
                }
            }
        });
        return text;
    }

    public static Combo addComboboxForToolbar(ToolBar toolbar, List<String> entries, int initialSelection) {
        new ToolItem(toolbar, 2);
        ToolItem item = new ToolItem(toolbar, 2);
        Combo w = new Combo((Composite)toolbar, 8);
        for (String entry : entries) {
            w.add(entry);
        }
        w.select(initialSelection);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public static Button addPushboxForToolbar(ToolBar toolbar, String name) {
        new ToolItem(toolbar, 2);
        ToolItem item = new ToolItem(toolbar, 2);
        Button w = new Button((Composite)toolbar, 8);
        w.setText(name);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public static Button addCheckboxForToolbar(ToolBar toolbar, String name, boolean initialState) {
        new ToolItem(toolbar, 2);
        ToolItem item = new ToolItem(toolbar, 2);
        Button w = new Button((Composite)toolbar, 32);
        w.setText(name);
        w.setSelection(initialState);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public static void disableTabOutput(Control textControl) {
        UIUtil.disableTabOutput(textControl, null);
    }

    public static void disableTabOutput(Control textControl, final Control nextFocusControl) {
        textControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                    if (nextFocusControl != null) {
                        nextFocusControl.setFocus();
                    }
                }
            }
        });
    }

    public static void customizeTextWidgetNavigation(Text textControl, final Button btn) {
        textControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r' && (e.stateMask & SWT.MOD1) != 0) {
                    Event event = new Event();
                    event.widget = btn;
                    event.type = 13;
                    btn.notifyListeners(13, event);
                }
                if (e.detail == 16) {
                    e.doit = true;
                }
            }
        });
    }

    public static RowLayout createRowLayout(boolean vertical, boolean wrap) {
        RowLayout l = new RowLayout();
        l.type = vertical ? 512 : 256;
        l.wrap = wrap;
        return l;
    }

    public static GridLayout setStandardLayout(Composite composite) {
        return UIUtil.setStandardLayout(composite, 1, 5, 5);
    }

    public static GridLayout setStandardLayout(Composite composite, int numColumns) {
        return UIUtil.setStandardLayout(composite, numColumns, 5, 5);
    }

    public static GridLayout setStandardLayout(Composite composite, int numColumns, int marginSize) {
        return UIUtil.setStandardLayout(composite, numColumns, marginSize, 5);
    }

    public static GridLayout setStandardLayout(Composite composite, int numColumns, int marginSize, int marginEdges) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginLeft = marginSize;
        layout.marginRight = marginSize;
        layout.marginTop = marginSize;
        layout.marginBottom = marginSize;
        layout.marginWidth = marginEdges;
        layout.marginHeight = marginEdges;
        composite.setLayout((Layout)layout);
        return layout;
    }

    public static GridData createGridDataFillHorizontally() {
        return UIUtil.createGridDataFill(true, false);
    }

    public static GridData createGridDataFillHorizontalRightAligned() {
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 0x1000008;
        return data;
    }

    public static GridData createGridDataFill(boolean fillHorizontally, boolean fillVertically) {
        GridData data = new GridData();
        if (fillHorizontally) {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (fillVertically) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        return data;
    }

    public static GridData createGridDataSpanHorizontally(int span) {
        return UIUtil.createGridDataSpanHorizontally(span, false, false);
    }

    public static GridData createGridDataSpanHorizontally(int span, boolean fillHorizontally, boolean fillVertically) {
        GridData data = new GridData();
        data.horizontalSpan = span;
        if (fillHorizontally) {
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
        }
        if (fillVertically) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        return data;
    }

    public static GridData createGridDataForText(Control ctl, int charCount) {
        return UIUtil.createGridDataForText(ctl, charCount, -1, true);
    }

    public static GridData createGridDataForText(Control ctl, int columnCount, int lineCount, boolean fillHorizontally) {
        GridData data;
        GC gc = new GC((Drawable)ctl);
        try {
            gc.setFont(ctl.getFont());
            FontMetrics fm = gc.getFontMetrics();
            int width = columnCount <= 0 ? -1 : (int)((double)columnCount * fm.getAverageCharacterWidth());
            int height = lineCount <= 0 ? -1 : lineCount * fm.getHeight();
            data = new GridData(width, height);
            if (fillHorizontally) {
                data.horizontalAlignment = 4;
                data.grabExcessHorizontalSpace = true;
            }
        }
        finally {
            gc.dispose();
        }
        return data;
    }

    public static Group createGroup(Composite parent, String label) {
        Group general = new Group(parent, 0);
        general.setText(label);
        general.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        general.setLayout((Layout)new GridLayout(2, false));
        return general;
    }

    public static Group createGroupGrid(Composite parent, int style, String label, int span, int cols) {
        return UIUtil.createGroupGrid(parent, style, label, span, cols, null);
    }

    public static Group createGroupGrid(Composite parent, int style, String label, int span, int cols, Integer marginWH) {
        Group c = new Group(parent, style);
        c.setText(label);
        GridData data = UIUtil.createGridDataSpanHorizontally(span, true, false);
        c.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(cols, false);
        if (marginWH != null) {
            layout.marginHeight = marginWH;
            layout.marginWidth = marginWH;
        }
        c.setLayout((Layout)layout);
        return c;
    }

    public static Composite createCompositeGrid(Composite parent, int style, int span, int cols, Integer marginWH) {
        Composite c = new Composite(parent, style);
        GridData data = UIUtil.createGridDataSpanHorizontally(span, true, false);
        c.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(cols, false);
        if (marginWH != null) {
            layout.marginHeight = marginWH;
            layout.marginWidth = marginWH;
        }
        c.setLayout((Layout)layout);
        return c;
    }

    public static int determineTextWidth(Control ctl, int columnCount) {
        int width;
        GC gc = new GC((Drawable)ctl);
        try {
            gc.setFont(ctl.getFont());
            FontMetrics fm = gc.getFontMetrics();
            width = columnCount <= 0 ? -1 : (int)((double)columnCount * fm.getAverageCharacterWidth());
        }
        finally {
            gc.dispose();
        }
        return width;
    }

    public static int determineTextHeight(Control ctl, int lineCount) {
        int height;
        GC gc = new GC((Drawable)ctl);
        try {
            gc.setFont(ctl.getFont());
            FontMetrics fm = gc.getFontMetrics();
            height = lineCount <= 0 ? -1 : lineCount * fm.getHeight();
        }
        finally {
            gc.dispose();
        }
        return height;
    }

    public static FormData createFormData(Object top, Object bottom, Object left, Object right) {
        FormData data = new FormData();
        data.top = UIUtil.createFormAttachment(top);
        data.bottom = UIUtil.createFormAttachment(bottom);
        data.left = UIUtil.createFormAttachment(left);
        data.right = UIUtil.createFormAttachment(right);
        return data;
    }

    public static FormAttachment createFormAttachment(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return new FormAttachment(((Integer)v).intValue());
        }
        if (v instanceof Control) {
            return new FormAttachment((Control)v);
        }
        throw new RuntimeException();
    }

    public static RowLayout createVerticalLayout() {
        return UIUtil.createRowLayout(true, false);
    }

    public static RowLayout createHorizontalLayout() {
        return UIUtil.createRowLayout(false, false);
    }

    public static Rectangle rectangleFromString(String s) {
        String[] elts = s.split(";");
        if (elts.length == 4) {
            try {
                return new Rectangle(Integer.parseInt(elts[0]), Integer.parseInt(elts[1]), Integer.parseInt(elts[2]), Integer.parseInt(elts[3]));
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static String rectangleToString(Rectangle r) {
        return Strings.ff("%d;%d;%d;%d", r.x, r.y, r.width, r.height);
    }

    public static void showOperationResultDialog(Shell parent, boolean success) {
        int flags = 0x20 | (success ? 2 : 1);
        MessageBox mb = new MessageBox(parent, flags);
        mb.setText(S.s(280));
        if (success) {
            mb.setMessage(S.s(206));
        } else {
            mb.setMessage(S.s(205));
        }
        mb.open();
    }

    public static void setWidgetName(Widget widget, String name) {
        widget.setData("widgetName", (Object)name);
    }

    public static String getWidgetName(Widget widget) {
        Object o = widget.getData("widgetName");
        if (o != null && !(o instanceof String)) {
            throw new IllegalStateException("The widgetName UI property must be a String");
        }
        return (String)o;
    }

    public static int getWidgetId(Object object) {
        if (object instanceof JebDialog) {
            object = ((JebDialog)((Object)object)).getShell();
        }
        if (object instanceof Control) {
            Object objName;
            Object fqname = "";
            Control control = (Control)object;
            if (!(control instanceof Shell)) {
                objName = control.getData("widgetName");
                if (!(objName instanceof String)) {
                    Object[] cfr_ignored_0 = new Object[0];
                    return 0;
                }
                fqname = objName + "/" + (String)fqname;
                if ((control = control.getShell()) == null) {
                    Object[] cfr_ignored_1 = new Object[0];
                    return 0;
                }
            }
            while (control != null) {
                if (!(control instanceof Shell)) {
                    (new Object[1])[0] = control.getClass().getName();
                    return 0;
                }
                objName = control.getData("widgetName");
                if (!(objName instanceof String)) {
                    (new Object[1])[0] = ((Shell)control).getText();
                    return 0;
                }
                fqname = objName + "/" + (String)fqname;
                control = control.getParent();
            }
            return ((String)fqname).hashCode();
        }
        return 0;
    }

    public static Shell getParentShell(Composite ctl) {
        do {
            if ((ctl = ctl.getParent()) != null) continue;
            return null;
        } while (!(ctl instanceof Shell));
        return (Shell)ctl;
    }

    public static void copyTextToClipboard(String text) {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            TextTransfer textTransfer = TextTransfer.getInstance();
            clipboard.setContents((Object[])new String[]{text}, new Transfer[]{textTransfer});
        }
        finally {
            clipboard.dispose();
        }
    }

    public static String getTextFromClipboard() {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        TextTransfer textTransfer = TextTransfer.getInstance();
        String s = (String)clipboard.getContents((Transfer)textTransfer, 1);
        clipboard.dispose();
        return s;
    }

    public static boolean isArrowKey(int key) {
        switch (key) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    public static void safeRefreshViewer(Viewer viewer) {
        try {
            viewer.refresh();
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("Comparison method violates its general contract!") && !Boolean.parseBoolean(System.getProperty("java.util.Arrays.useLegacyMergeSort"))) {
                logger.error("A comparison error occurred, the viewer cannot be sorted!", new Object[0]);
                if (!warnedArraySort) {
                    warnedArraySort = true;
                    logger.error("It may be a well-known issue in the UI framework: consider editing jeb.ini, and add the following line:\n  -Djava.util.Arrays.useLegacyMergeSort=true\nafter the line (add it if necessary):\n  -vmargs\nRefer to the FAQ for details: https://www.pnfsoftware.com/jeb/manual/faq/", new Object[0]);
                }
                return;
            }
            throw e;
        }
    }

    public static boolean isContained(Point p, Rectangle r) {
        return p.x >= r.x && p.x < r.x + r.width && p.y >= r.y && p.y < r.y + r.height;
    }

    public static boolean intersect(Rectangle a, Rectangle b) {
        return UIUtil.intersectOrContain(a, b, false);
    }

    public static boolean contains(Rectangle a, Rectangle b) {
        return UIUtil.intersectOrContain(a, b, true);
    }

    private static boolean intersectOrContain(Rectangle a, Rectangle b, boolean requestFullInclusion) {
        int left0 = a.x;
        int right0 = a.x + a.width;
        int top0 = a.y;
        int bottom0 = a.y + a.height;
        int left1 = b.x;
        int right1 = b.x + b.width;
        int top1 = b.y;
        int bottom1 = b.y + b.height;
        if (left1 >= left0 && right1 <= right0 && top1 >= top0 && bottom1 <= bottom0) {
            return true;
        }
        if (requestFullInclusion) {
            return false;
        }
        return left1 > (left0 -= b.width) && right1 < (right0 += b.width) && top1 > (top0 -= b.height) && bottom1 < (bottom0 += b.height);
    }

    public static Point getRectangleCenter(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public static void orderControls(List<? extends Control> nodes, OrderType comparePoint) {
        switch (comparePoint) {
            case TOP: {
                Collections.sort(nodes, cmpTop);
                break;
            }
            case CENTER_Y: {
                Collections.sort(nodes, cmpCenterY);
                break;
            }
            case LEFT: {
                Collections.sort(nodes, cmpLeft);
                break;
            }
            case CENTER_X: {
                Collections.sort(nodes, cmpCenterX);
                break;
            }
            default: {
                throw new RuntimeException("Not supported: " + comparePoint);
            }
        }
    }

    public static int getCenterX(Control ctl) {
        Rectangle r = ctl.getBounds();
        return r.x + r.width / 2;
    }

    public static int getCenterY(Control ctl) {
        Rectangle r = ctl.getBounds();
        return r.y + r.height / 2;
    }

    public static String formatControlHierarchy(Control ctl) {
        Object s = "";
        while (ctl != null) {
            s = ctl.getClass().getSimpleName() + " >> " + (String)s;
            ctl = ctl.getParent();
        }
        return s;
    }

    public static int determineIdealScrollbarFlags() {
        return UIUtil.determineIdealScrollbarFlags(true, true);
    }

    public static int determineIdealScrollbarFlags(boolean wantVerticalScrolling, boolean wantHorizontalScrolling) {
        return UIUtil.determineIdealScrollbarFlags(wantVerticalScrolling, wantHorizontalScrolling, 0);
    }

    public static int determineIdealScrollbarFlags(boolean wantVerticalScrolling, boolean wantHorizontalScrolling, int currentFlags) {
        if (wantVerticalScrolling) {
            currentFlags |= 0x200;
        }
        if (wantHorizontalScrolling) {
            boolean forced = false;
            RcpClientContext ctx = RcpClientContext.getInstance();
            if (ctx != null) {
                forced = ctx.getPropertyManager().getBoolean(".ui.text.ForceDisplayHorizontalScrollbar");
            }
            if (forced || !OSType.determine().isWindows()) {
                currentFlags |= 0x100;
            }
        }
        return currentFlags;
    }

    public static void addScrollingSupport(final StyledText w, boolean vertical, boolean horizontal) {
        if (vertical && w.getData(jebCustomVerticalScrollingEnabled) == null && (w.getStyle() & 0x200) == 0) {
            w.setData(jebCustomVerticalScrollingEnabled, (Object)true);
            w.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    int index = w.getTopIndex() - e.count;
                    w.setTopIndex(index);
                }
            });
        }
        if (horizontal && w.getData(jebCustomHorizontalScrollingEnabled) == null && (w.getStyle() & 0x100) == 0) {
            w.setData(jebCustomHorizontalScrollingEnabled, (Object)true);
            w.addListener(38, new Listener(){

                public void handleEvent(Event e) {
                    int index = w.getHorizontalIndex() - e.count;
                    w.setHorizontalIndex(index);
                }
            });
            w.addMouseWheelListener(new MouseWheelListener(){

                public void mouseScrolled(MouseEvent e) {
                    if ((e.stateMask & 0x20000) != 0) {
                        int index = w.getHorizontalIndex() - e.count;
                        w.setHorizontalIndex(index);
                    }
                }
            });
        }
    }

    public static StyledText createStyledText(Composite parent, int style) {
        boolean wantVerticalScrolling = (style & 0x200) != 0;
        boolean wantHorizontalScrolling = (style & 0x100) != 0;
        StyledText w = new StyledText(parent, UIUtil.determineIdealScrollbarFlags(wantVerticalScrolling, wantHorizontalScrolling, style &= 0xFFFFFCFF));
        UIUtil.addScrollingSupport(w, wantVerticalScrolling, wantHorizontalScrolling);
        return w;
    }

    public static ToolBarManager createHorizontalToolBar(int style, Composite parent, Action ... actions) {
        ToolBarManager tbm = new ToolBarManager(0x100 | style);
        UIUtil.addToolbarActions(tbm, actions);
        tbm.createControl(parent);
        return tbm;
    }

    public static ToolBarManager addToolbarActions(ToolBarManager tbm, Action ... actions) {
        for (Action action : actions) {
            tbm.add(action);
        }
        return tbm;
    }

    public static Action createToolBarActionIcon(String path, final Runnable r) {
        return new Action(null, ImageDescriptor.createFromImage(UIAssetManager.getInstance().getImage(path))){

            @Override
            public void run() {
                r.run();
            }
        };
    }

    public static Action createToolBarRadioActionIcon(String path, final Runnable r) {
        Action action = new Action(null, 2){

            @Override
            public void run() {
                r.run();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromImage(UIAssetManager.getInstance().getImage(path)));
        return action;
    }

    public static ToolBar createHorizontalSwtToolBar(int style, Composite parent) {
        return new ToolBar(parent, 0x100 | style);
    }

    public static ToolItem addToolItemCheck(ToolBar toolBar, String path, final Consumer<ToolItem> consumer) {
        final ToolItem item = new ToolItem(toolBar, 32);
        if (path != null) {
            item.setImage(UIAssetManager.getInstance().getImage(path));
        }
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return item;
    }

    public static ToolItem addToolItemPush(ToolBar toolBar, String path, final Consumer<ToolItem> consumer) {
        final ToolItem item = new ToolItem(toolBar, 8);
        if (path != null) {
            item.setImage(UIAssetManager.getInstance().getImage(path));
        }
        item.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                consumer.accept(item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return item;
    }

    public static Image scaleToBest(Image img, int width, int height) {
        double ratio = UIUtil.getBestRatio(img, width, height);
        if (ratio == 1.0) {
            return img;
        }
        return UIUtil.scale(img, ratio);
    }

    public static double getBestRatio(Image img, int width, int height) {
        if (img.getBounds().height == height && img.getBounds().width <= width) {
            return 1.0;
        }
        if (img.getBounds().width == width && img.getBounds().height <= height) {
            return 1.0;
        }
        double widthRatio = (double)width / (double)img.getBounds().width;
        double heightRatio = (double)height / (double)img.getBounds().height;
        return Math.min(widthRatio, heightRatio);
    }

    private static Image scale(Image img, double ratio) {
        ImageData imgData = img.getImageData().scaledTo((int)((double)img.getBounds().width * ratio), (int)((double)img.getBounds().height * ratio));
        Image img2 = new Image(img.getDevice(), imgData);
        UIUtil.dbgImageResTrack(img2);
        return img2;
    }

    public static Font getCodeFont() {
        RcpClientContext ctx = RcpClientContext.getInstance();
        if (ctx != null) {
            return ctx.getFontManager().getCodeFont();
        }
        if (codefont == null) {
            codefont = SwtRegistry.getInstance().getFont(JFaceResources.getFont("org.eclipse.jface.textfont"), (Integer)9, (Integer)0);
        }
        return codefont;
    }

    public static void textinsert(Text w, String str) {
        String text = w.getText();
        Point sel = w.getSelection();
        text = UIUtil.textinsertPrep(text, sel, str);
        w.setText(text);
    }

    public static void textinsert(StyledText w, String str) {
        String text = w.getText();
        Point sel = w.getSelection();
        text = UIUtil.textinsertPrep(text, sel, str);
        w.setText(text);
    }

    private static String textinsertPrep(String text, Point sel, String str) {
        int begin = sel.x;
        int end = sel.y;
        if (begin > end) {
            begin = sel.y;
            end = sel.x;
        }
        return text.substring(0, begin) + str + text.substring(end, text.length());
    }

    public static void addSelectAllSupport(final StyledText w) {
        w.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == SWT.MOD1 && e.keyCode == 97) {
                    w.selectAll();
                }
            }
        });
    }

    public static ControlDecoration createHelpDecorator(Control ctl, String msg) {
        ControlDecoration deco = new ControlDecoration(ctl, 16512);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
        deco.setDescriptionText(msg);
        deco.setImage(image);
        return deco;
    }

    public static void setDoNotUseBrowser(boolean doNotUse) {
        browserDoNotUse = doNotUse;
    }

    public static boolean canUseBrowser(Composite parent) {
        if (browserDoNotUse) {
            return false;
        }
        if (!browserChecked) {
            try {
                Browser browser = new Browser(parent, 0);
                browser.dispose();
                browserSupported = true;
            }
            catch (Throwable t) {
                logger.debug("Browser not supported! %s", t.getMessage());
                if (OSType.determine().isLinux()) {
                    logger.warn("The internal Web browser cannot be used! Please ensure that WebKit is correctly installed:\n- With GTK 3, check that the binding is installed: Try to install libwebkit2gtk-{version} package, for example libwebkit2gtk-4.0.37.\n- With GTK 4, the binding may not be fully supported: Try to install libswt-webkit-gtk-4-jni package.", new Object[0]);
                }
                browserSupported = false;
            }
            finally {
                browserChecked = true;
            }
        }
        return browserSupported;
    }

    public static void dbgImageResTrack(Image img) {
        if (Licensing.isReleaseBuild()) {
            return;
        }
        Class<UIUtil> clazz = UIUtil.class;
        synchronized (UIUtil.class) {
            if (img == null) {
                throw new RuntimeException("Attempting to track a null image");
            }
            trackedImages.add(img);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void dbgImageResVerify() {
        if (Licensing.isReleaseBuild()) {
            return;
        }
        Class<UIUtil> clazz = UIUtil.class;
        synchronized (UIUtil.class) {
            int nonDisposed = 0;
            for (Image img : trackedImages) {
                if (img.isDisposed()) continue;
                ++nonDisposed;
            }
            if (nonDisposed > 0) {
                throw new RuntimeException("Tracked Images not disposed: " + nonDisposed);
            }
            trackedImages.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void addTextScrolledListener(final StyledText text, final IntConsumer topListener) {
        ScrollBar vBar;
        Listener listener = new Listener(){
            int lastIndex;
            {
                this.lastIndex = text.getTopIndex();
            }

            public void handleEvent(Event e) {
                int index = text.getTopIndex();
                if (index != this.lastIndex) {
                    this.lastIndex = index;
                    topListener.accept(index);
                }
            }
        };
        text.addListener(3, listener);
        text.addListener(5, listener);
        text.addListener(4, listener);
        text.addListener(1, listener);
        text.addListener(2, listener);
        text.addListener(11, listener);
        ScrollBar hBar = text.getHorizontalBar();
        if (hBar != null) {
            hBar.addListener(13, listener);
        }
        if ((vBar = text.getVerticalBar()) != null) {
            vBar.addListener(13, listener);
        }
    }

    public static MouseListener setBetterWordSelector(final StyledText w) {
        w.setDoubleClickEnabled(false);
        MouseAdapter e = new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                int off0;
                int reloff;
                int off = w.getCaretOffset();
                int lineIndex = w.getLineAtOffset(w.getCaretOffset());
                String line = w.getLine(lineIndex);
                int[] bounds = Strings.findWordBoundaries(line, reloff = off - (off0 = w.getOffsetAtLine(lineIndex)));
                if (bounds[0] != bounds[1]) {
                    w.setSelection(off0 + bounds[0], off0 + bounds[1]);
                }
            }
        };
        w.addMouseListener((MouseListener)e);
        return e;
    }

    static {
        cmpTop = new Comparator<Control>(){

            @Override
            public int compare(Control o1, Control o2) {
                return o1.getLocation().y - o2.getLocation().y;
            }
        };
        cmpCenterY = new Comparator<Control>(){

            @Override
            public int compare(Control o1, Control o2) {
                return UIUtil.getCenterY(o1) - UIUtil.getCenterY(o2);
            }
        };
        cmpLeft = new Comparator<Control>(){

            @Override
            public int compare(Control o1, Control o2) {
                return o1.getLocation().x - o2.getLocation().x;
            }
        };
        cmpCenterX = new Comparator<Control>(){

            @Override
            public int compare(Control o1, Control o2) {
                return UIUtil.getCenterX(o1) - UIUtil.getCenterX(o2);
            }
        };
        trackedImages = new IdentityHashSet();
    }

    public static enum OrderType {
        TOP,
        CENTER_Y,
        BOTTOM,
        LEFT,
        CENTER_X,
        RIGHT;

    }
}

