/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.core.events.J;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UIUnitUtil {
    public static void setAutoCloseWhenDisposed(final Shell shell, final IUnit unit) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if (unit == null || unit.isDisposed()) {
            return;
        }
        final Display display = shell.getDisplay();
        final IEventListener listener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                if (e instanceof JebEvent && e.getType() == J.UnitDisposed && e.getData() == unit && !shell.isDisposed()) {
                    display.asyncExec(() -> shell.close());
                }
            }
        };
        unit.addListener(listener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                unit.removeListener(listener);
            }
        });
    }
}

