/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.IWidgetManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.AdaptivePopupDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.InputDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellActivationTracker;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.ui.UITaskManager;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.concurrent.DaemonExecutors;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class UI {
    private static final ILogger logger = GlobalLog.getLogger(UI.class);
    private static Display display;
    private static ExecutorService execsvc;
    private static ShellActivationTracker shellTracker;
    private static UITaskManager taskManager;
    private static boolean[] kbmodstates;
    public static final OSType ostype;
    public static final boolean isMac;
    public static final String MOD1;
    public static final String MOD2;
    public static final String MOD3;
    public static final String MOD4;
    private static final String KEY_JEB_POPUP = "JEB_POPUP";

    public static void initialize() {
        if (display != null) {
            if (Display.getCurrent() != display) {
                throw new IllegalStateException("The UI class was already initialized on another UI thread");
            }
            return;
        }
        display = Display.getCurrent();
        if (display == null) {
            throw new RuntimeException("The UI class must be loaded by the UI thread");
        }
        execsvc = DaemonExecutors.newFixedThreadPool(10);
        shellTracker = new ShellActivationTracker(display);
        taskManager = new UITaskManager(display, execsvc);
        Listener kbfilter = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == SWT.MOD1) {
                    i = 0;
                } else if (event.keyCode == SWT.MOD2) {
                    i = 1;
                } else if (event.keyCode == SWT.MOD3) {
                    i = 2;
                } else if (event.keyCode == SWT.MOD4) {
                    i = 3;
                } else {
                    return;
                }
                if (event.type == 1) {
                    UI.kbmodstates[i] = true;
                } else if (event.type == 2) {
                    UI.kbmodstates[i] = false;
                }
            }
        };
        display.addFilter(1, kbfilter);
        display.addFilter(2, kbfilter);
    }

    private static void safeInit() {
        if (display == null) {
            UI.initialize();
        }
    }

    public static Display getDisplay() {
        UI.safeInit();
        return display;
    }

    public static ShellActivationTracker getShellTracker() {
        UI.safeInit();
        return shellTracker;
    }

    public static UITaskManager getTaskManager() {
        UI.safeInit();
        return taskManager;
    }

    public static int getKeyboardModifiersState() {
        int v = 0;
        if (kbmodstates[0]) {
            v |= SWT.MOD1;
        }
        if (kbmodstates[1]) {
            v |= SWT.MOD2;
        }
        if (kbmodstates[2]) {
            v |= SWT.MOD3;
        }
        if (kbmodstates[3]) {
            v |= SWT.MOD4;
        }
        return v;
    }

    public static String acc(String s, int ch) {
        if (s.indexOf(38) >= 0) {
            return s;
        }
        int pos = s.toLowerCase().indexOf(ch);
        if (pos < 0) {
            return s;
        }
        return s.substring(0, pos) + "&" + s.substring(pos);
    }

    public static void log(final int level, final Shell shell, final String caption, final String message) {
        UI.safeInit();
        final AtomicBoolean displayed = new AtomicBoolean();
        UIRunnable r = new UIRunnable(null, false){

            @Override
            public void runi() {
                Shell shell0;
                Shell shell2 = shell0 = shell != null ? shell : shellTracker.get();
                if (shell0 != null) {
                    displayed.set(true);
                    if (level == 50) {
                        MessageDialog.openError(shell0, caption, message);
                    } else if (level == 40) {
                        MessageDialog.openWarning(shell0, caption, message);
                    } else {
                        MessageDialog.openInformation(shell0, caption, message);
                    }
                }
            }
        };
        Display display = Display.getDefault();
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            UIExecutor.sync(display, (Runnable)r);
        }
        if (!displayed.get()) {
            logger.log(level, false, "%s: %s", caption, message);
        }
    }

    public static boolean confirm(final Shell shell, final String caption, final String message) {
        UI.safeInit();
        final AtomicBoolean success = new AtomicBoolean();
        UIRunnable r = new UIRunnable(null, false){

            @Override
            public void runi() {
                Shell shell0;
                Shell shell2 = shell0 = shell != null ? shell : shellTracker.get();
                if (shell0 != null) {
                    success.set(MessageDialog.openConfirm(shell0, caption, message));
                }
            }
        };
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            UIExecutor.sync(display, (Runnable)r);
        }
        return success.get();
    }

    public static void warn(Shell shell, String caption, String message) {
        UI.log(40, shell, caption, message);
    }

    public static void info(Shell shell, String caption, String message) {
        UI.log(30, shell, caption, message);
    }

    public static void info(String message) {
        UI.log(30, null, S.s(384), message);
    }

    public static void warn(String message) {
        UI.log(40, null, S.s(821), message);
    }

    public static void error(Shell shell, String caption, String message) {
        UI.log(50, shell, caption, message);
    }

    public static void error(String message) {
        UI.log(50, null, S.s(304), message);
    }

    public static boolean question(final Shell shell, final String caption, final String message) {
        UI.safeInit();
        final AtomicBoolean success = new AtomicBoolean();
        UIRunnable r = new UIRunnable(null, false){

            @Override
            public void runi() {
                Shell shell0;
                Shell shell2 = shell0 = shell != null ? shell : shellTracker.get();
                if (shell0 != null) {
                    success.set(MessageDialog.openQuestion(shell0, caption, message));
                }
            }
        };
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            UIExecutor.sync(display, (Runnable)r);
        }
        return success.get();
    }

    public static Boolean questionWithCancel(final Shell shell, final String caption, final String message) {
        UI.safeInit();
        final AtomicInteger index = new AtomicInteger();
        UIRunnable r = new UIRunnable(null, false){

            @Override
            public void runi() {
                Shell shell0;
                Shell shell2 = shell0 = shell != null ? shell : shellTracker.get();
                if (shell0 != null) {
                    index.set(MessageDialog.open(6, shell0, caption, message, 0, "Yes", "No", "Cancel"));
                }
            }
        };
        if (Thread.currentThread() == display.getThread()) {
            r.run();
        } else {
            UIExecutor.sync(display, (Runnable)r);
        }
        switch (index.get()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return null;
    }

    public static String ask(Shell shell, String caption, String message, String defaultValue) {
        InputDialog dlg = new InputDialog(UI.getShellTracker().get(), caption, defaultValue);
        dlg.setMessage(message);
        return dlg.open();
    }

    public static boolean infoOptional(Shell shell, String caption, String message, String widgetName) {
        return UI.popupOptional(shell, 2, caption, message, widgetName);
    }

    public static boolean warnOptional(Shell shell, String caption, String message, String widgetName) {
        return UI.popupOptional(shell, 8, caption, message, widgetName);
    }

    public static boolean popupOptional(Shell shell, int style, String caption, String message, String widgetName) {
        String title;
        if (widgetName == null) {
            throw new IllegalArgumentException();
        }
        if (message == null) {
            return false;
        }
        String defaultTitle = "";
        boolean warning = false;
        if ((style & 2) != 0) {
            defaultTitle = "Info";
        } else if ((style & 8) != 0) {
            logger.warn(message, new Object[0]);
            defaultTitle = "Warning";
            warning = true;
        }
        IWidgetManager widgetManager = JebDialog.getStandardWidgetManager();
        if (widgetManager == null || !widgetManager.getShouldShowDialog(widgetName)) {
            return false;
        }
        String string = title = caption != null ? caption : defaultTitle;
        if (warning) {
            AdaptivePopupDialog.warn(shell, title, message, widgetName).open();
        } else {
            AdaptivePopupDialog.info(shell, title, message, widgetName).open();
        }
        return true;
    }

    public static boolean isShellPopup(Shell shell) {
        return Boolean.TRUE.equals(shell.getData(KEY_JEB_POPUP));
    }

    public static Shell newShellPopup(Shell parent, int style) {
        Shell shell = new Shell(parent, style);
        shell.setData(KEY_JEB_POPUP, (Object)Boolean.TRUE);
        UI.setupStandardShellTitleAndIcon(shell);
        return shell;
    }

    public static Shell newShellPopup(Display parent, int style) {
        Shell shell = new Shell(parent, style);
        shell.setData(KEY_JEB_POPUP, (Object)Boolean.TRUE);
        UI.setupStandardShellTitleAndIcon(shell);
        return shell;
    }

    public static void setupStandardShellTitleAndIcon(Shell shell) {
        shell.setText("JEB");
        shell.setImage(UIAssetManager.getInstance().getImage("program/jeb_32px.png"));
    }

    public static Shell getDockShell() {
        RcpClientContext context = RcpClientContext.getInstance();
        if (context != null) {
            return context.getMainShell();
        }
        Shell sh = UI.getShellTracker().get();
        if (sh != null && sh.getData(KEY_JEB_POPUP) == Boolean.TRUE) {
            return UI.getShellTracker().getMainShell();
        }
        return sh;
    }

    static {
        kbmodstates = new boolean[4];
        ostype = OSType.determine();
        isMac = ostype.isMac();
        if (isMac) {
            MOD1 = "\u2318";
            MOD2 = "\u21e7";
            MOD3 = "\u2325";
            MOD4 = "\u2303";
        } else {
            MOD1 = "\u2303";
            MOD2 = "\u21e7";
            MOD3 = "\u2325";
            MOD4 = "\u2318";
        }
    }
}

