/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.core.output.text.StyleInfo;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import com.pnfsoftware.jeb.util.encoding.jflex.Token;
import com.pnfsoftware.jeb.util.encoding.jflex.TokenType;
import com.pnfsoftware.jeb.util.encoding.jflex.lexers.PythonLexer;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;

public class StyledTextEditor {
    private static final ILogger logger = GlobalLog.getLogger(StyledTextEditor.class);
    private static final int MODSTACK_MAX_SIZE = 1000;
    private String lang;
    private StyleManager styleman;
    private UIAssetManager aman;
    private StyledText w;
    private List<Mod> modstack = new ArrayList<Mod>();
    private int modptr = 0;
    private int undoing;
    private int tabrepl;
    private boolean dirty;
    boolean dirty0;

    public StyledTextEditor(String lang, StyleManager styleman) {
        this.lang = lang;
        this.styleman = styleman;
        this.aman = UIAssetManager.getInstance();
    }

    public void build(final StyledText w) {
        if (w == null) {
            throw new IllegalArgumentException();
        }
        this.w = w;
        UIUtil.setBetterWordSelector(w);
        w.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledTextEditor.this.applyStyles();
            }
        });
        w.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.stateMask == SWT.MOD1 && e.character == '\r') {
                    e.doit = false;
                }
            }
        });
        w.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (e.stateMask == SWT.MOD1 && e.character == '\r') {
                    e.doit = false;
                    StyledTextEditor.this.onRun();
                }
            }
        });
        w.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (StyledTextEditor.this.tabrepl > 0 && e.text.equals("\t")) {
                    e.text = Strings.spaces(StyledTextEditor.this.tabrepl);
                    return;
                }
                if (e.text.equals(Strings.LINESEP)) {
                    char c;
                    int i;
                    int offset = w.getCaretOffset();
                    int lineIndex = w.getLineAtOffset(w.getCaretOffset());
                    int lineOffset = w.getOffsetAtLine(lineIndex);
                    if (lineOffset == offset) {
                        return;
                    }
                    String line = w.getLine(lineIndex);
                    StringBuilder indent = new StringBuilder();
                    for (i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
                        indent.append(c);
                    }
                    if (i > 0 && i < line.length()) {
                        e.text = e.text + indent.toString();
                    }
                }
            }
        });
        w.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledTextEditor.this.setDirty(true);
            }
        });
        w.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                Mod mod = new Mod(e.start, e.length, e.replacedText);
                if (StyledTextEditor.this.undoing == 1) {
                    StyledTextEditor.this.modstack.set(StyledTextEditor.this.modptr, mod);
                } else if (StyledTextEditor.this.undoing == -1) {
                    StyledTextEditor.this.modstack.set(StyledTextEditor.this.modptr - 1, mod);
                } else {
                    while (StyledTextEditor.this.modptr < StyledTextEditor.this.modstack.size()) {
                        StyledTextEditor.this.modstack.remove(StyledTextEditor.this.modptr);
                    }
                    StyledTextEditor.this.modstack.add(mod);
                    ++StyledTextEditor.this.modptr;
                    if (StyledTextEditor.this.modstack.size() > 1000) {
                        StyledTextEditor.this.modstack.remove(0);
                        --StyledTextEditor.this.modptr;
                    }
                }
            }
        });
        w.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == SWT.MOD1) {
                    if (e.keyCode == 115) {
                        StyledTextEditor.this.onSave();
                    } else if (e.keyCode == 97) {
                        w.selectAll();
                    } else if (e.keyCode == 122) {
                        StyledTextEditor.this.undo();
                    } else if (e.keyCode == 121) {
                        StyledTextEditor.this.redo();
                    }
                }
            }
        });
        w.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
                int off = event.caretOffset;
                int line = w.getLineAtOffset(off);
                int disp = off - w.getOffsetAtLine(line);
                StyledTextEditor.this.onCaretMoved(line + 1, disp + 1);
            }
        });
    }

    public StyledText getWidget() {
        return this.w;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (this.dirty0 != dirty) {
            this.dirty0 = dirty;
            this.onDirtyChanged(dirty);
        }
    }

    public void setTabSpaces(int cnt) {
        this.tabrepl = cnt;
    }

    public int getTabSpaces() {
        return this.tabrepl;
    }

    public void resetUndoStack() {
        this.modstack.clear();
        this.modptr = 0;
        this.undoing = 0;
    }

    public void undo() {
        Mod mod;
        block7: {
            if (this.modptr == 0) {
                return;
            }
            --this.modptr;
            mod = this.modstack.get(this.modptr);
            this.undoing = 1;
            try {
                this.w.replaceTextRange(mod.start, mod.length, mod.inserted);
            }
            catch (Exception ex) {
                if (RcpClientContext.getInstance() != null) {
                    this.modstack.clear();
                    this.modptr = 0;
                    RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(ex);
                    break block7;
                }
                throw ex;
            }
            finally {
                this.undoing = 0;
            }
        }
        this.w.setCaretOffset(mod.start + mod.inserted.length());
    }

    public void redo() {
        Mod mod;
        block7: {
            if (this.modptr == this.modstack.size()) {
                return;
            }
            mod = this.modstack.get(this.modptr);
            ++this.modptr;
            this.undoing = -1;
            try {
                this.w.replaceTextRange(mod.start, mod.length, mod.inserted);
            }
            catch (Exception ex) {
                if (RcpClientContext.getInstance() != null) {
                    this.modstack.clear();
                    this.modptr = 0;
                    RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(ex);
                    break block7;
                }
                throw ex;
            }
            finally {
                this.undoing = 0;
            }
        }
        this.w.setCaretOffset(mod.start + mod.inserted.length());
    }

    public void applyStyles() {
        List<Token> tokens;
        if (this.styleman == null) {
            return;
        }
        if (!"py".equals(this.lang)) {
            return;
        }
        String buffer = this.w.getText();
        PythonLexer parser = new PythonLexer();
        try {
            tokens = parser.parse(buffer);
        }
        catch (Exception exception) {
            tokens = Collections.emptyList();
        }
        ArrayList<StyleRange> srlist = new ArrayList<StyleRange>();
        for (Token token : tokens) {
            StyleInfo si;
            ItemClassIdentifiers id = StyledTextEditor.jflexTokenTypeToClassId(token.type);
            if (id == null || (si = this.styleman.getStyle(id)) == null && (si = this.styleman.getStyle(ItemClassIdentifiers.DEFAULT)) == null) continue;
            Color fg = null;
            if (si.getForegroundColor() != null) {
                fg = this.aman.getColor(si.getForegroundColor());
            }
            Color bg = null;
            if (si.getBackgroundColor() != null) {
                bg = this.aman.getColor(si.getBackgroundColor());
            }
            StyleRange sr = new StyleRange((int)token.start, token.length, fg, bg);
            srlist.add(sr);
        }
        this.w.setStyleRanges(srlist.toArray(new StyleRange[srlist.size()]));
    }

    public static ItemClassIdentifiers jflexTokenTypeToClassId(TokenType tokenType) {
        switch (tokenType) {
            case COMMENT: 
            case COMMENT2: {
                return ItemClassIdentifiers.COMMENT;
            }
            case IDENTIFIER: {
                return ItemClassIdentifiers.IDENTIFIER;
            }
            case KEYWORD: 
            case KEYWORD2: {
                return ItemClassIdentifiers.KEYWORD;
            }
            case NUMBER: {
                return ItemClassIdentifiers.NUMBER;
            }
            case REGEX: 
            case REGEX2: 
            case STRING: 
            case STRING2: {
                return ItemClassIdentifiers.STRING;
            }
            case TYPE: 
            case TYPE2: {
                return ItemClassIdentifiers.CLASS_NAME;
            }
        }
        return null;
    }

    protected void onRun() {
    }

    protected void onSave() {
    }

    protected void onCaretMoved(int row, int col) {
    }

    protected void onDirtyChanged(boolean dirty) {
    }

    public String formatModstack() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Mod e : this.modstack) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i == this.modptr) {
                sb.append("*");
            }
            sb.append(e.toString());
            ++i;
        }
        if (i == this.modptr) {
            sb.append("*");
        }
        return sb.toString();
    }

    public void logmodstack() {
        this.formatModstack();
        Object[] cfr_ignored_0 = new Object[0];
    }

    static class Mod {
        int start;
        int length;
        String inserted;

        public Mod(int start, int length, String inserted) {
            this.start = start;
            this.length = length;
            this.inserted = inserted;
        }

        public String toString() {
            return Strings.ff("%d:%d:'%s'", this.start, this.length, this.inserted);
        }
    }
}

