/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.extensions.IImageSource;
import com.pnfsoftware.jeb.util.events.EventSource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class StaticImageDocument
extends EventSource
implements IImageSource {
    private Image image;
    private Image bgImage = null;
    private Boolean transparent = null;

    public StaticImageDocument(Image image) {
        this.image = image;
        this.setBackgroundDefaultChessboard();
    }

    @Override
    public Image getImage() {
        if (this.bgImage != null) {
            return this.bgImage;
        }
        return this.image;
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if (this.bgImage != null) {
            this.bgImage.dispose();
            this.bgImage = null;
        }
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setBackgroundColor(RGB rgb, int alpha) {
        if (rgb == null) {
            this.bgImage.dispose();
            this.bgImage = null;
            return;
        }
        if (this.transparent == Boolean.FALSE) {
            return;
        }
        ImageData imgData = this.image.getImageData();
        if (!StaticImageDocument.paletteCheck(imgData.palette, rgb)) {
            this.transparent = Boolean.FALSE;
            return;
        }
        int pix = imgData.palette.getPixel(rgb);
        for (int x = 0; x < this.image.getBounds().width; ++x) {
            for (int y = 0; y < this.image.getBounds().height; ++y) {
                if (imgData.getAlpha(x, y) != 0) continue;
                this.transparent = Boolean.TRUE;
                imgData.setAlpha(x, y, 100);
                imgData.setPixel(x, y, pix);
            }
        }
        if (this.transparent == null) {
            this.transparent = Boolean.FALSE;
            return;
        }
        if (this.bgImage != null) {
            this.bgImage.dispose();
        }
        this.bgImage = new Image(this.image.getDevice(), imgData);
    }

    public void setBackgroundDefaultChessboard() {
        this.setBackgroundChessboard(new RGB(80, 80, 80), new RGB(120, 120, 120), 14, 255);
    }

    public void setBackgroundChessboard(RGB rgb1, RGB rgb2, int squareSize, int alpha) {
        if (rgb1 == null || rgb2 == null) {
            this.bgImage.dispose();
            this.bgImage = null;
            return;
        }
        if (this.transparent == Boolean.FALSE) {
            return;
        }
        ImageData imgData = this.image.getImageData();
        if (!StaticImageDocument.paletteCheck(imgData.palette, rgb1, rgb2)) {
            this.transparent = Boolean.FALSE;
            return;
        }
        int pix1 = imgData.palette.getPixel(rgb1);
        int pix2 = imgData.palette.getPixel(rgb2);
        int modulo = squareSize * 2;
        for (int x = 0; x < this.image.getBounds().width; ++x) {
            for (int y = 0; y < this.image.getBounds().height; ++y) {
                if (imgData.getAlpha(x, y) != 0) continue;
                this.transparent = Boolean.TRUE;
                imgData.setAlpha(x, y, alpha);
                imgData.setPixel(x, y, this.determinePixelChessboard(x, y, squareSize, modulo, pix1, pix2));
            }
        }
        if (this.transparent == null) {
            this.transparent = Boolean.FALSE;
            return;
        }
        if (this.bgImage != null) {
            this.bgImage.dispose();
        }
        this.bgImage = new Image(this.image.getDevice(), imgData);
    }

    private int determinePixelChessboard(int x, int y, int squareSize, int modulo, int pix1, int pix2) {
        int xMod = x % modulo;
        int yMod = y % modulo;
        return xMod < squareSize && yMod < squareSize || xMod >= squareSize && yMod >= squareSize ? pix1 : pix2;
    }

    private static boolean paletteCheck(PaletteData palette, RGB rgb) {
        RGB[] list = palette.getRGBs();
        if (list != null) {
            for (RGB e : list) {
                if (!rgb.equals((Object)e)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean paletteCheck(PaletteData palette, RGB rgb1, RGB rgb2) {
        RGB[] list = palette.getRGBs();
        if (list != null) {
            int found = 0;
            for (RGB e : list) {
                if (!(rgb1.equals((Object)e) ? (found |= 1) == 3 : rgb2.equals((Object)e) && (found |= 2) == 3)) continue;
                return true;
            }
        }
        return false;
    }
}

