/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.core.exceptions.JebRuntimeException;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ShellActivationTracker
implements Listener {
    private static final ILogger logger = GlobalLog.getLogger(ShellActivationTracker.class);
    private Display display;
    private Shell shell;
    private Shell mainShell;

    public ShellActivationTracker(Display display) {
        this.display = display;
        this.set(display.getActiveShell());
        display.addFilter(26, (Listener)this);
    }

    public void dispose() {
        this.display.removeFilter(26, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof Shell) {
            this.set((Shell)event.widget);
        }
    }

    public void setMainShell(Shell mainShell) {
        this.mainShell = mainShell;
    }

    public Shell getMainShell() {
        if (this.mainShell == null) {
            Shell main;
            Shell parent = main = this.get();
            while (parent != null) {
                main = parent;
                parent = (Shell)main.getParent();
            }
            this.mainShell = main;
        }
        return this.mainShell;
    }

    private void set(Shell shell) {
        if (shell == null) {
            Object[] cfr_ignored_0 = new Object[0];
        } else if (this.shell == null) {
            (new Object[1])[0] = shell;
        }
        this.shell = shell;
    }

    public Shell get() {
        if (!UIUtil.isUIThread(this.display)) {
            logger.catchingSilent(new JebRuntimeException("Trying to retrieve shell in a non ui-thread"));
            return null;
        }
        Shell r = this.display.getActiveShell();
        if (r == null) {
            r = this.shell;
        }
        if ((r == null || r.isDisposed()) && this.mainShell != null) {
            r = this.mainShell;
        }
        if (r == null || r.isDisposed()) {
            Shell[] shells;
            r = null;
            for (Shell s : shells = Display.getDefault().getShells()) {
                if (s.isDisposed()) continue;
                r = s;
                break;
            }
        }
        return r;
    }
}

