/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.GridDataMaker;
import com.pnfsoftware.jeb.rcpclient.extensions.StyledTextEditor;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ScriptEditorDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(ScriptEditorDialog.class);
    StyledTextEditor editor;
    StyledText w;
    String textLabel = "JEB scripts must be written using the Python 2.7 syntax.";
    File file;
    RcpClientContext context;
    String initialContents;
    Label wCaret;

    public ScriptEditorDialog(Shell parent, File file, RcpClientContext context) {
        super(parent, 2160, (String)(file == null ? "Script Editor" : file.getPath() + " - Script Editor"), null);
        this.file = file;
        this.context = context;
        StyleManager styleman = context == null ? new StyleManager(null, null) : context.getStyleManager();
        this.editor = new StyledTextEditor("py", styleman){

            @Override
            public void onSave() {
                ScriptEditorDialog.this.save();
            }

            @Override
            protected void onRun() {
                ScriptEditorDialog.this.run();
            }

            @Override
            protected void onCaretMoved(int row, int col) {
                ScriptEditorDialog.this.caretMoved(row, col);
            }

            @Override
            protected void onDirtyChanged(boolean dirty) {
                Object text = ScriptEditorDialog.this.getShell().getText();
                if (dirty) {
                    if (((String)text).startsWith("* ")) {
                        return;
                    }
                    text = "* " + (String)text;
                } else {
                    if (!((String)text).startsWith("* ")) {
                        return;
                    }
                    text = ((String)text).substring(2);
                }
                ScriptEditorDialog.this.getShell().setText((String)text);
            }
        };
    }

    public File getFile() {
        return this.file;
    }

    public StyledTextEditor getEditor() {
        return this.editor;
    }

    @Override
    public final void createContents(Composite parent) {
        GridData data;
        UIUtil.setStandardLayout(parent);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (!ScriptEditorDialog.this.askSave()) {
                    e.doit = false;
                }
            }
        });
        if (this.textLabel != null) {
            new Label(parent, 0).setText(this.textLabel);
        }
        this.w = new StyledText(parent, 2818);
        this.editor.build(this.w);
        this.w.setEditable(true);
        Font font = UIUtil.getCodeFont();
        this.w.setFont(font);
        new GridData();
        int colcount = 100;
        int linecount = 50;
        GC gc = new GC((Drawable)this.w);
        try {
            gc.setFont(this.w.getFont());
            FontMetrics fm = gc.getFontMetrics();
            data = new GridData((int)((double)colcount * fm.getAverageCharacterWidth()), linecount * fm.getHeight());
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.w.setLayoutData((Object)data);
        if (this.file != null && this.file.isFile()) {
            String buffer;
            try {
                buffer = Strings.decodeLocal(IO.readFile(this.file));
            }
            catch (IOException iOException) {
                buffer = "# error: cannot read file";
            }
            this.w.setText(buffer);
        } else if (this.initialContents != null) {
            this.w.setText(this.initialContents);
        }
        this.editor.resetUndoStack();
        this.editor.setDirty(false);
        this.wCaret = UIUtil.createLabelInGridLayout(parent, 0, "                      ", 1);
        this.wCaret.setLayoutData((Object)GridDataMaker.create().setGrabExcessHorizontalSpace(true).data());
        this.createButtons(parent, new int[]{32, 8192, 0x30000000}, 32);
        this.getButtonByStyle(8192).setToolTipText(UI.isMac ? "Command + S" : "CTRL + S");
        this.getButtonByStyle(0x30000000).setToolTipText(UI.isMac ? "Command + Enter" : "CTRL + Enter");
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.shell.close();
        } else if (buttonId == 8192) {
            this.save();
        } else if (buttonId == 0x30000000) {
            this.run();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 32) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Execute";
        }
        return defaultBtnText;
    }

    public void setContents(String s) {
        if (this.w == null) {
            this.initialContents = s;
        } else {
            this.w.setText(s);
            this.editor.applyStyles();
        }
    }

    boolean askSave() {
        if (this.editor.isDirty()) {
            Boolean r = UI.questionWithCancel(this.getShell(), "Content modified", "Save the updates before exiting the editor?");
            if (r == null) {
                return false;
            }
            if (r.booleanValue()) {
                this.save();
            }
        }
        return true;
    }

    boolean save() {
        if (this.file == null) {
            FileDialog dlg = new FileDialog(this.getShell(), 8192);
            dlg.setFilterExtensions(new String[]{"*.py"});
            String path = dlg.open();
            if (path == null) {
                return false;
            }
            this.file = new File(path);
        }
        String buffer = this.w.getText();
        try {
            IO.writeFile(this.file, Strings.encodeLocal(buffer));
            this.editor.setDirty(false);
            return true;
        }
        catch (IOException iOException) {
            UI.error("Writing failed!");
            return false;
        }
    }

    boolean run() {
        if (this.context == null) {
            return false;
        }
        if (!this.save()) {
            return false;
        }
        return this.context.executeScript(this.getShell(), this.file.getPath());
    }

    void caretMoved(int row, int col) {
        this.wCaret.setText(Strings.ff("%d:%d", row, col));
    }
}

