/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.Assets;
import java.io.InputStream;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public class MenuUtil {
    public static MenuManager createAutoRefreshMenu(String name) {
        return MenuUtil.createAutoRefreshMenu(name, null);
    }

    public static MenuManager createAutoRefreshMenu(String name, final String icon) {
        MenuManager menu = new MenuManager(name, null);
        if (icon != null) {
            menu.setImageDescriptor(new ImageDescriptor(){

                @Override
                public ImageData getImageData() {
                    InputStream is = Assets.getAsset(icon);
                    if (is == null) {
                        return null;
                    }
                    ImageData data = new ImageData(is);
                    if (data.width != 16 && data.height != 16) {
                        data = data.scaledTo(16, 16);
                    }
                    return data;
                }
            });
        }
        menu.addMenuListener(new IMenuListener(){

            @Override
            public void menuAboutToShow(IMenuManager manager) {
                for (IContributionItem item : manager.getItems()) {
                    item.update();
                }
            }
        });
        return menu;
    }
}

