/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.extensions.IImageSource;
import com.pnfsoftware.jeb.rcpclient.extensions.StaticImageDocument;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.WebImageViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ImageView;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import com.pnfsoftware.jeb.util.events.Event;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ImageViewer
extends Viewer {
    private static final ILogger logger = GlobalLog.getLogger(ImageViewer.class);
    private IImageSource input;
    private IEventListener inputListener;
    private EventSource eventSource;
    private Composite container;
    private ImageView widget;
    private ViewerRefresher refresher = null;

    public ImageViewer(Composite parent) {
        this.container = parent;
        this.eventSource = new EventSource();
    }

    public ImageView getControl() {
        return this.widget;
    }

    @Override
    public IImageSource getInput() {
        return this.input;
    }

    @Override
    public void refresh() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        if (this.input != null) {
            this.widget = new ImageView(this.container, this.input.getImage(), false);
            this.eventSource.notifyListeners(new Event(1, (Object)this.widget));
            this.container.layout();
        }
    }

    @Override
    public void setInput(Object input) {
        if (this.inputListener != null) {
            this.input.removeListener(this.inputListener);
            this.inputListener = null;
        }
        if (this.refresher == null) {
            this.refresher = new ViewerRefresher(this.container.getDisplay(), this);
        }
        if (input instanceof IImageSource) {
            this.input = (IImageSource)input;
            this.inputListener = new IEventListener(){

                @Override
                public void onEvent(IEvent e) {
                    (new Object[1])[0] = e;
                    ImageViewer.this.refresher.request();
                }
            };
            this.input.addListener(this.inputListener);
        } else if (input instanceof IWebBrowserSource && UIUtil.canUseBrowser(this.container)) {
            new WebImageViewer(this.container, (IWebBrowserSource)input, image -> {
                StaticImageDocument img = new StaticImageDocument((Image)image);
                this.setInput(img);
                this.container.addDisposeListener(e -> img.dispose());
            });
        }
        this.refresh();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
    }

    @Override
    public ISelection getSelection() {
        return null;
    }

    public void addWidgetChangeListener(IEventListener listener) {
        this.eventSource.addListener(listener);
    }
}

