/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.Operation;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.operations.AbstractOperation;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.OperationCopy;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Control;

public class ContextMenuFilter
implements IContextMenu {
    private Viewer viewer;
    private IFilterText filterText;
    private IFilteredLabelProvider valueProvider;
    private String[] filterLabels;
    private Boolean[] displayPrefixes;

    public static ContextMenu addContextMenu(ColumnViewer viewer, IFilterText filterText, IFilteredLabelProvider valueProvider, String[] filterLabels, Boolean[] displayPrefix) {
        return ContextMenuFilter.addContextMenu(viewer, filterText, valueProvider, filterLabels, displayPrefix, null);
    }

    public static ContextMenu addContextMenu(Viewer viewer, IFilterText filterText, IFilteredLabelProvider valueProvider, String[] filterLabels, Boolean[] displayPrefix, IContextMenu contextMenu) {
        ContextMenu contextMenuMgr = new ContextMenu(viewer.getControl());
        if (contextMenu != null) {
            contextMenuMgr.addContextMenu(contextMenu);
        }
        ContextMenuFilter cmf = new ContextMenuFilter(viewer, filterText, valueProvider, filterLabels, displayPrefix);
        contextMenuMgr.addContextMenu(cmf);
        return contextMenuMgr;
    }

    public static ContextMenu addCopyEntry(ContextMenu ctxMenu, Control control, final IOperable operable) {
        ctxMenu.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(new Separator());
                menuMgr.add(new OperationCopy(operable));
            }
        });
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean success;
                OperationRequest op;
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 99 && operable.verifyOperation(op = new OperationRequest(Operation.COPY)) && (success = operable.doOperation(op))) {
                    e.doit = false;
                }
            }
        });
        return ctxMenu;
    }

    public static ContextMenu addEntry(ContextMenu ctxMenu, Control control, final AbstractOperation operation) {
        ctxMenu.addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuMgr) {
                menuMgr.add(operation);
            }
        });
        return ctxMenu;
    }

    protected ContextMenuFilter(Viewer viewer, IFilterText filterText, IFilteredLabelProvider valueProvider, String[] filterLabels, Boolean[] displayPrefixes) {
        this.viewer = viewer;
        this.filterText = filterText;
        this.valueProvider = valueProvider;
        this.filterLabels = filterLabels;
        this.displayPrefixes = displayPrefixes;
    }

    @Override
    public void fillContextMenu(IMenuManager menuMgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        if (element == null || this.valueProvider == null || this.filterLabels == null) {
            return;
        }
        for (int i = 0; i < this.filterLabels.length; ++i) {
            if (this.filterLabels[i] == null || this.valueProvider.getStringAt(element, i) == null) continue;
            boolean displayPrefix = true;
            if (this.displayPrefixes != null && i < this.displayPrefixes.length) {
                displayPrefix = this.displayPrefixes[i];
            }
            menuMgr.add(new FilterAction(this.filterLabels[i], i, displayPrefix));
        }
    }

    private class FilterAction
    extends Action {
        private int filterLabelIndex;
        private boolean displayPrefix;
        private String columnName;

        public FilterAction(String columnName, int filterLabelIndex, boolean displayPrefix) {
            super("Filter same " + columnName);
            this.setEnabled(true);
            this.filterLabelIndex = filterLabelIndex;
            this.displayPrefix = displayPrefix;
            this.columnName = columnName;
        }

        @Override
        public void run() {
            String newFilterValue;
            IStructuredSelection selection = (IStructuredSelection)ContextMenuFilter.this.viewer.getSelection();
            Object elt0 = selection.getFirstElement();
            if (elt0 != null && (newFilterValue = ContextMenuFilter.this.valueProvider.getStringAt(elt0, this.filterLabelIndex)) != null) {
                ContextMenuFilter.this.filterText.submitText(this.displayPrefix ? this.addSearchPrefix(newFilterValue) : newFilterValue);
            }
        }

        protected String addSearchPrefix(String value) {
            if (Strings.isBlank(this.columnName)) {
                return value;
            }
            return this.columnName.toLowerCase() + ":\"" + value.replace("\"", "\\\"") + "\"";
        }
    }
}

