/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorUtil {
    public static Color popC(Color c) {
        return ColorUtil.transformC(c, -50, null, 30);
    }

    public static Color transformC(Color c, Integer hueAngle, Integer satShift, Integer lumShift) {
        if (hueAngle != null && (hueAngle < -360 || hueAngle > 360)) {
            throw new IllegalArgumentException();
        }
        if (satShift != null && (satShift < -100 || satShift > 100)) {
            throw new IllegalArgumentException();
        }
        if (lumShift != null && (lumShift < -100 || lumShift > 100)) {
            throw new IllegalArgumentException();
        }
        float[] r = c.getRGB().getHSB();
        double hue = r[0];
        if (hueAngle != null) {
            if ((hue += (double)hueAngle.intValue()) > 360.0) {
                hue -= 360.0;
            } else if (hue < 0.0) {
                hue += 360.0;
            }
        }
        double sat = r[1];
        if (satShift != null) {
            if ((sat += (double)satShift.intValue() / 100.0) > 1.0) {
                hue -= 1.0;
            } else if (sat < 0.0) {
                sat += 1.0;
            }
        }
        double lum = r[2];
        if (lumShift != null) {
            if ((lum += (double)lumShift.intValue() / 100.0) > 1.0) {
                lum -= 1.0;
            } else if (lum < 0.0) {
                lum += 1.0;
            }
        }
        return UIAssetManager.getInstance().getColor(new RGB((float)hue, (float)sat, (float)lum));
    }
}

