/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.other;

import com.pnfsoftware.jeb.rcpclient.dialogs.other.S7InternalBlock;
import com.pnfsoftware.jeb.rcpclient.util.WinProcessMemSearch;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class S7MemoryBlockFinder
extends WinProcessMemSearch {
    private static final ILogger logger = GlobalLog.getLogger(S7MemoryBlockFinder.class);
    private Map<String, S7InternalBlock> map = new TreeMap<String, S7InternalBlock>();

    public Collection<S7InternalBlock> getBlocks() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public boolean filterProcessName(String name) {
        int i = name.lastIndexOf(47);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        if ((i = name.lastIndexOf(92)) >= 0) {
            name = name.substring(i + 1);
        }
        return (name = name.toLowerCase()).startsWith("s7") && name.endsWith(".exe");
    }

    @Override
    public void examineBuffer(ByteBuffer b, long processRegionAddress, int processID, String processName) {
        b.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 8; i <= b.limit() - 80; ++i) {
            S7InternalBlock blk;
            int off0;
            int off1;
            int bs = b.getInt(i);
            int s1 = b.getInt(i + 4);
            int s2 = b.getInt(i + 8);
            int s3 = b.getInt(i + 12);
            if (bs <= 78 || bs >= 0xFFFFFF || s1 >= 0xFFFFFF || s2 >= 0xFFFFFF || s3 >= 0xFFFFFF || bs != 78 + s1 + s2 + s3 || (off1 = (off0 = i - 8) + bs) > b.limit()) continue;
            int lang = b.get(off0) & 0xFF;
            int blktype = b.get(off0 + 2) & 0xFF;
            if (lang < 1 || lang > 10 || blktype < 8 || blktype > 15) continue;
            b.position(off0);
            byte[] data = new byte[bs];
            b.get(data);
            try {
                blk = new S7InternalBlock(data);
            }
            catch (Exception exception) {
                continue;
            }
            String name = blk.getName();
            S7InternalBlock blk0 = this.map.get(name);
            if (blk0 != null && blk0.tsMod >= blk.tsMod) continue;
            this.map.put(name, blk);
        }
    }
}

