/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.other;

import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.EndianUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;

public class S7InternalBlock {
    static final ILogger logger = GlobalLog.getLogger(S7InternalBlock.class);
    public static final int HDRSIZE = 78;
    byte[] data;
    int sourceLanguageId;
    int typeId;
    int number;
    int formatVersion_MAYBE;
    int blockSize;
    int codeOffset;
    int codeSize;
    int interfaceOffset;
    int interfaceSize;
    int otherOffset;
    int otherSize;
    long tsMod;
    long tsInterfaceMod;
    int key;
    String blockName;
    String familyName;
    String authorName;
    int verMaj;
    int verMin;
    int crc;

    public S7InternalBlock(byte[] data) {
        this.data = data;
        this.sourceLanguageId = EndianUtil.littleEndianBytesToShort(data, 0) & 0xFFFF;
        this.typeId = EndianUtil.littleEndianBytesToShort(data, 2) & 0xFFFF;
        this.number = EndianUtil.littleEndianBytesToShort(data, 4) & 0xFFFF;
        this.formatVersion_MAYBE = EndianUtil.littleEndianBytesToShort(data, 6) & 0xFFFF;
        this.blockSize = EndianUtil.littleEndianBytesToShort(data, 8) & 0xFFFF;
        this.codeSize = EndianUtil.littleEndianBytesToInt(data, 12);
        this.codeOffset = 78;
        this.interfaceSize = EndianUtil.littleEndianBytesToInt(data, 16);
        this.interfaceOffset = 78 + this.codeSize;
        this.otherSize = EndianUtil.littleEndianBytesToInt(data, 20);
        this.otherOffset = 78 + this.codeSize + this.interfaceSize;
        this.tsMod = this.readTimestamp(data, 26);
        this.tsInterfaceMod = this.readTimestamp(data, 32);
        this.key = EndianUtil.littleEndianBytesToInt(data, 20);
        this.blockName = this.readString8(data, 58);
        this.familyName = this.readString8(data, 50);
        this.authorName = this.readString8(data, 42);
        this.verMaj = data[66] >> 4 & 0xF;
        this.verMin = data[66] & 0xF;
        this.crc = EndianUtil.littleEndianBytesToInt(data, 68);
    }

    protected String readString8(byte[] data, int offset) {
        return S7InternalBlock.readFixedString(8, data, offset);
    }

    public static String readFixedString(int maxlen, byte[] data, int offset) {
        char c;
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < offset + maxlen && (c = (char)(data[i] & 0xFF)) != '\u0000'; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    protected long readTimestamp(byte[] data, int offset) {
        int x = EndianUtil.bigEndianBytesToInt(data, offset);
        Assert.a(x >= 0 && x < 86400000);
        short d = EndianUtil.bigEndianBytesToShort(data, offset + 4);
        long ts = (441763200L + (long)d * 86400L) * 1000L + (long)x;
        return ts;
    }

    public LangType getSourceLanguage() {
        return LangType.fromId(this.sourceLanguageId);
    }

    public BlockType getType() {
        return BlockType.fromId(this.typeId);
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return S7InternalBlock.generateName(this.getType(), this.getNumber());
    }

    public static String generateName(BlockType type, int number) {
        return Strings.ff("%s%d", type == null ? "?" : type.toString(), number);
    }

    public String toString() {
        return Strings.ff("%s%d, version %d.%d, programmed in %s, modified on %s, interface modified on %s", new Object[]{this.getType(), this.number, this.verMaj, this.verMin, this.getSourceLanguage(), TimeFormatter.formatTimestampLocal(this.tsMod), TimeFormatter.formatTimestampLocal(this.tsInterfaceMod)});
    }

    public static enum LangType {
        UNKNOWN(0),
        STL(1),
        LAD(2),
        FBD(3),
        SCL(4),
        DB(5),
        GRAPH(6);

        final int id;

        private LangType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static LangType fromId(int id) {
            for (LangType e : LangType.values()) {
                if (e.id != id) continue;
                return e;
            }
            return UNKNOWN;
        }
    }

    public static enum BlockType {
        UNKNOWN(0, -1),
        DI(5, 5),
        OB(8, 0),
        DB(10, 6),
        SDB(11, 7),
        FC(12, 2),
        SFC(13, 4),
        FB(14, 1),
        SFB(15, 3);

        final int id;
        final int priority;

        private BlockType(int id, int priority) {
            this.id = id;
            this.priority = priority;
        }

        public int getId() {
            return this.id;
        }

        public int getPriority() {
            return this.priority;
        }

        public static BlockType fromId(int id) {
            for (BlockType e : BlockType.values()) {
                if (e.id != id) continue;
                return e;
            }
            return UNKNOWN;
        }
    }
}

