/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.other;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.other.S7InternalBlock;
import com.pnfsoftware.jeb.rcpclient.dialogs.other.S7MemoryBlockFinder;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.format.TimeFormatter;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class S7BlkAcqDialog
extends DataFrameDialog {
    private static final ILogger logger = GlobalLog.getLogger(S7BlkAcqDialog.class);
    private RcpClientContext context;
    private List<S7InternalBlock> entries;
    private String path;
    private int selectedIndex = -1;
    private static final String S7_FILE_EXT = ".s7blk";
    private static final String S7_ARCHIVE_EXT = ".s7zip";

    public S7BlkAcqDialog(Shell parent, RcpClientContext context) {
        super(parent, "S7 PLC Block Acquisition", true, null);
        this.context = context;
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("PLC block acquisition module for Simatic S7-300/400 CPUs.\nOpen your Step7 editor, connect your PLC, and upload the blocks from the PLC CPU to this PG/PC (programming device).\nThen, refresh the view. S7 blocks will be searched for and can be acquired to create a new project.\nThis acquisition module may find more blocks than shown in the Step7 interface (hidden blocks should be detected).\nYou will find more help in the usage manual \"S7 PLC block decompiler extension for JEB\".\n", new Object[0]);
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public String getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex).getName();
    }

    public String getFilePath() {
        return this.path;
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000, 0x50000000, 0x60000000, 0x70000000}, 32);
        this.hideButton(32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Refresh";
        }
        if (btnId == 0x40000000) {
            return "Download All";
        }
        if (btnId == 0x50000000) {
            return "Download Selected";
        }
        if (btnId == 0x60000000) {
            return "Create Project From All";
        }
        if (btnId == 0x70000000) {
            return "Create Project From Selected";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x30000000) {
            this.reload();
            this.refresh();
        } else if (buttonId == 0x40000000) {
            this.download(null);
        } else if (buttonId == 0x50000000) {
            this.download(this.getSelectedRows());
        } else if (buttonId == 0x60000000) {
            this.path = this.download(null);
            if (this.path != null) {
                this.shell.close();
            }
        } else if (buttonId == 0x70000000) {
            this.path = this.download(this.getSelectedRows());
            if (this.path != null) {
                this.shell.close();
            }
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private String download(List<Integer> indices) {
        ArrayList<S7InternalBlock> blocks;
        if (indices == null) {
            blocks = new ArrayList<S7InternalBlock>(this.entries);
        } else {
            blocks = new ArrayList(indices.size());
            for (int i : indices) {
                blocks.add(this.entries.get(i));
            }
        }
        if (blocks.isEmpty()) {
            return null;
        }
        int cnt = blocks.size();
        String ext = cnt == 1 ? S7_FILE_EXT : S7_ARCHIVE_EXT;
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFilterExtensions(new String[]{"*" + ext});
        dlg.setFileName("extracted" + ext);
        String path = dlg.open();
        if (path == null) {
            return null;
        }
        if (cnt == 1) {
            File f = new File(path);
            try {
                IO.writeFile(f, ((S7InternalBlock)blocks.get((int)0)).data);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        File folder = null;
        try {
            folder = IO.createTempFolder(null);
            folder.deleteOnExit();
            for (S7InternalBlock blk : blocks) {
                File f = new File(folder, blk.getName() + S7_FILE_EXT);
                IO.writeFile(f, blk.data);
            }
            IO.compressFolder(folder.getPath(), path);
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
        finally {
            if (folder != null) {
                IO.deleteDirectory(folder);
            }
        }
        if (cnt > 0 && this.context != null) {
            this.context.getTelemetry().record("s7_blocks_acquired", "block_count", "" + cnt);
        }
        UI.info(this.getShell(), "Success", Strings.ff("%d %s were collected.", cnt, PluralFormatter.countS(cnt, "block")));
        return path;
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame("Block", "Name", "Author", "Family", "Last mod", "Interface mod", "Language");
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = new ArrayList<S7InternalBlock>();
        try {
            S7MemoryBlockFinder finder = new S7MemoryBlockFinder();
            if (finder.search()) {
                this.entries = new ArrayList<S7InternalBlock>(finder.getBlocks());
            }
        }
        catch (Exception ex) {
            logger.catching(ex);
            return;
        }
        for (S7InternalBlock e : this.entries) {
            df.addRow(new Object[]{e.getName(), e.blockName, e.authorName, e.familyName, TimeFormatter.formatTimestampLocal(e.tsMod), TimeFormatter.formatTimestampLocal(e.tsInterfaceMod), e.getSourceLanguage()});
        }
    }
}

