/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.options;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeBoolean;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsChanges;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class OptionsTreeView
extends FilteredTreeView {
    private static final ILogger logger = GlobalLog.getLogger(OptionsTreeView.class);
    private static final String[] titleColumns = new String[]{S.s(667), S.s(779), S.s(247), S.s(815), S.s(268)};
    private final OptionsChanges.Changes changes;

    public static OptionsTreeView build(Composite parent, IPropertyManager pm, OptionsChanges.Changes changes, boolean expandAfterFilter) {
        LabelProvider labelProvider = new LabelProvider();
        return new OptionsTreeView(parent, pm, changes, labelProvider, expandAfterFilter);
    }

    private OptionsTreeView(Composite parent, IPropertyManager pm, OptionsChanges.Changes changes, LabelProvider labelProvider, boolean expandAfterFilter) {
        super(parent, 65664, titleColumns);
        this.changes = changes;
        final PatternTreeViewer viewer = new PatternTreeViewer(this, titleColumns, expandAfterFilter);
        viewer.addContextMenu(labelProvider, new String[]{S.s(667), S.s(779)}, new Boolean[]{Boolean.FALSE, Boolean.TRUE}, null);
        final TreeContentProvider contentProvider = new TreeContentProvider();
        ValueEditingSupport editingSupport = new ValueEditingSupport(viewer.getViewer());
        ColumnViewerToolTipSupport.enableFor(viewer.getViewer());
        changes.listeners.add(new Listener(){

            public void handleEvent(Event event) {
                Object[] data = (Object[])event.data;
                for (PropertyLine prop : contentProvider.propertyLines) {
                    if (!prop.fqname.substring(1).equals(data[0])) continue;
                    prop.value = data[1];
                    prop.display = Objects.toString(data[1]);
                    viewer.getViewer().update(prop, null);
                }
            }
        });
        Tree tree = this.getTree();
        viewer.displayTreeAsTable();
        TreeColumn[] cols = tree.getColumns();
        TreeViewerColumn tcv = new TreeViewerColumn(viewer.getViewer(), cols[3]);
        tcv.setEditingSupport(editingSupport);
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(labelProvider);
        viewer.setInput(pm);
        viewer.expandAll();
        for (TreeColumn col : cols) {
            col.pack();
        }
        cols[0].setWidth(cols[0].getWidth() + 20);
        if (cols[2].getWidth() > 200) {
            cols[2].setWidth(200);
        }
        if (cols[3].getWidth() < 200) {
            cols[3].setWidth(200);
        }
    }

    static class LabelProvider
    extends DefaultStyledCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 5;
        }

        @Override
        public String getToolTipText(Object element) {
            if (element instanceof PropertyLine) {
                PropertyLine line = (PropertyLine)element;
                String desc = line.definition.getDescription();
                if (!Strings.isBlank(desc)) {
                    return desc;
                }
            }
            return null;
        }

        @Override
        public String getStringAt(Object element, int key) {
            return this.getStringAt(element, key, true);
        }

        @Override
        public String getStringAt(Object elt, int index, boolean display) {
            if (elt instanceof IPropertyDefinitionManager && index == 0) {
                String text = ((IPropertyDefinitionManager)elt).getRegion();
                if (text.isEmpty()) {
                    text = "<root>";
                }
                return text;
            }
            if (elt instanceof PropertyLine) {
                PropertyLine line = (PropertyLine)elt;
                if (index == 0) {
                    return display ? line.definition.getName() : line.fqname.substring(1);
                }
                if (index == 1) {
                    return line.definition.getType().getName();
                }
                if (index == 2) {
                    return line.definition.getType().getDefault().toString();
                }
                if (index == 3) {
                    return line.display;
                }
                if (index == 4) {
                    return line.definition.getDescription();
                }
            }
            return null;
        }
    }

    public static class TreeContentProvider
    implements IFilteredTreeContentProvider {
        IPropertyManager pm;
        List<PropertyLine> propertyLines = new ArrayList<PropertyLine>();

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.pm = (IPropertyManager)newInput;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            IPropertyManager pm = (IPropertyManager)inputElement;
            IPropertyDefinitionManager pdm = pm.getPropertyDefinitionManager();
            if (pdm == null) {
                return ArrayUtil.NO_OBJECT;
            }
            return new Object[]{pdm};
        }

        @Override
        public Object getParent(Object element) {
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length != 0;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IPropertyDefinitionManager) {
                IPropertyDefinitionManager pdm = (IPropertyDefinitionManager)parentElement;
                return this.enumerate(this.pm, pdm);
            }
            return ArrayUtil.NO_OBJECT;
        }

        private Object[] enumerate(IPropertyManager pm, IPropertyDefinitionManager pdm) {
            ArrayList<PropertyLine> r = new ArrayList<PropertyLine>();
            for (IPropertyDefinition definition : pdm.getDefinitions()) {
                if (definition.isInternal()) continue;
                PropertyLine line = new PropertyLine();
                line.fqname = pdm.getNamespace() + "." + definition.getName();
                line.definition = definition;
                line.value = pm.getValue(line.fqname, 1, false, true);
                if (line.value != null) {
                    line.display = line.value.toString();
                } else {
                    line.value = pm.getValue(line.fqname, 2, false, true);
                    if (line.value != null) {
                        line.display = "<master>";
                    } else {
                        line.value = pm.getValue(line.fqname, 3, true, true);
                        line.display = line.value != null ? "<default>" : "<error>";
                    }
                }
                r.add(line);
                this.propertyLines.add(line);
            }
            Collections.sort(r, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((PropertyLine)o1).definition.getName().compareTo(((PropertyLine)o2).definition.getName());
                }
            });
            ArrayList<IPropertyDefinitionManager> r2 = new ArrayList<IPropertyDefinitionManager>();
            for (IPropertyDefinitionManager pdmNext : pdm.getChildren()) {
                if (!this.hasProperties(pdmNext)) continue;
                r2.add(pdmNext);
            }
            Collections.sort(r2, new Comparator<IPropertyDefinitionManager>(){

                @Override
                public int compare(IPropertyDefinitionManager o1, IPropertyDefinitionManager o2) {
                    return o1.getRegion().compareTo(o2.getRegion());
                }
            });
            r.addAll(r2);
            return r.toArray();
        }

        private boolean hasProperties(IPropertyDefinitionManager pdm) {
            ArrayList<IPropertyDefinitionManager> tbc = new ArrayList<IPropertyDefinitionManager>();
            tbc.add(pdm);
            while (!tbc.isEmpty()) {
                pdm = (IPropertyDefinitionManager)tbc.remove(0);
                if (!pdm.getDefinitions().isEmpty()) {
                    return true;
                }
                tbc.addAll(pdm.getChildren());
            }
            return false;
        }
    }

    class ValueEditingSupport
    extends EditingSupport {
        ColumnViewer viewer;
        TextCellEditor editor;
        CheckboxCellEditor booleanEditor;

        public ValueEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.viewer = viewer;
            Composite parent = (Composite)viewer.getControl();
            this.editor = new TextCellEditor(parent);
            this.booleanEditor = new CheckboxCellEditor(parent);
        }

        @Override
        protected CellEditor getCellEditor(Object element) {
            if (!(element instanceof PropertyLine)) {
                return null;
            }
            PropertyLine line = (PropertyLine)element;
            if (line.definition.getType() instanceof IPropertyTypeBoolean) {
                return this.booleanEditor;
            }
            return this.editor;
        }

        @Override
        protected boolean canEdit(Object element) {
            return true;
        }

        @Override
        protected Object getValue(Object element) {
            PropertyLine line = (PropertyLine)element;
            if (line.definition.getType() instanceof IPropertyTypeBoolean) {
                return Boolean.valueOf(line.value.toString());
            }
            Object value = ((PropertyLine)element).value;
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        protected void setValue(Object element, Object value) {
            PropertyLine line = (PropertyLine)element;
            if (!line.definition.getType().validate(value)) {
                Object[] cfr_ignored_0 = new Object[0];
                return;
            }
            (new Object[1])[0] = line.fqname;
            line.value = value;
            line.display = value.toString();
            this.viewer.update(element, null);
            OptionsTreeView.this.changes.addChange(line.fqname, value);
        }
    }

    static class PropertyLine {
        public String fqname;
        public IPropertyDefinition definition;
        public Object value;
        public String display;
        public boolean dirty;

        PropertyLine() {
        }

        public String toString() {
            return this.fqname + ": " + this.value;
        }
    }
}

