/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.options;

import com.pnfsoftware.jeb.core.DevPluginClassname;
import com.pnfsoftware.jeb.core.EnginesPropertiesUtil;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsChanges;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsSimpleListener;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsSimpleViewList;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.EditableList;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class OptionsSimpleViewClassname
extends OptionsSimpleViewList {
    private static final ILogger logger = GlobalLog.getLogger(OptionsSimpleViewClassname.class);
    private static final String MESSAGE_TITLE = "Classname";
    private static final String MESSAGE_VERIFY_TITLE = "Verify classname";
    private String classPathProperty;
    private String classPathSeparator;

    public OptionsSimpleViewClassname(OptionsChanges.Changes changes, OptionsSimpleListener listener, String propertyKey, String separator, String classPathProperty, String classPathSeparator) {
        super(changes, listener, propertyKey, separator);
        this.classPathProperty = classPathProperty;
        this.classPathSeparator = classPathSeparator;
    }

    @Override
    protected EditableList build(Composite parent, String label, String value) {
        final EditableList list = super.build(parent, label, value);
        boolean readOnly = this.changes == null;
        final EnginesPropertiesUtil cp = new EnginesPropertiesUtil(readOnly ? null : this.changes.getPropertyManager());
        if (!readOnly) {
            CheckableClassnameProvider provider = new CheckableClassnameProvider(cp);
            list.setData("CHECKABLE", provider);
            list.resetItems(provider.getCheckableList(list, value));
            list.getTable().addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int selected;
                    boolean checked;
                    boolean bl = checked = event.detail == 32;
                    if (!checked) {
                        return;
                    }
                    Table table = (Table)event.widget;
                    for (selected = 0; selected < table.getItemCount() && table.getItem(selected) != event.item; ++selected) {
                    }
                    List<DevPluginClassname> classnames = cp.parseDevPluginClassnames((String)OptionsSimpleViewClassname.this.getProperty());
                    if (selected < 0 || selected >= table.getItemCount()) {
                        logger.error("The change was not recorded!", new Object[0]);
                        return;
                    }
                    DevPluginClassname classname = classnames.get(selected);
                    DevPluginClassname newClassname = new DevPluginClassname(classname.getClassname(), !classname.isEnabled());
                    classnames.remove(selected);
                    classnames.add(selected, newClassname);
                    OptionsSimpleViewClassname.this.changes.addChange(OptionsSimpleViewClassname.this.propertyKey, cp.buildDevPluginClassnames(classnames));
                }
            });
        }
        list.addButton("Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(list.getShell(), OptionsSimpleViewClassname.MESSAGE_TITLE, "Enter the classname:", "", null);
                int result = id.open();
                if (result == 0 && !Strings.isBlank(id.getValue())) {
                    OptionsSimpleViewClassname.this.addClassname(cp, id.getValue());
                    OptionsSimpleViewClassname.this.displayVerifyClassname(id.getValue(), list.getShell());
                }
            }
        }, false);
        list.addButton("Edit...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OptionsSimpleViewClassname.this.onEdit(list, cp);
            }
        }, true);
        this.addRemoveButton(list);
        list.addButton("Verify", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                TableItem[] indices = list.getSelection();
                if (indices == null || indices.length == 0 || indices.length > 1) {
                    return;
                }
                String cname = indices[0].getText();
                OptionsSimpleViewClassname.this.displayVerifyClassname(cname, list.getShell());
            }
        }, true);
        list.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                OptionsSimpleViewClassname.this.onEdit(list, cp);
            }
        });
        return list;
    }

    private void onEdit(EditableList list, EnginesPropertiesUtil cp) {
        TableItem[] indices = list.getSelection();
        if (indices == null || indices.length == 0 || indices.length > 1) {
            return;
        }
        String intialValue = indices[0].getText();
        InputDialog id = new InputDialog(list.getShell(), MESSAGE_TITLE, "Edit the classname:", intialValue, null);
        int result = id.open();
        if (result == 0 && !Strings.isBlank(id.getValue())) {
            this.updateClassname(cp, list.getSelectionIndices()[0], id.getValue());
            this.displayVerifyClassname(id.getValue(), list.getShell());
        }
    }

    private void addClassname(EnginesPropertiesUtil cp, String classname) {
        List<DevPluginClassname> classnames = cp.parseDevPluginClassnames((String)this.getProperty());
        DevPluginClassname classnameObj = new DevPluginClassname(classname, true);
        classnames.add(classnameObj);
        this.changes.addChange(this.propertyKey, cp.buildDevPluginClassnames(classnames));
    }

    private void updateClassname(EnginesPropertiesUtil cp, int position, String value) {
        List<DevPluginClassname> classnames = cp.parseDevPluginClassnames((String)this.getProperty());
        DevPluginClassname old = classnames.remove(position);
        classnames.add(position, new DevPluginClassname(value, old.isEnabled()));
        this.changes.addChange(this.propertyKey, cp.buildDevPluginClassnames(classnames));
    }

    private void displayVerifyClassname(String classname, Shell shell) {
        if (this.verifyClassname(classname)) {
            MessageDialog.openInformation(shell, MESSAGE_VERIFY_TITLE, "Classname was found in specified classpath");
        } else {
            MessageDialog.openError(shell, MESSAGE_VERIFY_TITLE, "Classname can not be found in specified classpath");
        }
    }

    private boolean verifyClassname(String classname) {
        String[] values = OptionsSimpleViewClassname.getItems(this.classPathSeparator, (String)OptionsSimpleViewClassname.getProperty(this.changes, this.classPathProperty, false));
        try {
            this.buildClassLoader(values).loadClass(classname);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private URLClassLoader buildClassLoader(String[] paths) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String pathelt : paths) {
            try {
                urls.add(new File(pathelt.trim()).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
    }

    @Override
    protected int getTableStyle() {
        return 32;
    }

    private static class CheckableClassnameProvider
    implements OptionsSimpleViewList.ICheckableProvider {
        EnginesPropertiesUtil cp;

        public CheckableClassnameProvider(EnginesPropertiesUtil cp) {
            this.cp = cp;
        }

        @Override
        public List<EditableList.ICheckable> getCheckableList(EditableList table, String value) {
            ArrayList<EditableList.ICheckable> result = new ArrayList<EditableList.ICheckable>();
            List<DevPluginClassname> classnames = this.cp.parseDevPluginClassnames(value);
            for (DevPluginClassname cl : classnames) {
                result.add(new CheckableDevPluginClassname(cl));
            }
            return result;
        }
    }

    private static class CheckableDevPluginClassname
    implements EditableList.ICheckable {
        DevPluginClassname classname;

        public CheckableDevPluginClassname(DevPluginClassname classname) {
            this.classname = classname;
        }

        @Override
        public String getText() {
            return this.classname.getClassname();
        }

        @Override
        public boolean isChecked() {
            return this.classname.isEnabled();
        }
    }
}

