/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EmuSettingsDialog
extends JebDialog {
    boolean success;
    Text wTargetRoutineAddress;
    String targetRoutineAddress;
    Button wAllowOpt;
    Boolean allowOpt;
    Text wMaxIterCount;
    Integer maxIterCount;
    StyledText wParams;
    String params;
    StyledText wMemoryWrites;
    String memoryWrites;
    StyledText wRegisterWrites;
    String registerWrites;
    Button wResetOtherRegisters;
    Boolean resetOtherRegisters;
    Button wRecordMemWrites;
    Boolean recordMemWrites;
    Button wDisplayMods;
    Boolean displayMods;
    Button wUpdateAST;
    Boolean updateAST;

    public EmuSettingsDialog(Shell parent) {
        super(parent, "Emulator Settings", true, true);
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        String msg = "The IR emulator is a Preview component of GENDEC, JEB's native decompiler. It can be used to emulate code (at the IR level); visualize simulation results (modified memory, modified registers, etc.); and perform replacements in the AST tree (e.g., a decrypted immediate to replace a call to a decryptor routine). This UI widget is a controller for the IREmulator class, available via the API. It is not as full-featured as what full API access allows (e.g. customizing registers and memory before the emulation, implementing external routine helpers, etc.). Advanced users wanting to customize the emulation of specific routines or write library helpers are advised to use the IREmulator object directly.";
        Label label = new Label(parent, 18496);
        label.setText(msg);
        label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 60));
        Group c0 = UIUtil.createGroupGrid(parent, 0, "Settings", 1, 2);
        new Label((Composite)c0, 0).setText("Maximum iteration count:");
        this.wMaxIterCount = UIUtil.createTextboxInGrid((Composite)c0, 2048, 8, 1);
        if (this.maxIterCount != null) {
            this.wMaxIterCount.setText("" + this.maxIterCount);
        }
        this.wMaxIterCount.selectAll();
        new Label((Composite)c0, 0).setText("Enable optimizations:");
        this.wAllowOpt = new Button((Composite)c0, 32);
        if (this.allowOpt != null) {
            this.wAllowOpt.setSelection(this.allowOpt.booleanValue());
        }
        new Label((Composite)c0, 0).setText("Reset uninitialized registers:");
        this.wResetOtherRegisters = new Button((Composite)c0, 32);
        if (this.resetOtherRegisters != null) {
            this.wResetOtherRegisters.setSelection(this.resetOtherRegisters.booleanValue());
        }
        new Label((Composite)c0, 0).setText("Record memory-writes:");
        this.wRecordMemWrites = new Button((Composite)c0, 32);
        if (this.recordMemWrites != null) {
            this.wRecordMemWrites.setSelection(this.recordMemWrites.booleanValue());
        }
        Group c1 = UIUtil.createGroupGrid(parent, 0, "Emulated Target", 1, 2);
        new Label((Composite)c1, 0).setText("Method:");
        this.wTargetRoutineAddress = UIUtil.createTextboxInGrid((Composite)c1, 2052, 40, 1, true, false);
        if (this.targetRoutineAddress != null) {
            this.wTargetRoutineAddress.setText(this.targetRoutineAddress);
            this.wTargetRoutineAddress.selectAll();
        }
        this.wTargetRoutineAddress.setFocus();
        new Label((Composite)c1, 0).setText("Parameters:");
        this.wParams = new StyledText((Composite)c1, 2818);
        this.wParams.setFont(UIUtil.getCodeFont());
        this.wParams.setAlwaysShowScrollBars(false);
        GridData griddata = UIUtil.createGridDataForText((Control)this.wParams, 50, 4, false);
        griddata.horizontalSpan = 1;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        griddata.grabExcessVerticalSpace = true;
        griddata.verticalAlignment = 4;
        this.wParams.setLayoutData((Object)griddata);
        UIUtil.disableTabOutput((Control)this.wParams);
        if (this.params != null) {
            this.wParams.setText(this.params);
        }
        Group c2 = UIUtil.createGroupGrid(parent, 0, "Post-Emulation", 1, 2);
        new Label((Composite)c2, 0).setText("Display registers and memory modifications:");
        this.wDisplayMods = new Button((Composite)c2, 32);
        if (this.displayMods != null) {
            this.wDisplayMods.setSelection(this.displayMods.booleanValue());
        }
        new Label((Composite)c2, 0).setText("Update AST (if possible):");
        this.wUpdateAST = new Button((Composite)c2, 32);
        if (this.updateAST != null) {
            this.wUpdateAST.setSelection(this.updateAST.booleanValue());
        }
        this.createButtons(parent, 288, 32);
    }

    @Override
    protected void onConfirm() {
        this.maxIterCount = Conversion.stringToInt(this.wMaxIterCount.getText());
        if (this.maxIterCount <= 0) {
            UI.warn("Invalid iteration count");
            return;
        }
        this.allowOpt = this.wAllowOpt.getSelection();
        this.resetOtherRegisters = this.wResetOtherRegisters.getSelection();
        this.recordMemWrites = this.wRecordMemWrites.getSelection();
        this.targetRoutineAddress = this.wTargetRoutineAddress.getText();
        if (Strings.isBlank(this.targetRoutineAddress)) {
            UI.warn("Invalid target routine");
            return;
        }
        this.params = this.wParams.getText();
        this.displayMods = this.wDisplayMods.getSelection();
        this.updateAST = this.wUpdateAST.getSelection();
        this.success = true;
        super.onConfirm();
    }

    public void setTargetRoutineAddress(String targetRoutineAddress) {
        this.targetRoutineAddress = targetRoutineAddress;
    }

    public String getTargetRoutineAddress() {
        return this.targetRoutineAddress;
    }

    public void setMaxIterCount(Integer maxIterCount) {
        this.maxIterCount = maxIterCount;
    }

    public Integer getMaxIterCount() {
        return this.maxIterCount;
    }

    public void setAllowOpt(Boolean allowOpt) {
        this.allowOpt = allowOpt;
    }

    public Boolean getAllowOpt() {
        return this.allowOpt;
    }

    public void setResetOtherRegisters(Boolean resetOtherRegisters) {
        this.resetOtherRegisters = resetOtherRegisters;
    }

    public Boolean getResetOtherRegisters() {
        return this.resetOtherRegisters;
    }

    public void setRecordMemWrites(Boolean recordMemWrites) {
        this.recordMemWrites = recordMemWrites;
    }

    public Boolean getRecordMemWrites() {
        return this.recordMemWrites;
    }

    public void setParameters(String params) {
        this.params = params;
    }

    public String getParameters() {
        return this.params;
    }

    public void setDisplayMods(Boolean displayMods) {
        this.displayMods = displayMods;
    }

    public Boolean getDisplayMods() {
        return this.displayMods;
    }

    public Boolean getUpdateAST() {
        return this.updateAST;
    }

    public void setUpdateAST(Boolean updateAST) {
        this.updateAST = updateAST;
    }
}

