/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.CodePointer;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.BranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchResolution;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.IBranchTarget;
import com.pnfsoftware.jeb.core.units.code.asm.analyzer.INativeCodeAnalyzer;
import com.pnfsoftware.jeb.core.units.code.asm.items.DataHints;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeDataItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeInstructionItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeMethodItem;
import com.pnfsoftware.jeb.core.units.code.asm.items.InstructionHints;
import com.pnfsoftware.jeb.core.units.code.asm.memory.VirtualMemoryUtil;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrototypeItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParseException;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeStringParser;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.NativeRoutineChooserDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNativeItemDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(EditNativeItemDialog.class);
    private long address;
    private INativeCodeUnit<?> unit;
    private boolean confirmed;
    private INativeInstructionItem ii;
    private INativeDataItem di;
    private Text widgetAddress;
    private Text widgetLabel;
    private Text widgetBytes;
    private Text widgetDisas;
    private Text widgetProcmode;
    private Text widgetHintSPDelta;
    private Text widgetHintProto;
    private Text widgetDynTarget;
    private Text widgetDynBranches;
    private Button widgetReanalyze;
    private Combo widgetHintAddrCalc;
    private static final String KEY_DYNTARGET = "dynTargetItem";

    public EditNativeItemDialog(Shell parent, long address, INativeCodeUnit<?> unit) {
        super(parent, "Edit native item", true, true);
        this.scrolledContainer = true;
        this.address = address;
        this.unit = unit;
        this.loadItem();
    }

    private void loadItem() {
        INativeContinuousItem item = this.unit.getNativeItemAt(this.address);
        if (item instanceof INativeInstructionItem) {
            this.ii = (INativeInstructionItem)item;
        } else if (item instanceof INativeDataItem) {
            this.di = (INativeDataItem)item;
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public Boolean open() {
        super.open();
        return this.confirmed;
    }

    @Override
    protected void createContents(final Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        new Label(parent, 0).setText(S.s(52) + ": ");
        this.widgetAddress = UIUtil.createTextboxInGrid(parent, 2060, 50, 1, true, false);
        new Label(parent, 0).setText(S.s(424) + ": ");
        this.widgetLabel = new Text(parent, 2060);
        this.widgetLabel.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label(parent, 0).setText("Bytes: ");
        this.widgetBytes = new Text(parent, 2060);
        this.widgetBytes.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label(parent, 0).setText("Disassembly: ");
        this.widgetDisas = new Text(parent, 2060);
        this.widgetDisas.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        new Label(parent, 0).setText("Mode (bits): ");
        this.widgetProcmode = new Text(parent, 2060);
        this.widgetProcmode.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Group grp = UIUtil.createGroupGrid(parent, 0, "Attributes", 2, 2);
        if (this.ii != null) {
            new Label((Composite)grp, 0).setText("SP Delta: ");
            this.widgetHintSPDelta = new Text((Composite)grp, 2052);
            this.widgetHintSPDelta.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            new Label((Composite)grp, 0).setText("Prototype Hint: ");
            this.widgetHintProto = new Text((Composite)grp, 2052);
            this.widgetHintProto.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            Group grp2 = UIUtil.createGroupGrid(parent, 0, "Dynamic Targets", 2, 2);
            Label label = new Label((Composite)grp2, 0);
            label.setText("Resolved: ");
            UIUtil.createHelpDecorator((Control)label, "Single routine or address, the resolved callsite, e.g. func_abc or 0x1201000(64)");
            Composite c = UIUtil.createCompositeGrid((Composite)grp2, 0, 1, 3, null);
            UIUtil.createTightPushbox(c, "Select", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NativeRoutineChooserDialog dlg = new NativeRoutineChooserDialog(parent.getShell(), EditNativeItemDialog.this.unit);
                    INativeMethodItem routine = dlg.open();
                    if (routine != null) {
                        EditNativeItemDialog.this.setDynTargetWidget(new BranchTarget(routine));
                    }
                }
            });
            this.widgetDynTarget = new Text(c, 2052);
            this.widgetDynTarget.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            label = new Label((Composite)grp2, 0);
            label.setText("Candidates: ");
            UIUtil.createHelpDecorator((Control)label, "CSV of candidate routines or addresses in hex, e.g. \"0x10132, 0x101B6(32)\"");
            this.widgetDynBranches = new Text((Composite)grp2, 2052);
            this.widgetDynBranches.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            this.widgetReanalyze = UIUtil.createCheckbox((Composite)grp2, "Reanalyze code with new targets", null);
            this.widgetReanalyze.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
            this.loadInstruction(this.address);
        } else if (this.di != null) {
            new Label((Composite)grp, 0).setText("Address Calculation Hint: ");
            this.widgetHintAddrCalc = new Combo((Composite)grp, 8);
            this.widgetHintAddrCalc.add("None");
            this.widgetHintAddrCalc.add("Absolute Address");
            this.widgetHintAddrCalc.add("Relative (RVA)");
            int index = 0;
            DataHints hints = this.di.getHints(false);
            if (hints != null) {
                if (hints.getAddressCalculationHint() == 1) {
                    index = 1;
                } else if (hints.getAddressCalculationHint() == 2) {
                    index = 2;
                }
            }
            this.widgetHintAddrCalc.select(index);
            this.loadData(this.address);
        }
        this.createOkayCancelButtons(parent);
    }

    private void loadInstruction(long address) {
        List<IBranchTarget> targets;
        IBranchTarget target;
        this.widgetAddress.setText(Strings.safe(this.ii.getAddress()));
        this.widgetLabel.setText(Strings.safe(this.ii.getLabel()));
        this.widgetBytes.setText(Formatter.formatBinaryLine(this.ii.getInstruction().getCode()).toString());
        this.widgetDisas.setText(this.ii.getInstruction().format(this.ii.getMemoryAddress()));
        this.widgetProcmode.setText("" + this.ii.getInstruction().getProcessorMode());
        this.widgetHintSPDelta.setText("");
        this.widgetHintProto.setText("");
        this.setDynTargetWidget(null);
        this.setDynBranchesWidget(null);
        InstructionHints hints = this.ii.getHints(false);
        if (hints != null) {
            this.widgetHintSPDelta.setText(Strings.safe(hints.getStackPointerDelta()));
            this.widgetHintProto.setText(Strings.safe(hints.getCallsitePrototype()));
        }
        if ((target = this.getCurrentlyStoredResolvedTarget()) != null) {
            this.setDynTargetWidget(target);
        }
        if ((targets = this.getCurrentlyStoredCandidateTargets()) != null) {
            this.setDynBranchesWidget(targets);
        }
    }

    private void loadData(long address) {
        this.widgetAddress.setText(Strings.safe(this.di.getAddress()));
        this.widgetLabel.setText(Strings.safe(this.di.getLabel()));
        byte[] dst = new byte[(int)this.di.getMemorySize()];
        int readsize = VirtualMemoryUtil.readBytesSafe(this.unit.getMemory(), this.di.getMemoryAddress(), dst.length, dst, 0, true);
        if (readsize != dst.length) {
            this.widgetBytes.setText(Strings.ff("Error! got %d bytes, expected %d bytes", readsize, dst.length));
        } else {
            this.widgetBytes.setText(Formatter.formatBinaryLine(dst).toString());
        }
    }

    private IBranchTarget getCurrentlyStoredResolvedTarget() {
        IBranchResolution reso = this.unit.getCodeModel().getDynamicBranchResolution(this.address);
        return reso.isEmpty() ? null : reso.getResolvedTarget();
    }

    private void setDynTargetWidget(IBranchTarget target) {
        if (target == null) {
            this.widgetDynTarget.setText("");
        } else {
            this.widgetDynTarget.setText(target.toString());
        }
        this.widgetDynTarget.setData(KEY_DYNTARGET, (Object)target);
    }

    private List<IBranchTarget> getCurrentlyStoredCandidateTargets() {
        IBranchResolution reso = this.unit.getCodeModel().getDynamicBranchResolution(this.address);
        return reso.isEmpty() ? Collections.emptyList() : reso.getCandidates();
    }

    private void setDynBranchesWidget(List<IBranchTarget> targets) {
        if (targets == null || targets.isEmpty()) {
            this.widgetDynBranches.setText("");
        } else {
            String str = Strings.join(", ", targets);
            this.widgetDynBranches.setText(str);
        }
        this.widgetDynBranches.setData(KEY_DYNTARGET, targets);
    }

    private List<IBranchTarget> getDynBranchesFromWidget() {
        ArrayList<IBranchTarget> r = new ArrayList<IBranchTarget>();
        for (String elt : this.widgetDynBranches.getText().split(",")) {
            INativeMethodItem routine = this.unit.getRoutineByName(elt = elt.trim());
            if (routine != null) {
                r.add(new BranchTarget(routine));
                continue;
            }
            try {
                CodePointer ep = CodePointer.createFrom(elt);
                r.add(new BranchTarget(ep));
            }
            catch (Exception exception) {
                logger.warn("Illegal target: '%s'", elt);
            }
        }
        return r;
    }

    @Override
    protected void onConfirm() {
        this.confirmed = true;
        if (this.ii != null) {
            String text = this.widgetHintSPDelta.getText().trim();
            if (text.isEmpty()) {
                if (this.ii.getHints(false) != null) {
                    this.ii.getHints(true).setStackPointerDelta(null);
                }
            } else {
                try {
                    int spdelta = Integer.parseInt(text);
                    this.ii.getHints(true).setStackPointerDelta(spdelta);
                }
                catch (NumberFormatException numberFormatException) {
                    UI.error("Cannot parse integer value for SP delta");
                    return;
                }
            }
            if ((text = this.widgetHintProto.getText().trim()).isEmpty()) {
                if (this.ii.getHints(false) != null) {
                    this.ii.getHints(true).setCallsitePrototype(null);
                }
            } else {
                try {
                    IPrototypeItem proto = new TypeStringParser(this.unit.getTypeManager()).parseSignature(text, true);
                    this.ii.getHints(true).setCallsitePrototype(proto);
                }
                catch (TypeStringParseException typeStringParseException) {
                    UI.error("Cannot parse signature. The expected format is:\n\nreturnType [callingConvention] f([param1Type[, param2Type[, ...]]])");
                    return;
                }
            }
            boolean reanalyze = this.widgetReanalyze.getSelection();
            INativeCodeAnalyzer<?> gca = this.unit.getCodeAnalyzer();
            INativeMethodItem routine = (INativeMethodItem)this.widgetDynTarget.getData(KEY_DYNTARGET);
            if (routine == null) {
                IBranchTarget current = this.getCurrentlyStoredResolvedTarget();
                if (current != null) {
                    this.unit.getCodeAnalyzer().unrecordDynamicBranchTarget(this.address, true, null);
                }
            } else {
                this.unit.getCodeAnalyzer().recordDynamicBranchTarget(this.address, true, new BranchTarget(routine), reanalyze);
            }
            List<IBranchTarget> targets = this.getDynBranchesFromWidget();
            if (targets == null || targets.isEmpty()) {
                if (!this.getCurrentlyStoredCandidateTargets().isEmpty()) {
                    this.unit.getCodeAnalyzer().unrecordDynamicBranchTarget(this.address, false, null);
                }
            } else {
                for (IBranchTarget target : targets) {
                    this.unit.getCodeAnalyzer().recordDynamicBranchTarget(this.address, false, target, reanalyze);
                }
            }
            if (gca.needsAnalysis()) {
                gca.analyze();
            }
        } else if (this.di != null) {
            int index = this.widgetHintAddrCalc.getSelectionIndex();
            int hint = 0;
            if (index == 1) {
                hint = 1;
            } else if (index == 2) {
                hint = 2;
            }
            this.di.getHints(true).setAddressCalculationHint(hint);
        }
        super.onConfirm();
    }
}

