/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.items.INativeContinuousItem;
import com.pnfsoftware.jeb.core.units.code.asm.type.IArrayType;
import com.pnfsoftware.jeb.core.units.code.asm.type.INativeType;
import com.pnfsoftware.jeb.core.units.code.asm.type.IPrimitiveType;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.nativecode.ArraySetupInformation;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DefineArrayDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(DefineArrayDialog.class);
    private long address;
    private INativeCodeUnit<?> unit;
    private TreeMap<Integer, List<INativeType>> dataSizes;
    private List<Integer> dataSizeIndexes;
    private boolean confirmed;
    private ArraySetupInformation info = new ArraySetupInformation();
    private Label widgetInfo;
    private Text widgetAddress;
    private Text widgetArraySize;
    private Combo widgetdataSize;
    private Combo widgetdataType;
    private Button widgetOk;

    public DefineArrayDialog(Shell parent, long address, INativeCodeUnit<?> unit) {
        super(parent, "Create/Edit Array", true, true);
        this.scrolledContainer = true;
        this.address = address;
        this.unit = unit;
        Collection<IPrimitiveType> primtypes = unit.getTypeManager().getPrimitives().getTypes();
        List<INativeType> types = unit.getTypes();
        ArrayList<INativeType> allTypes = new ArrayList<INativeType>();
        allTypes.addAll(primtypes);
        allTypes.addAll(types);
        this.dataSizes = new TreeMap();
        for (INativeType t : allTypes) {
            if (t.getSize() <= 0) continue;
            List<INativeType> list = this.dataSizes.get(t.getSize());
            if (list == null) {
                list = new ArrayList<INativeType>();
                this.dataSizes.put(t.getSize(), list);
            }
            list.add(t);
        }
        this.dataSizeIndexes = new ArrayList<Integer>(this.dataSizes.keySet());
    }

    @Override
    public ArraySetupInformation open() {
        super.open();
        if (!this.confirmed) {
            return null;
        }
        return this.info;
    }

    @Override
    protected void createContents(Composite parent) {
        int toSelect;
        UIUtil.setStandardLayout(parent, 4);
        this.widgetInfo = new Label(parent, 0);
        this.widgetInfo.setText("N/A");
        this.widgetInfo.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(4, true, false));
        Group grp = new Group(parent, 0);
        grp.setText("Properties");
        UIUtil.setStandardLayout((Composite)grp, 4);
        grp.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(4, true, false));
        new Label((Composite)grp, 0).setText(S.s(52) + ": ");
        this.widgetAddress = new Text((Composite)grp, 2052);
        this.widgetAddress.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.widgetAddress, 16));
        this.widgetAddress.setText(Strings.ff("%Xh", this.address));
        this.widgetAddress.selectAll();
        new Label((Composite)grp, 0).setText("Array Size: ");
        this.widgetArraySize = new Text((Composite)grp, 2052);
        this.widgetArraySize.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.widgetAddress, 8));
        this.widgetArraySize.setText("" + this.getDefaultElementCount());
        this.widgetArraySize.selectAll();
        this.widgetArraySize.setFocus();
        new Label((Composite)grp, 0).setText("Data Size: ");
        this.widgetdataSize = new Combo((Composite)grp, 12);
        GridData layoutData1 = UIUtil.createGridDataFillHorizontally();
        this.widgetdataSize.setLayoutData((Object)layoutData1);
        for (Integer size : this.dataSizeIndexes) {
            this.widgetdataSize.add("" + size);
        }
        this.widgetdataSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefineArrayDialog.this.updateWidgetDataTypes();
                DefineArrayDialog.this.update();
            }
        });
        new Label((Composite)grp, 0).setText("Data type: ");
        this.widgetdataType = new Combo((Composite)grp, 12);
        GridData layoutData2 = UIUtil.createGridDataFillHorizontally();
        this.widgetdataType.setLayoutData((Object)layoutData2);
        INativeType defaultType = this.getDefaultBaseType();
        if (defaultType != null && (toSelect = this.dataSizeIndexes.indexOf(defaultType.getSize())) >= 0) {
            this.widgetdataSize.select(toSelect);
            this.updateWidgetDataTypes();
            List<INativeType> list = this.dataSizes.get(defaultType.getSize());
            int typeIndex = 0;
            for (INativeType t : list) {
                if (this.widgetdataType.getText().equals(t.getName())) {
                    this.widgetdataType.select(typeIndex);
                    break;
                }
                ++typeIndex;
            }
        }
        this.createOkayCancelButtons(parent);
        this.widgetOk = this.getButtonByStyle(32);
        this.widgetAddress.addModifyListener(e -> this.update());
        this.widgetArraySize.addModifyListener(e -> this.update());
        this.update();
    }

    @Override
    protected void onConfirm() {
        this.info = new ArraySetupInformation();
        this.info.address = this.getSelectedAddress();
        this.info.arraySize = Conversion.stringToInt(this.widgetArraySize.getText(), 1);
        this.info.dataType = this.getSelectedDataType();
        this.confirmed = true;
        super.onConfirm();
    }

    private void update() {
        INativeContinuousItem item;
        long a = this.getSelectedAddress();
        int arraySize = Conversion.stringToInt(this.widgetArraySize.getText(), 0);
        int dataTypeIndex = this.widgetdataType.getSelectionIndex();
        this.widgetOk.setEnabled(a >= 0L && arraySize > 0 && dataTypeIndex >= 0);
        String info = a < 0L ? "Invalid address" : (this.unit == null ? Strings.ff("No native unit was provided, cannot retrieve information about location %Xh.", a) : ((item = this.unit.getNativeItemOver(a)) != null ? Strings.ff("Will attempt to edit array at address %Xh.", a) : Strings.ff("Will attempt to define array at address %Xh", a)));
        this.widgetInfo.setText(info);
    }

    private void updateWidgetDataTypes() {
        this.widgetdataType.removeAll();
        int selected = this.widgetdataSize.getSelectionIndex();
        if (selected < 0) {
            return;
        }
        int typeSize = this.dataSizeIndexes.get(selected);
        List<INativeType> types = this.dataSizes.get(typeSize);
        for (INativeType type : types) {
            this.widgetdataType.add(type.getName());
        }
        this.widgetdataType.select(0);
    }

    private long getSelectedAddress() {
        return Conversion.stringToLong(this.widgetAddress.getText(), -1L);
    }

    private INativeType getSelectedDataType() {
        int dsIndex = this.widgetdataSize.getSelectionIndex();
        int index = this.widgetdataType.getSelectionIndex();
        if (index < 0 || dsIndex < 0) {
            return null;
        }
        List<INativeType> list = this.dataSizes.get(this.dataSizeIndexes.get(dsIndex));
        for (INativeType t : list) {
            if (!this.widgetdataType.getText().equals(t.getName())) continue;
            return t;
        }
        return null;
    }

    private int getDefaultElementCount() {
        INativeType type = this.unit.getDataTypeAt(this.address);
        if (type != null && type instanceof IArrayType) {
            return ((IArrayType)type).getElementCount();
        }
        return 1;
    }

    public INativeType getDefaultBaseType() {
        INativeType type = this.unit.getDataTypeAt(this.address);
        if (type != null && type instanceof IArrayType) {
            return ((IArrayType)type).getElementType();
        }
        int defautSize = this.unit.getProcessor().getDefaultMode() / 8;
        List<INativeType> list = this.dataSizes.get(defautSize);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }
}

