/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs.nativecode;

import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConvention;
import com.pnfsoftware.jeb.core.units.code.asm.type.ICallingConventionManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CallingConventionManagerView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CallingConventionManagerDialog
extends JebDialog {
    IEnginesContext engctx;
    INativeCodeUnit<?> unit;
    CallingConventionManagerView v;
    ICallingConvention cc;

    public CallingConventionManagerDialog(Shell parent, IEnginesContext engctx, INativeCodeUnit<?> unit, ICallingConvention cc) {
        super(parent, "Calling Convention Manager", true, true);
        this.engctx = engctx;
        this.unit = unit;
        this.cc = cc;
    }

    @Override
    public ICallingConvention open() {
        super.open();
        return this.cc;
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.v = new CallingConventionManagerView(parent, 0, this.engctx, this.unit);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 400;
        data.minimumWidth = 600;
        this.v.setLayoutData(data);
        if (this.cc != null) {
            this.v.setSelectedCC(this.cc);
        } else {
            ICallingConventionManager ccman = this.unit.getTypeManager().getCallingConventionManager();
            this.v.setSelectedCC(ccman.getDefaultConvention());
        }
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        this.cc = this.v.getSelectedCC();
        super.onConfirm();
    }

    @Override
    protected void onCancel() {
        this.cc = null;
        super.onCancel();
    }
}

