/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UnitPropertiesDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(UnitPropertiesDialog.class);
    private IUnit unit;
    private Text widgetName;
    private StyledText widgetNotes;

    public UnitPropertiesDialog(Shell parent, IUnit unit) {
        super(parent, S.s(787), true, true);
        this.scrolledContainer = true;
        this.unit = unit;
    }

    @Override
    public Object open() {
        super.open();
        return null;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 2);
        new Label(parent, 0).setText(S.s(786) + ": ");
        this.widgetName = new Text(parent, 2052);
        this.widgetName.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.widgetName.setText(this.unit.getName());
        this.widgetName.selectAll();
        this.widgetName.setFocus();
        new Label(parent, 0).setText("Unit path: ");
        Text widgetUnitPath = new Text(parent, 2060);
        widgetUnitPath.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        widgetUnitPath.setText(Strings.safe(UnitUtil.buildFullyQualifiedUnitPath(this.unit), "N/A"));
        widgetUnitPath.selectAll();
        new Label(parent, 0).setText("Original name: ");
        Text widgetName0 = new Text(parent, 2060);
        widgetName0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        widgetName0.setText(Strings.safe(this.unit.getRealName(), "N/A"));
        widgetName0.selectAll();
        long size = 1L;
        if (this.unit instanceof IBinaryUnit) {
            size = ((IBinaryUnit)this.unit).getInput().getCurrentSize();
        }
        new Label(parent, 0).setText("Size (bytes): ");
        Text widgetSize = new Text(parent, 2060);
        widgetSize.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        widgetSize.setText(size < 0L ? "N/A" : Long.toString(size));
        widgetSize.selectAll();
        new Label(parent, 0).setText(S.s(788) + ": ");
        Text widgetType = new Text(parent, 2060);
        widgetType.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        widgetType.setText(this.unit.getFormatType());
        widgetType.selectAll();
        new Label(parent, 0).setText(S.s(214) + ": ");
        Text widgetCtime = new Text(parent, 2060);
        widgetCtime.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        DateFormat df = DateFormat.getDateTimeInstance();
        String str_ctime = df.format(new Date(this.unit.getCreationTimestamp()));
        String str_tz = df.getTimeZone().getDisplayName(false, 0);
        widgetCtime.setText(str_ctime + " " + str_tz);
        widgetCtime.selectAll();
        new Label(parent, 0).setText(S.s(748) + ": ");
        Text widgetStatus = new Text(parent, 2060);
        widgetStatus.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        Object status = this.unit.getStatus();
        if (status == null) {
            status = "N/A";
        }
        if (!this.unit.isProcessed()) {
            status = (String)status + " (" + S.s(794) + ")";
        }
        widgetStatus.setText((String)status);
        new Label(parent, 0).setText(S.s(599) + ": ");
        new Label(parent, 0).setText("");
        this.widgetNotes = new StyledText(parent, 2818);
        this.widgetNotes.setAlwaysShowScrollBars(false);
        this.widgetNotes.setText(this.unit.getNotes());
        this.widgetNotes.setFont(UIUtil.getCodeFont());
        GridData griddata = UIUtil.createGridDataForText((Control)this.widgetNotes, 50, 3, false);
        griddata.horizontalSpan = 2;
        griddata.grabExcessHorizontalSpace = true;
        griddata.horizontalAlignment = 4;
        griddata.grabExcessVerticalSpace = true;
        griddata.verticalAlignment = 4;
        this.widgetNotes.setLayoutData((Object)griddata);
        UIUtil.disableTabOutput((Control)this.widgetNotes);
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        this.unit.setName(this.widgetName.getText());
        this.unit.setNotes(this.widgetNotes.getText());
        super.onConfirm();
    }
}

