/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TipOfTheDayDialog
extends JebDialog {
    private RcpClientContext ctx;
    private Browser b;
    private Button btnDoNotShow;
    private Boolean doNotShow;
    private int idx = 1;
    private Random prng = new Random();
    private String base;
    private TreeSet<Integer> indicesSet = new TreeSet();
    private List<Integer> indicesList = new ArrayList<Integer>();
    private List<String> loadingPages = new ArrayList<String>();

    public TipOfTheDayDialog(Shell parent, RcpClientContext context) {
        super(parent, "Tip of the Day", true, true, null);
        this.ctx = context;
        this.checkTips();
    }

    private void checkTips() {
        Couple<String, Set<Integer>> c = TipOfTheDayDialog.collect(this.ctx);
        if (c == null) {
            return;
        }
        this.base = c.getFirst();
        this.indicesSet = new TreeSet(c.getSecond());
        this.indicesList = new ArrayList<Integer>(this.indicesSet);
    }

    public static Couple<String, Set<Integer>> collect(RcpClientContext ctx) {
        Object base;
        if (Licensing.isReleaseBuild()) {
            if (ctx == null) {
                return null;
            }
            base = ctx.getBaseDirectory() + File.separator + "doc" + File.separator + "manual" + File.separator;
        } else {
            base = System.getenv("JEB_DEVHOME");
            if (base == null) {
                return null;
            }
            base = (String)base + "/jeb-manual/site/";
        }
        base = (String)base + "tips_collection" + File.separator;
        if (!new File((String)base).isDirectory()) {
            return null;
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (File f : IO.listFiles((String)base)) {
            int i;
            String name = f.getName();
            if (!name.endsWith(".html") || (i = Conversion.stringToInt(name.substring(0, name.length() - 5))) < 1) continue;
            set.add(i);
        }
        return new Couple(base, set);
    }

    public boolean hasTips() {
        return !this.indicesSet.isEmpty();
    }

    public int getCountOfTips() {
        return this.indicesSet.size();
    }

    public void setTipIndex(int idx) {
        if (idx <= 0) {
            idx = 1;
        }
        this.idx = idx;
    }

    public int getTipIndex() {
        return this.idx;
    }

    public void setDoNotShow(Boolean doNotShow) {
        this.doNotShow = doNotShow;
    }

    public Boolean getDoNotShow() {
        return this.doNotShow;
    }

    @Override
    public Void open() {
        super.open();
        return null;
    }

    @Override
    public final void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        this.b = new Browser(parent, 0);
        this.b.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                TipOfTheDayDialog.this.loadingPages.add(event.location);
            }

            public void changed(LocationEvent event) {
                TipOfTheDayDialog.this.loadingPages.remove(event.location);
            }
        });
        GridData data = new GridData(640, 480);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.b.setLayoutData((Object)data);
        this.idx = this.sanitizeIndex(this.idx, 1);
        this.loadTip();
        this.btnDoNotShow = UIUtil.createCheckbox(parent, "Do not display tips at start-up", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipOfTheDayDialog.this.doNotShow = TipOfTheDayDialog.this.btnDoNotShow.getSelection();
            }
        });
        if (this.getWidgetManager() != null && this.getWidgetName() != null) {
            if (this.doNotShow != null) {
                this.btnDoNotShow.setSelection(this.doNotShow.booleanValue());
            } else {
                this.btnDoNotShow.setSelection(!this.getWidgetManager().getShouldShowDialog(this.getWidgetName()));
            }
        } else {
            this.btnDoNotShow.setEnabled(false);
        }
        Composite btns = new Composite(parent, 0);
        btns.setLayout((Layout)new RowLayout(256));
        UIUtil.createPushbox(btns, "<<<", e -> {
            this.idx = this.sanitizeIndex(this.idx - 1, -1);
            this.loadTip();
        });
        UIUtil.createPushbox(btns, ">>>", e -> {
            this.idx = this.sanitizeIndex(this.idx + 1, 1);
            this.loadTip();
        });
        if (this.getCountOfTips() >= 10) {
            UIUtil.createPushbox(btns, "Random", e -> {
                this.idx = this.generateRandomIndex();
                this.loadTip();
            });
        }
        Button btnClose = UIUtil.createPushbox(btns, " Close ", e -> this.shell.close());
        this.getShell().setDefaultButton(btnClose);
        btnClose.setFocus();
    }

    int sanitizeIndex(int index, int delta) {
        if (this.indicesSet.contains(index)) {
            return index;
        }
        if (delta >= 0) {
            Integer next = this.indicesSet.higher(index);
            if (next != null) {
                return next;
            }
            return this.indicesSet.first();
        }
        Integer prev = this.indicesSet.lower(index);
        if (prev != null) {
            return prev;
        }
        return this.indicesSet.last();
    }

    public int generateRandomIndex() {
        int index2;
        if (this.indicesList.isEmpty()) {
            throw new RuntimeException();
        }
        int cnt = this.getCountOfTips();
        if (cnt == 1) {
            return this.indicesList.get(0);
        }
        while ((index2 = this.indicesList.get(this.prng.nextInt(cnt)).intValue()) == this.idx) {
        }
        return index2;
    }

    boolean loadTip() {
        File f = new File(this.base, this.idx + ".html");
        if (!f.isFile()) {
            return false;
        }
        String url = f.toURI().toString();
        this.b.setUrl(url);
        return true;
    }

    public boolean isSuccessful() {
        return this.loadingPages.isEmpty();
    }
}

