/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.rcpclient.FontManager;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.dialogs.ColorPickerView;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.Theme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StyleOptionsDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(StyleOptionsDialog.class);
    private Boolean modified = Boolean.FALSE;
    private ThemeManager themeManager;
    private FontManager fontman;
    private FontManager fontman0;
    private StyleManager styleman;
    private StyleManager styleman0;
    private Label labelFontName;
    private Combo wTheme;
    private Combo wColors;

    public StyleOptionsDialog(Shell parent, ThemeManager themeManager, StyleManager styleManager, FontManager fontManager) {
        super(parent, S.s(755), true, false);
        this.scrolledContainer = true;
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.themeManager = themeManager;
        if (styleManager == null) {
            throw new NullPointerException();
        }
        this.styleman = styleManager;
        this.fontman = fontManager;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.modified;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        if (this.fontman != null) {
            this.fontman0 = this.fontman.clone();
            Group grpFont = new Group(parent, 0);
            grpFont.setLayout((Layout)new GridLayout(2, false));
            grpFont.setText(S.s(202));
            grpFont.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            UIUtil.createPushbox((Composite)grpFont, S.s(722) + "...", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontDialog dlgFontSelect = new FontDialog(StyleOptionsDialog.this.shell);
                    Font codefont = StyleOptionsDialog.this.fontman.getCodeFont();
                    dlgFontSelect.setFontList(codefont.getFontData());
                    FontData fd = dlgFontSelect.open();
                    if (fd != null) {
                        codefont = UIAssetManager.getInstance().getFont(dlgFontSelect.getFontList());
                        StyleOptionsDialog.this.fontman.setCodeFont(codefont, true);
                        StyleOptionsDialog.this.refreshWidgets();
                    }
                }
            });
            this.labelFontName = new Label((Composite)grpFont, 2048);
            this.labelFontName.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        }
        this.styleman0 = this.styleman.clone();
        Group grpTheme = new Group(parent, 0);
        grpTheme.setLayout((Layout)new GridLayout(2, false));
        grpTheme.setText(S.s(771));
        grpTheme.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        if (this.themeManager != null) {
            this.wTheme = UIUtil.createLabeledCombo((Composite)grpTheme, "Select a theme", new String[0]);
            final ArrayList<String> themeIdList = new ArrayList<String>();
            Integer selected = null;
            int i = 0;
            for (Theme t : this.themeManager.getThemes()) {
                this.wTheme.add(t.getName());
                if (this.themeManager.getActiveThemeId() == t.getId()) {
                    selected = i;
                }
                themeIdList.add(t.getId());
                ++i;
            }
            if (selected != null) {
                this.wTheme.select(selected.intValue());
            }
            this.wTheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = StyleOptionsDialog.this.wTheme.getSelectionIndex();
                    String id = (String)themeIdList.get(idx);
                    StyleOptionsDialog.this.themeManager.setActiveTheme(id);
                }
            });
        }
        this.createColorPickerForClassIds(parent);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(3, false));
        buttons.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        UIUtil.createPushbox(buttons, S.s(605), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                StyleOptionsDialog.this.modified = Boolean.TRUE;
                StyleOptionsDialog.this.shell.close();
            }
        });
        UIUtil.createPushbox(buttons, S.s(105), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (StyleOptionsDialog.this.fontman != null) {
                    StyleOptionsDialog.this.fontman.restore(StyleOptionsDialog.this.fontman0, true);
                }
                StyleOptionsDialog.this.styleman.restore(StyleOptionsDialog.this.styleman0, true);
                StyleOptionsDialog.this.shell.close();
            }
        });
        UIUtil.createPushbox(buttons, S.s(681), (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (StyleOptionsDialog.this.fontman != null) {
                    StyleOptionsDialog.this.fontman.resetDefaults(true, true);
                }
                StyleOptionsDialog.this.styleman.resetDefaults(true);
                StyleOptionsDialog.this.refreshWidgets();
            }
        });
        this.refreshWidgets();
    }

    private void refreshWidgets() {
        Font codefont;
        if (this.fontman != null && (codefont = this.fontman.getCodeFont()) != null && codefont.getFontData().length >= 1) {
            FontData fd = codefont.getFontData()[0];
            Object text = Strings.ff("%s %dpt", fd.getName(), fd.getHeight());
            if ((fd.getStyle() & 1) != 0) {
                text = (String)text + " " + S.s(99);
            }
            if ((fd.getStyle() & 2) != 0) {
                text = (String)text + " " + S.s(407);
            }
            this.labelFontName.setText((String)text);
        }
        this.wColors.select(0);
        this.wColors.notifyListeners(13, new Event());
    }

    private void createColorPickerForClassIds(Composite parent) {
        ItemClassIdentifiers[] style_types;
        Group c0 = new Group(parent, 0);
        c0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        c0.setLayout((Layout)new RowLayout(512));
        c0.setText(S.s(196));
        this.wColors = UIUtil.createLabeledCombo((Composite)c0, S.s(779), new String[0]);
        for (ItemClassIdentifiers classId : style_types = ItemClassIdentifiers.values()) {
            this.wColors.add(classId.toString());
        }
        Group c2 = new Group((Composite)c0, 0);
        c2.setLayout((Layout)new RowLayout(256));
        c2.setText(S.s(597));
        final ColorPickerView normal_fgcolor = new ColorPickerView((Composite)c2, S.s(355));
        final ColorPickerView normal_bgcolor = new ColorPickerView((Composite)c2, S.s(96));
        final Button normal_bold = UIUtil.createCheckbox((Composite)c2, S.s(99), null);
        final Button normal_italic = UIUtil.createCheckbox((Composite)c2, S.s(407), null);
        Group c3 = new Group((Composite)c0, 0);
        c3.setLayout((Layout)new RowLayout(256));
        c3.setText(S.s(49));
        final ColorPickerView active_fgcolor = new ColorPickerView((Composite)c3, S.s(355));
        final ColorPickerView active_bgcolor = new ColorPickerView((Composite)c3, S.s(96));
        final Button active_bold = UIUtil.createCheckbox((Composite)c3, S.s(99), null);
        final Button active_italic = UIUtil.createCheckbox((Composite)c3, S.s(407), null);
        this.wColors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                Style style = StyleOptionsDialog.this.styleman.getNormalStyle(style_types[index]);
                normal_fgcolor.setColor(style.getColor());
                normal_bgcolor.setColor(style.getBackgroungColor());
                normal_bold.setSelection(style.isBold());
                normal_italic.setSelection(style.isItalic());
                style = StyleOptionsDialog.this.styleman.getActiveStyle(style_types[index]);
                active_fgcolor.setColor(style.getColor());
                active_bgcolor.setColor(style.getBackgroungColor());
                active_bold.setSelection(style.isBold());
                active_italic.setSelection(style.isItalic());
            }
        });
        SelectionAdapter listener_normal_fgcolor = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getNormalStyle(style_types[index]).setColor(((ColorPickerView)e.widget).getColor());
            }
        };
        normal_fgcolor.addSelectionListener((SelectionListener)listener_normal_fgcolor);
        SelectionAdapter listener_normal_bgcolor = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getNormalStyle(style_types[index]).setBackgroundColor(((ColorPickerView)e.widget).getColor());
            }
        };
        normal_bgcolor.addSelectionListener((SelectionListener)listener_normal_bgcolor);
        normal_bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getNormalStyle(style_types[index]).setBold(((Button)e.widget).getSelection());
            }
        });
        normal_italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getNormalStyle(style_types[index]).setItalic(((Button)e.widget).getSelection());
            }
        });
        SelectionAdapter listener_active_fgcolor = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getActiveStyle(style_types[index]).setColor(((ColorPickerView)e.widget).getColor());
            }
        };
        active_fgcolor.addSelectionListener((SelectionListener)listener_active_fgcolor);
        SelectionAdapter listener_active_bgcolor = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getActiveStyle(style_types[index]).setBackgroundColor(((ColorPickerView)e.widget).getColor());
            }
        };
        active_bgcolor.addSelectionListener((SelectionListener)listener_active_bgcolor);
        active_bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getActiveStyle(style_types[index]).setBold(((Button)e.widget).getSelection());
            }
        });
        active_italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = StyleOptionsDialog.this.wColors.getSelectionIndex();
                StyleOptionsDialog.this.styleman.getActiveStyle(style_types[index]).setItalic(((Button)e.widget).getSelection());
            }
        });
    }
}

