/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.impl.AbstractCommentManager;
import com.pnfsoftware.jeb.core.units.impl.Comment;
import com.pnfsoftware.jeb.core.units.impl.MetaComment;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.RefsBaseDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ShowCommentsDialog
extends RefsBaseDialog {
    IUnit unit;
    Button btnHideMC;
    boolean hideMC;

    public ShowCommentsDialog(Shell parent, IUnit unit, RcpClientContext context) {
        super(parent, (unit == null ? "Project" : "Unit") + " Comments", context, false, "Comment");
        this.unit = unit;
    }

    @Override
    protected List<RefsBaseDialog.E> provide() {
        IRuntimeProject prj;
        ArrayList<RefsBaseDialog.E> list = new ArrayList<RefsBaseDialog.E>();
        if (this.unit != null) {
            if (!this.unit.isDisposed()) {
                this.retrieveUnitComments(this.unit, list);
            }
        } else if (this.context != null && (prj = this.context.getOpenedProject()) != null) {
            for (IUnit unit : RuntimeProjectUtil.getAllUnits(prj)) {
                this.retrieveUnitComments(unit, list);
            }
        }
        return list;
    }

    void retrieveUnitComments(IUnit unit, List<RefsBaseDialog.E> list) {
        if (!(unit instanceof IInteractiveUnit)) {
            return;
        }
        IInteractiveUnit u = (IInteractiveUnit)unit;
        AbstractCommentManager<?, ?> cm = u.getCommentManager();
        if (cm == null) {
            Map<String, String> map = u.getInlineComments();
            for (Map.Entry<String, String> c : map.entrySet()) {
                String addr = c.getKey();
                String str = c.getValue();
                if (str == null) continue;
                list.add(new RefsBaseDialog.E(unit, addr, str));
            }
        } else {
            for (Map.Entry<String, Comment> c : cm.getComments().entrySet()) {
                String addr = c.getKey();
                Comment com = c.getValue();
                String str = com.getInline();
                if (str != null) {
                    list.add(new RefsBaseDialog.E(unit, addr, str));
                }
                if ((str = com.getPre()) != null) {
                    list.add(new RefsBaseDialog.E(unit, addr, str));
                }
                if (this.hideMC) continue;
                for (MetaComment mc : com.getMetaComments()) {
                    str = mc.toString();
                    if (str == null) continue;
                    list.add(new RefsBaseDialog.E(unit, addr, str));
                }
            }
        }
    }

    @Override
    protected void createPreButtonsArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new RowLayout());
        this.btnHideMC = UIUtil.createCheckbox(c, "Hide meta-comments", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowCommentsDialog.this.hideMC = ShowCommentsDialog.this.btnHideMC.getSelection();
                ShowCommentsDialog.this.reload(true);
            }
        });
    }
}

