/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.client.script.ScriptUtil;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ScriptEditorDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.handlers.file.scripts.ScriptEntry;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ScriptSelectorDialog
extends DataFrameDialog {
    RcpClientContext context;
    List<ScriptEntry> entries;
    private int selectedIndex = -1;

    public ScriptSelectorDialog(Shell parent, RcpClientContext context) {
        super(parent, "JEB Scripts", false, null);
        this.context = context;
        if (Licensing.isDebugBuild() && this.hasInstance()) {
            throw new IllegalStateException("A script selector dialog already exists!");
        }
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("Select and/or execute script(s), create new or edit existing scripts.\nDirectory: %s", this.context.getScriptsDirectory());
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public String getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex).getFile().getAbsolutePath();
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000, 0x50000000, 0x60000000, 0x70000000}, 32);
        this.hideButton(32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Execute";
        }
        if (btnId == 0x40000000) {
            return "Edit...";
        }
        if (btnId == 0x50000000) {
            return "Create...";
        }
        if (btnId == 0x60000000) {
            return "Browse...";
        }
        if (btnId == 0x70000000) {
            return "Refresh";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x30000000) {
            int index = this.getSelectedRow();
            if (index < 0 || index >= this.entries.size()) {
                return;
            }
            String path = this.entries.get(index).getFile().getAbsolutePath();
            this.context.executeScript(this.getShell(), path);
        } else if (buttonId == 0x40000000) {
            int index = this.getSelectedRow();
            if (index < 0 || index >= this.entries.size()) {
                return;
            }
            File file = this.entries.get(index).getFile();
            ScriptEditorDialog dlg = new ScriptEditorDialog(UI.getDockShell(), file, this.context);
            String text = ScriptSelectorDialog.readFile(file);
            dlg.getEditor().setTabSpaces(ScriptSelectorDialog.determineTabs(text));
            dlg.open();
        } else if (buttonId == 0x50000000) {
            String text;
            String classname;
            Object scriptname = UI.ask(this.getShell(), "New Script", "Script name?", "");
            if (scriptname == null) {
                return;
            }
            String tpl = "#?description=\n#?shortcut=\n\nfrom com.pnfsoftware.jeb.client.api import IScript, IGraphicalClientContext\nfrom com.pnfsoftware.jeb.core.units.code import ICodeUnit\n\nclass %s(IScript):\n  def run(self, ctx):\n    prj = ctx.getMainProject()\n    msg = 'Current project: ' + str(prj)\n    if isinstance(ctx, IGraphicalClientContext):\n      ctx.displayMessageBox('Info', msg, None, None)\n    else:\n      print(msg)  # headless mode (command line)\n";
            if (!((String)scriptname).endsWith(".py")) {
                scriptname = (String)scriptname + ".py";
            }
            if ((classname = ScriptUtil.filenameToClassname((String)scriptname)) == null) {
                UI.warn("Illegal script name: " + (String)scriptname);
                return;
            }
            File file = new File(this.context.getScriptsDirectory(), (String)scriptname);
            ScriptEditorDialog dlg = new ScriptEditorDialog(UI.getDockShell(), file, this.context);
            if (file.isFile()) {
                text = ScriptSelectorDialog.readFile(file);
            } else {
                text = Strings.ff(tpl, classname);
                dlg.setContents(text);
            }
            dlg.getEditor().setTabSpaces(ScriptSelectorDialog.determineTabs(text));
            dlg.open();
        } else if (buttonId == 0x60000000) {
            String path = this.askForScriptPath();
            if (path != null) {
                this.context.executeScript(this.getShell(), path);
            }
        } else if (buttonId == 0x70000000) {
            this.reload();
            this.refresh();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    static String readFile(File file) {
        String buffer;
        try {
            buffer = Strings.decodeLocal(IO.readFile(file));
        }
        catch (IOException iOException) {
            buffer = "# error: cannot read file";
        }
        return buffer;
    }

    static int determineTabs(String buffer) {
        for (String line : Strings.splitLines(buffer)) {
            if (!line.trim().startsWith("def ")) continue;
            return line.indexOf("def ");
        }
        return 0;
    }

    private String askForScriptPath() {
        return ScriptSelectorDialog.askForScriptPath(this.getShell(), this.context);
    }

    static String askForScriptPath(Shell shell, RcpClientContext context) {
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setText(S.s(318));
        dlg.setFilterExtensions(new String[]{"*.py", "*.*"});
        dlg.setFilterNames(new String[]{S.s(674) + " (*.py)", S.s(55) + " (*.*)"});
        try {
            String defaultDir = context.getDefaultPathForDialog("dlgJebFileExecuteScript");
            if (defaultDir == null || !new File(defaultDir).exists()) {
                defaultDir = new File(context.getScriptsDirectory()).getAbsolutePath();
            }
            dlg.setFilterPath(defaultDir);
        }
        catch (Exception exception) {}
        String path = dlg.open();
        if (path != null) {
            String newDefaultDir = new File(path).getParent();
            context.setDefaultPathForDialog("dlgJebFileExecuteScript", newDefaultDir);
        }
        return path;
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame(S.s(591), "Shortcut", "Location", S.s(268), S.s(818), S.s(86));
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = this.context.getScriptManager().getEntries(false, false);
        final IdentityHashMap<ScriptEntry, String> locmap = new IdentityHashMap<ScriptEntry, String>();
        File scriptsdir = new File(this.context.getScriptsDirectory());
        for (ScriptEntry e : this.entries) {
            String relloc = IO.getRelativePath(e.getFile().getParentFile(), scriptsdir);
            if (relloc == null) {
                relloc = "";
            }
            locmap.put(e, relloc);
        }
        final Comparator<String> cmp = Strings.getComparator(false, false);
        this.entries.sort(new Comparator<ScriptEntry>(){

            @Override
            public int compare(ScriptEntry o1, ScriptEntry o2) {
                String loc2;
                String loc1 = (String)locmap.get(o1);
                int r = loc1.compareTo(loc2 = (String)locmap.get(o2));
                if (r != 0) {
                    return r;
                }
                return cmp.compare(o1.getName(), o2.getName());
            }
        });
        for (ScriptEntry e : this.entries) {
            String name = e.getName();
            String shortcut = e.getMetadata().getShortcutString();
            String desc = e.getMetadata().getDescription();
            String author = e.getMetadata().getAuthor();
            Version ver = e.getMetadata().getVersion();
            String version = ver == null ? "" : ver.toString();
            String relloc = (String)locmap.get(e);
            df.addRow(name, shortcut, relloc, desc, version, author);
        }
    }
}

