/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ContentAssistedText;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RenameItemDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(RenameItemDialog.class);
    private TextHistory wTextHistory;
    private ContentAssistedText wText;
    private Button wBypassNameChecks;
    private String description;
    private String initialValue;
    private String originalValue;
    private String inputValue;
    private boolean bypassNameChecks;

    public RenameItemDialog(Shell parent, TextHistory textHistory) {
        super(parent, S.s(678), true, true);
        this.scrolledContainer = true;
        this.wTextHistory = textHistory;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public String getName() {
        return this.inputValue;
    }

    public void setBypassNameChecks(boolean bypassNameChecks) {
        this.bypassNameChecks = bypassNameChecks;
    }

    public boolean isBypassNameChecks() {
        return this.bypassNameChecks;
    }

    @Override
    public String open() {
        super.open();
        return this.inputValue;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        Label hint = new Label(parent, 64);
        hint.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        hint.setText(this.description != null ? this.description : "Rename the selected item. Leave empty to reset to original value.");
        if (this.originalValue != null) {
            ContentAssistedText text0 = new ContentAssistedText(parent, 2048, "Original:\t", null, false);
            text0.setLayoutData(UIUtil.createGridDataFillHorizontally());
            text0.setText(this.originalValue);
            text0.getWidget().setEditable(false);
        }
        this.wText = new ContentAssistedText(parent, 2048, S.s(591) + ":\t", this.wTextHistory, true);
        this.wText.setLayoutData(UIUtil.createGridDataFillHorizontally());
        if (this.initialValue != null) {
            this.wText.getWidget().setText(this.initialValue);
            this.wText.getWidget().forceFocus();
            if (!OSType.determine().isWindows()) {
                this.wText.getWidget().selectAll();
            } else {
                parent.getDisplay().timerExec(5, new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RenameItemDialog.this.wText.selectAll();
                        }
                        catch (Exception exception) {}
                    }
                });
            }
        }
        UIUtil.disableTabOutput((Control)this.wText);
        Group c1 = UIUtil.createGroupGrid(parent, 0, "Options", 1, 1);
        this.wBypassNameChecks = UIUtil.createCheckbox((Composite)c1, "Bypass naming conflict checks", null);
        this.wBypassNameChecks.setSelection(this.bypassNameChecks);
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        this.wText.confirm();
        this.inputValue = this.wText.getText();
        this.bypassNameChecks = this.wBypassNameChecks.getSelection();
        super.onConfirm();
    }
}

