/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class RefsBaseDialog
extends DataFrameDialog {
    private static final ILogger logger = GlobalLog.getLogger(RefsBaseDialog.class);
    protected RcpClientContext context;
    protected boolean displayUnitPath;
    protected String[] extraColumns;
    private DataFrame df;
    private List<E> entries;
    protected Integer selectedIndex = null;

    public RefsBaseDialog(Shell parent, String caption, RcpClientContext context, boolean displayUnitPath, String ... extraColumns) {
        super(parent, caption, false, "refsBaseDialog");
        this.context = context;
        this.displayUnitPath = displayUnitPath;
        this.extraColumns = extraColumns;
        ArrayList<String> cols = new ArrayList<String>();
        if (displayUnitPath) {
            cols.add(S.s(785));
        }
        cols.add(S.s(52));
        for (String col : extraColumns) {
            cols.add(col);
        }
        this.df = new DataFrame(cols);
        this.setDataFrame(this.df);
        this.setDisplayIndex(true);
    }

    @Override
    public Integer open() {
        this.reload(false);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public Couple<IUnit, String> getSelectedEntry() {
        if (this.selectedIndex == null) {
            return null;
        }
        E e = this.entries.get(this.selectedIndex);
        if (e == null) {
            return null;
        }
        return new Couple<IUnit, String>(e.unit, e.address);
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000}, 32);
        this.hideButton(32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Navigate";
        }
        if (btnId == 0x40000000) {
            return "Refresh";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x30000000) {
            int index = this.getSelectedRow();
            if (index < 0 || index >= this.entries.size()) {
                return;
            }
            this.onNavigationRequest(this.entries.get(index));
        } else if (buttonId == 0x40000000) {
            this.reload(true);
        } else {
            super.onButtonClick(buttonId);
        }
    }

    protected abstract List<E> provide();

    protected boolean onNavigationRequest(E e) {
        if (this.context != null && e.unit != null && e.address != null) {
            return GraphicalActionExecutor.gotoAddress(this.context, e.unit, e.address);
        }
        return false;
    }

    protected void reload(boolean refreshUI) {
        this.df.clear();
        this.entries = this.provide();
        for (E e : this.entries) {
            ArrayList<Object> row = new ArrayList<Object>();
            if (this.displayUnitPath) {
                row.add(e.unit == null ? null : UnitUtil.buildFullyQualifiedUnitPath(e.unit));
            }
            row.add(e.address);
            for (int i = 0; i < this.extraColumns.length; ++i) {
                row.add(e.extras[i]);
            }
            this.df.addRow(row);
        }
        if (refreshUI) {
            this.refresh();
        }
    }

    public static class E {
        IUnit unit;
        String address;
        String[] extras;

        E(IUnit unit, String address, String ... extras) {
            this.unit = unit;
            this.address = address;
            this.extras = extras;
        }
    }
}

