/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUnitUtil;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReferencesDialog
extends DataFrameDialog {
    private static final ILogger logger = GlobalLog.getLogger(ReferencesDialog.class);
    private IUnit unit;

    public ReferencesDialog(Shell parent, String caption, List<String> addresses, List<String> details, IUnit unit) {
        this(parent, caption, addresses, details, unit, true);
    }

    public ReferencesDialog(Shell parent, String caption, List<String> addresses, List<String> details, IUnit unit, boolean showLabels) {
        super(parent, caption, false, "referencesDialog");
        DataFrame df;
        this.unit = unit;
        if (addresses == null) {
            Object[] cfr_ignored_0 = new Object[0];
            addresses = new ArrayList<String>();
        }
        if (details != null && details.size() != addresses.size()) {
            throw new IllegalArgumentException();
        }
        if (unit instanceof IInteractiveUnit) {
            IInteractiveUnit iunit = (IInteractiveUnit)unit;
            df = showLabels ? new DataFrame(S.s(52), S.s(424), details != null ? S.s(270) : S.s(203)) : new DataFrame(S.s(52), details != null ? S.s(270) : S.s(203));
            df.setRenderedBaseForNumberObjects(16);
            int i = 0;
            for (String address : addresses) {
                Object label = iunit.getAddressLabel(address);
                if (label == null && unit instanceof INativeCodeUnit) {
                    label = ((INativeCodeUnit)iunit).getCanonicalMemoryAddress(address);
                }
                String extra = details == null || details.get(i) == null ? iunit.getFullComment(address) : details.get(i);
                if (showLabels) {
                    df.addRow(address, label, extra);
                } else {
                    df.addRow(address, extra);
                }
                ++i;
            }
        } else {
            df = new DataFrame(S.s(52));
            for (String address : addresses) {
                df.addRow(address);
            }
        }
        this.setDataFrame(df);
        this.setDisplayIndex(true);
    }

    @Override
    public void createContents(Composite parent) {
        if (this.unit != null) {
            UIUnitUtil.setAutoCloseWhenDisposed(this.getShell(), this.unit);
        }
        super.createContents(parent);
    }
}

