/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.QuickSearchView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class QuickSearchDialog
extends JebDialog {
    public static final int RETCODE_OKAY = 0;
    public static final int RETCODE_OPEN_LEGACY_DIALOG = 1;
    private static int savedScopeId = -1;
    private static boolean savedCaseSensitive = false;
    private static int savedMaxResultsPerSearch = -1;
    private static String savedSearchString = null;
    RcpClientContext context;
    QuickSearchView v;
    IRuntimeProject sourceProject;
    IUnit sourceUnit;
    ITextDocument sourceDoc;
    ICoordinates sourceDocCoord;
    String searchString;
    int retcode = 0;

    public QuickSearchDialog(Shell parent, RcpClientContext context) {
        super(parent, "Quick Search (Find)", true, false);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.context = context;
    }

    @Override
    public Integer open() {
        super.open();
        savedScopeId = this.v.getCurrentScopeId();
        savedCaseSensitive = this.v.getCaseSensitive();
        savedMaxResultsPerSearch = this.v.getMaxResultsPerSearch();
        savedSearchString = this.v.getSearchString();
        return this.retcode;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        this.v = new QuickSearchView(parent, this.context, true);
        this.v.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.v.setSource(this.sourceProject);
        this.v.setSource(this.sourceUnit);
        this.v.setSource(this.sourceDoc, this.sourceDocCoord);
        this.v.setCurrentScopeId(savedScopeId);
        this.v.setCaseSensitive(savedCaseSensitive);
        this.v.setMaxResultsPerSearch(savedMaxResultsPerSearch);
        this.v.setSearchString(this.searchString != null ? this.searchString : savedSearchString);
        this.createButtons(parent, new int[]{256, 0x10000000, 0x30000000}, 0);
        this.v.setFocus();
        if (QuickSearchDialog.getStandardWidgetManager() != null) {
            QuickSearchDialog.getStandardWidgetManager().wrapWidget((Control)this.v, ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.v.setCurrentScopeId(savedScopeId);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "&Legacy Dialog ...";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 256) {
            this.shell.close();
        } else if (buttonId == 0x30000000) {
            this.retcode = 1;
            this.shell.close();
        } else if (buttonId == 0x10000000) {
            String msg = "Interactive quick search.\n\nThe search string may use * to match any number of characters (0+), or ? to match any character (1).\n\nSearch scope:\n- All text documents generated by all units of the current project.\n- All text documents generated by the current unit (based on selected fragment/view).\n- The currently active text document.\n\nSelect a result and press Enter or double-click to navigate to the result location in the corresponding document.\n\nNote: currently, only unit text documents are searched. Other interactive documents, such as tables or trees, are not considered.\n";
            UI.info(this.shell, "Help", msg);
        }
    }

    public void setSource(IRuntimeProject prj) {
        this.sourceProject = prj;
    }

    public void setSource(IUnit unit) {
        this.sourceUnit = unit;
    }

    public void setSource(ITextDocument doc, ICoordinates coord) {
        this.sourceDoc = doc;
        this.sourceDocCoord = coord;
    }

    public void setSearchString(String str) {
        this.searchString = str;
    }
}

