/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.core.properties.impl.PropertyUtil;
import com.pnfsoftware.jeb.rcpclient.dialogs.PDMView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PropertiesView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(PropertiesView.class);
    private FilteredTreeViewer treeviewer;
    private PDMView pdmview;
    private IPropertyManager pm;
    private boolean hidePDMTree;
    private String wantedGroup;
    private int mustHaveFlags;
    private int cantHaveFlags;
    private PropertyChangeObject co = new PropertyChangeObject();
    private Map<IPropertyDefinitionManager, Point> sctlOriginMap = new IdentityHashMap<IPropertyDefinitionManager, Point>();

    public PropertiesView(Composite parent, int style, IPropertyManager pm, boolean hidePDMTree) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        if (pm == null) {
            throw new IllegalArgumentException();
        }
        this.pm = pm;
        this.hidePDMTree = hidePDMTree;
        this.build();
    }

    public PropertyChangeObject retrieveChangedProperties(boolean includeCurrent) {
        if (includeCurrent) {
            this.pdmview.retrieveChanges(this.co);
        }
        return this.co;
    }

    private void build() {
        SashForm sash = new SashForm((Composite)this, 0);
        this.treeviewer = new PatternTreeViewer((Composite)sash, 2048, null, null, true);
        ContentProviderListener p = new ContentProviderListener();
        this.treeviewer.setContentProvider(p);
        this.treeviewer.setLabelProvider(new LabelProvider());
        this.treeviewer.setInput(this.pm);
        this.treeviewer.expandAll();
        if (this.hidePDMTree) {
            this.treeviewer.getFilteredTreeWidget().setVisible(false);
        }
        final ScrolledComposite sctl = new ScrolledComposite((Composite)sash, 768);
        sctl.setExpandHorizontal(true);
        sctl.setExpandVertical(true);
        this.pdmview = new PDMView((Composite)sctl, 0, this.pm);
        this.pdmview.setPropertyChangeObject(this.co);
        this.pdmview.setSortOptionsAlphabetically(false);
        sctl.setContent((Control)this.pdmview);
        sctl.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PropertiesView.updatePDMContainer(sctl, PropertiesView.this.pdmview);
            }
        });
        sash.setWeights(new int[]{25, 75});
        this.treeviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            @Override
            public void selectionChanged(SelectionChangedEvent event) {
                IPropertyDefinitionManager pdm;
                String cfr_ignored_0 = "Selection: " + event;
                Object[] cfr_ignored_1 = new Object[0];
                ITreeSelection sel = (ITreeSelection)event.getStructuredSelection();
                if (sel != null && (pdm = (IPropertyDefinitionManager)sel.getFirstElement()) != null) {
                    PropertiesView.this.pdmview.retrieveChanges(PropertiesView.this.co);
                    if (PropertiesView.this.pdmview.getPDM() != null) {
                        PropertiesView.this.sctlOriginMap.put(PropertiesView.this.pdmview.getPDM(), sctl.getOrigin());
                    }
                    PropertiesView.this.pdmview.setPDM(pdm, PropertiesView.this.wantedGroup, PropertiesView.this.mustHaveFlags, PropertiesView.this.cantHaveFlags);
                    PropertiesView.updatePDMContainer(sctl, PropertiesView.this.pdmview);
                    Point org = null;
                    if (pdm != null) {
                        org = PropertiesView.this.sctlOriginMap.get(pdm);
                    }
                    if (org == null) {
                        org = new Point(0, 0);
                    }
                    try {
                        sctl.setOrigin(org);
                    }
                    catch (SWTException sWTException) {}
                }
            }
        });
    }

    public void setSelectedNamespace(IPropertyDefinitionManager region) {
        if (region == null) {
            return;
        }
        this.treeviewer.setSelection(new StructuredSelection(region), true);
    }

    private static void updatePDMContainer(ScrolledComposite container, Composite composite) {
        container.setMinSize(composite.computeSize(container.getClientArea().width, -1));
    }

    public void setPropertyManager(IPropertyManager pm) {
        this.pm = pm;
    }

    public void setFilters(String wantedGroup, int mustHaveFlags, int cantHaveFlags) {
        this.wantedGroup = wantedGroup;
        this.mustHaveFlags = mustHaveFlags;
        this.cantHaveFlags = cantHaveFlags;
    }

    class ContentProviderListener
    implements IFilteredTreeContentProvider {
        private Object input0;

        ContentProviderListener() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input0 = newInput;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IPropertyManager) {
                return new Object[]{((IPropertyManager)inputElement).getPropertyDefinitionManager()};
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IPropertyDefinitionManager) {
                IPropertyDefinitionManager pdm = (IPropertyDefinitionManager)parentElement;
                ArrayList<IPropertyDefinitionManager> list = new ArrayList<IPropertyDefinitionManager>();
                for (IPropertyDefinitionManager p : pdm.getChildren()) {
                    if (!PropertyUtil.hasDescendants(p, PropertiesView.this.mustHaveFlags, PropertiesView.this.cantHaveFlags)) continue;
                    list.add(p);
                }
                if ((pdm.getFlags() & 0x20) == 0) {
                    list.sort(new Comparator<IPropertyDefinitionManager>(){

                        @Override
                        public int compare(IPropertyDefinitionManager o1, IPropertyDefinitionManager o2) {
                            return o1.getRegion().compareTo(o2.getRegion());
                        }
                    });
                }
                return list.toArray();
            }
            return ArrayUtil.NO_OBJECT;
        }

        @Override
        public Object getParent(Object element) {
            if (element instanceof IPropertyDefinitionManager) {
                return ((IPropertyDefinitionManager)element).getParent();
            }
            return null;
        }

        @Override
        public boolean hasChildren(Object element) {
            if (element instanceof IPropertyDefinitionManager) {
                return ((IPropertyDefinitionManager)element).hasChildren();
            }
            return false;
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 1;
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof IPropertyDefinitionManager) {
                IPropertyDefinitionManager pdm = (IPropertyDefinitionManager)element;
                switch (key) {
                    case 0: {
                        return pdm.isRoot() ? "root" : pdm.getRegion();
                    }
                }
            }
            return null;
        }
    }
}

