/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.PropertiesView;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PropertiesDialog
extends JebDialog {
    PropertiesView v;
    IPropertyManager pm;
    boolean hidePDMTree;
    IPropertyDefinitionManager selNs0;
    String wantedGroup;
    int defMustHave = 0;
    int defCantHave = 1;
    boolean showApplyButton;
    boolean success;
    boolean displayDoNotShow;
    Button btnDoNotShow;
    boolean doNotShowValue;

    public PropertiesDialog(Shell parent, String caption, IPropertyManager pm, String dlgInternalName) {
        super(parent, caption, true, true, dlgInternalName);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        if (pm == null) {
            throw new IllegalArgumentException();
        }
        this.pm = pm;
    }

    public PropertiesDialog(Shell parent, String caption, IPropertyManager pm) {
        this(parent, caption, pm, null);
    }

    public void setShowInternalProperties() {
        this.defCantHave &= 0xFFFFFFFE;
    }

    public void setShowApplyButton(boolean showApplyButton) {
        this.showApplyButton = showApplyButton;
    }

    public void setHidePDMTree(boolean hidePDMTree) {
        this.hidePDMTree = hidePDMTree;
    }

    public void setSelectedNamespace(IPropertyDefinitionManager selRegion0) {
        this.selNs0 = selRegion0;
    }

    public void setFilters(String wantedGroup, int defMustHave, int defCantHave) {
        this.wantedGroup = wantedGroup;
        this.defMustHave = defMustHave;
        this.defCantHave = defCantHave;
    }

    public void setShowDoNotShowTickbox(boolean displayDoNotShow) {
        this.displayDoNotShow = displayDoNotShow;
    }

    public boolean getDoNotShowValue() {
        return this.doNotShowValue;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        this.v = new PropertiesView(parent, 0, this.pm, this.hidePDMTree);
        this.v.setFilters(this.wantedGroup, this.defMustHave, this.defCantHave);
        this.applyStandardGridDataForDialogWidget((Control)this.v);
        if (this.selNs0 != null) {
            this.v.setSelectedNamespace(this.selNs0);
        }
        if (this.displayDoNotShow) {
            this.btnDoNotShow = UIUtil.createCheckbox(parent, "Do not show this dialog in the future (always use current settings)", null);
        }
        this.addExtraContents(parent);
        if (this.showApplyButton) {
            this.createButtons(parent, new int[]{32, 256, 0x20000000}, 32);
        } else {
            this.createOkayCancelButtons(parent);
        }
    }

    protected void addExtraContents(Composite parent) {
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 0x20000000) {
            PropertyChangeObject co = this.v.retrieveChangedProperties(true);
            co.commit();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    @Override
    protected void onConfirm() {
        PropertyChangeObject co = this.v.retrieveChangedProperties(true);
        co.commit();
        this.success = true;
        if (this.btnDoNotShow != null) {
            this.doNotShowValue = this.btnDoNotShow.getSelection();
        }
        super.onConfirm();
    }

    @Override
    protected void onCancel() {
        PropertyChangeObject co = this.v.retrieveChangedProperties(true);
        int cnt = co.size();
        if (cnt > 0) {
            String msg = Strings.ff("Are you sure you want to cancel the property changes? (%d %s)", cnt, PluralFormatter.countS(cnt, "change"));
            if (!UI.confirm(this.getShell(), "Cancel update", msg)) {
                return;
            }
        }
        super.onCancel();
    }
}

