/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathDialog
extends JebDialog {
    Type type;
    String msg;
    String defaultPath;
    Text wPath;
    String selectedPath;

    public PathDialog(Shell parent, Type type, String msg, String defaultPath) {
        super(parent, "Path selection", true, true, null);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.msg = msg;
        this.defaultPath = defaultPath;
    }

    @Override
    public String open() {
        super.open();
        return this.selectedPath;
    }

    @Override
    protected void onConfirm() {
        this.selectedPath = this.wPath.getText();
        super.onConfirm();
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        UIUtil.createWrappedLabel(parent, Strings.safe(this.msg, "Provide a valid path"));
        Composite c1 = UIUtil.createCompositeGrid(parent, 0, 1, 2, null);
        this.wPath = UIUtil.createTextboxInGrid(c1, 2048, 60, 1);
        if (this.defaultPath != null) {
            this.wPath.setText(this.defaultPath);
        }
        UIUtil.createTightPushbox(c1, "Select...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path1 = null;
                switch (PathDialog.this.type) {
                    case SELECT_FILE: 
                    case SAVE_TO_FILE: {
                        FileDialog dlg = new FileDialog(PathDialog.this.getShell(), PathDialog.this.type == Type.SELECT_FILE ? 4096 : 8192);
                        dlg.setText("Create or save to file...");
                        String path = PathDialog.this.wPath.getText();
                        if (path != null && path.length() > 0) {
                            File file = new File(path);
                            File base = file.getParentFile();
                            if (base != null && base.isDirectory()) {
                                dlg.setFilterPath(base.getAbsolutePath());
                            }
                            String name = file.getName();
                            dlg.setFileName(name);
                        }
                        path1 = dlg.open();
                        break;
                    }
                    case SELECT_FOLDER: {
                        File file;
                        DirectoryDialog dlg = new DirectoryDialog(PathDialog.this.getShell());
                        dlg.setText("Select a folder...");
                        String path = PathDialog.this.wPath.getText();
                        if (path != null && path.length() > 0 && (file = new File(path)).isDirectory()) {
                            dlg.setFilterPath(path);
                        }
                        path1 = dlg.open();
                    }
                }
                if (path1 != null) {
                    PathDialog.this.wPath.setText(path1);
                }
            }
        });
        this.createOkayCancelButtons(parent);
    }

    public static enum Type {
        SAVE_TO_FILE,
        SELECT_FILE,
        SELECT_FOLDER;

    }
}

