/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinition;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionGroup;
import com.pnfsoftware.jeb.core.properties.IPropertyDefinitionManager;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.properties.IPropertyType;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.IPropertyTypePath;
import com.pnfsoftware.jeb.core.properties.IPropertyTypeString;
import com.pnfsoftware.jeb.core.properties.impl.PropertyChangeObject;
import com.pnfsoftware.jeb.core.properties.impl.PropertyInputSizeHint;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeBoolean;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeInteger;
import com.pnfsoftware.jeb.core.properties.impl.PropertyTypeSelection;
import com.pnfsoftware.jeb.core.properties.impl.PropertyUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.GridDataMaker;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PDMView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(PDMView.class);
    private Composite ph;
    private String description;
    private Map<String, Control> controlmap = new LinkedHashMap<String, Control>();
    private boolean sortOptionsAlphabetically;
    private IPropertyDefinitionManager pdm;
    private IPropertyManager pm;
    private String wantedGroup;
    private int mustHaveFlags;
    private int cantHaveFlags;
    private PropertyChangeObject co;
    private static final String flagPropertyType = "propertyType";
    private static final String flagPropertyFQN = "propertyFQN";
    private static final String flagModified = "modified";
    private boolean globalDisableModFlagRecording;

    public PDMView(Composite parent, int style, IPropertyManager pm) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        if (pm == null) {
            throw new IllegalArgumentException();
        }
        this.pm = pm;
    }

    public void setPropertyChangeObject(PropertyChangeObject co) {
        this.co = co;
    }

    public void setSortOptionsAlphabetically(boolean sortOptionsAlphabetically) {
        this.sortOptionsAlphabetically = sortOptionsAlphabetically;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPDM(IPropertyDefinitionManager pdm, String wantedGroup, int mustHaveFlags, int cantHaveFlags) {
        this.pdm = pdm;
        this.wantedGroup = wantedGroup;
        this.mustHaveFlags = mustHaveFlags;
        this.cantHaveFlags = cantHaveFlags;
        this.build();
    }

    public IPropertyDefinitionManager getPDM() {
        return this.pdm;
    }

    private void build() {
        if (this.ph != null) {
            this.ph.dispose();
            this.ph = null;
            this.controlmap.clear();
        }
        if (this.pdm == null) {
            return;
        }
        this.ph = new Composite((Composite)this, 0);
        UIUtil.setStandardLayout(this.ph, 1);
        if (this.description != null) {
            UIUtil.createLabelInGridLayout(this.ph, 0, this.description, 1);
        }
        final LinkedHashMap<CallSite, IPropertyDefinition> alldefs = new LinkedHashMap<CallSite, IPropertyDefinition>();
        IPropertyDefinitionManager pdm0 = this.pdm;
        if (!Strings.isBlank(pdm0.getDescription())) {
            Label label = UIUtil.createWrappedLabel(this.ph, 2048, pdm0.getDescription());
            label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 100, -1, true));
        }
        for (IPropertyDefinitionGroup pdmgrp : pdm0.getGroups()) {
            if (this.wantedGroup != null && !pdmgrp.getName().equals(this.wantedGroup)) continue;
            Object g = pdmgrp.isDefaultGroup() ? UIUtil.createCompositeGrid(this.ph, 0, 1, 2, 0) : UIUtil.createGroupGrid(this.ph, 0, Strings.capitalizeFirst(pdmgrp.getName()) + " properties", 1, 2);
            ArrayList<IPropertyDefinition> defs = new ArrayList<IPropertyDefinition>(pdmgrp.getDefinitions());
            if (this.sortOptionsAlphabetically) {
                Collections.sort(defs, new Comparator<IPropertyDefinition>(){

                    @Override
                    public int compare(IPropertyDefinition o1, IPropertyDefinition o2) {
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }
                });
            }
            for (IPropertyDefinition def : defs) {
                Group sub;
                Object propdesc;
                String name1;
                if ((def.getFlags() & this.mustHaveFlags) != this.mustHaveFlags || (def.getFlags() & this.cantHaveFlags) != 0) continue;
                String name = def.getName();
                try {
                    name1 = Strings.camelCaseToString(name, true, true);
                }
                catch (ParseException parseException) {
                    name1 = name;
                }
                String propfqn = pdm0.getNamespace() + "." + name;
                alldefs.put((CallSite)((Object)propfqn), def);
                IPropertyType t0 = def.getType();
                Object propdescTooltip = propdesc = def.getDescription();
                Button ctl = null;
                if ((def.getFlags() & 8) != 0) {
                    sub = UIUtil.createGroupGrid(g, 0, name1, 2, 1);
                } else {
                    sub = UIUtil.createCompositeGrid(g, 0, 2, 1, 0);
                    propdesc = name1 + (String)(Strings.isBlank((CharSequence)propdesc) ? "" : ": " + (String)propdesc);
                }
                if (t0 instanceof PropertyTypeBoolean) {
                    Composite c = UIUtil.createCompositeGrid((Composite)sub, 0, 1, 2, 0);
                    final Button btn = new Button(c, 96);
                    btn.setLayoutData((Object)new GridData(16384, 128, false, false));
                    Label label = UIUtil.createWrappedLabel(c, (String)propdesc);
                    label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 100, -1, true));
                    label.addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent e) {
                            btn.setSelection(!btn.getSelection());
                            PDMView.this.setModifiedFlag((Control)btn, true);
                        }
                    });
                    btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PDMView.this.setModifiedFlag((Control)btn, true);
                        }
                    });
                    ctl = btn;
                } else if (t0 instanceof PropertyTypeInteger) {
                    int textlen = 6;
                    PropertyInputSizeHint hint = PropertyUtil.getSizeHint(def.getFlags());
                    switch (hint) {
                        case TINY: {
                            textlen = 2;
                            break;
                        }
                        case SMALL: {
                            textlen = 4;
                            break;
                        }
                        case LARGE: {
                            textlen = 10;
                            break;
                        }
                        case EXTRA: {
                            textlen = 16;
                        }
                    }
                    Composite c = UIUtil.createCompositeGrid((Composite)sub, 0, 1, 2, 0);
                    final Text text = UIUtil.createTextboxInGrid(c, 2052, textlen, 1);
                    GridDataMaker.update((Control)text).setVerticalAlignment(128).apply();
                    label = UIUtil.createWrappedLabel(c, (String)propdesc);
                    label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 100, -1, true));
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            PDMView.this.setModifiedFlag((Control)text, true);
                        }
                    });
                    ctl = text;
                } else if (t0 instanceof IPropertyTypeString) {
                    Text text;
                    t = (IPropertyTypeString)t0;
                    PropertyInputSizeHint hint = PropertyUtil.getSizeHint(def.getFlags());
                    switch (hint) {
                        case TINY: 
                        case SMALL: {
                            Composite c = UIUtil.createCompositeGrid((Composite)sub, 0, 1, 2, 0);
                            text = UIUtil.createTextboxInGrid(c, 2052, hint == PropertyInputSizeHint.TINY ? 5 : 10, 1);
                            GridDataMaker.update((Control)text).setVerticalAlignment(128).apply();
                            label = UIUtil.createWrappedLabel(c, (String)propdesc);
                            label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 100, -1, true));
                            break;
                        }
                        default: {
                            Label label = UIUtil.createWrappedLabel((Composite)sub, (String)propdesc);
                            label.setLayoutData((Object)UIUtil.createGridDataForText((Control)label, 100, -1, true));
                            if (hint == PropertyInputSizeHint.LARGE || hint == PropertyInputSizeHint.EXTRA) {
                                text = UIUtil.createTextboxInGrid((Composite)sub, 2112, 80, hint == PropertyInputSizeHint.LARGE ? 2 : 5, true, false);
                                UIUtil.disableTabOutput((Control)text);
                                break;
                            }
                            text = UIUtil.createTextboxInGrid((Composite)sub, 2052, 80, 1, true, false);
                        }
                    }
                    if (t instanceof IPropertyTypePath) {
                        text.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseUp(MouseEvent e) {
                                DirectoryDialog dlg = new DirectoryDialog(PDMView.this.getShell(), 0);
                                dlg.setFilterPath(text.getText());
                                String path = dlg.open();
                                if (path != null) {
                                    text.setText(path);
                                    PDMView.this.layout(true, true);
                                }
                            }
                        });
                    }
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            PDMView.this.setModifiedFlag((Control)text, true);
                        }
                    });
                    ctl = text;
                } else if (t0 instanceof PropertyTypeSelection) {
                    t = (PropertyTypeSelection)t0;
                    for (PropertyTypeSelection.E e : ((PropertyTypeSelection)t).getEntries()) {
                        propdescTooltip = (String)propdescTooltip + "\n- " + e.getValue();
                        if (Strings.isBlank(e.getDescription())) continue;
                        propdescTooltip = (String)propdescTooltip + ": " + e.getDescription();
                    }
                    Composite c = UIUtil.createCompositeGrid((Composite)sub, 0, 1, 2, 0);
                    final Combo combo = new Combo(c, 2056);
                    int i = 0;
                    for (PropertyTypeSelection.E e : ((PropertyTypeSelection)t).getEntries()) {
                        combo.add(e.getValue());
                        combo.setData("sel_" + i, (Object)e);
                        ++i;
                    }
                    combo.pack();
                    Label label2 = UIUtil.createWrappedLabel(c, (String)propdesc);
                    label2.setLayoutData((Object)UIUtil.createGridDataForText((Control)label2, 100, -1, true));
                    Object label2Orig = propdesc;
                    combo.addModifyListener(new ModifyListener(){
                        final /* synthetic */ String val$label2Orig;
                        final /* synthetic */ PropertyTypeSelection val$t;
                        final /* synthetic */ Label val$label2;
                        {
                            this.val$label2Orig = string;
                            this.val$t = propertyTypeSelection;
                            this.val$label2 = label;
                        }

                        public void modifyText(ModifyEvent e) {
                            PDMView.this.setModifiedFlag((Control)combo, true);
                            Object text = this.val$label2Orig;
                            String seldesc = this.val$t.getEntries().get(combo.getSelectionIndex()).getDescription();
                            if (!Strings.isBlank(seldesc)) {
                                text = (String)text + " (" + seldesc + ")";
                            }
                            if (!Strings.equals((String)text, this.val$label2.getText())) {
                                this.val$label2.setText((String)text);
                                if (!PDMView.this.globalDisableModFlagRecording) {
                                    PDMView.this.layout(true, true);
                                }
                            }
                        }
                    });
                    ctl = combo;
                } else {
                    if (Licensing.isDebugBuild()) {
                        throw new RuntimeException("Implement property type: " + t0);
                    }
                    new Label((Composite)sub, 0).setText("-");
                }
                if (ctl == null) continue;
                if (!Strings.isBlank((CharSequence)propdescTooltip)) {
                    ctl.setToolTipText(Strings.ff("Property: %s\nType: %s\nDescription: %s", propfqn, def.getType(), propdescTooltip));
                }
                if (ctl instanceof Text) {
                    ctl.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            ((Text)e.widget).selectAll();
                        }
                    });
                }
                ctl.setData(flagPropertyType, (Object)t0);
                ctl.setData(flagPropertyFQN, (Object)propfqn);
                this.controlmap.put(propfqn, (Control)ctl);
            }
        }
        this.globalDisableModFlagRecording = true;
        for (String propfqn : this.controlmap.keySet()) {
            Object storedValue = null;
            if (this.co != null && this.co.has(propfqn)) {
                storedValue = this.co.get(propfqn);
            }
            this.updatePropertyWidget(propfqn, storedValue);
        }
        this.globalDisableModFlagRecording = false;
        Composite buttons = UIUtil.createCompositeGrid(this.ph, 0, 1, 3, null);
        UIUtil.createPushbox(buttons, "Apply Changes", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UI.question(PDMView.this.getShell(), "Warning", "This operation cannot be undone.\n\nContinue?")) {
                    return;
                }
                PropertyChangeObject co = PDMView.this.retrieveChanges(null);
                if (!co.isEmpty()) {
                    co.commit();
                }
                PDMView.this.resetModifiedFlag();
            }
        });
        UIUtil.createPushbox(buttons, "Reset to Defaults", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UI.question(PDMView.this.getShell(), "Warning", "This operation cannot be undone.\n\nContinue?")) {
                    return;
                }
                for (String propfqn : alldefs.keySet()) {
                    PDMView.this.pm.setValue(propfqn, null);
                    Object val = PDMView.this.pm.getValue(propfqn);
                    Object val0 = PDMView.this.pm.getValue(propfqn, 1, true, true);
                    if (val != null && !val.equals(val0)) {
                        PDMView.this.pm.setValue(propfqn, val0);
                        val = val0;
                    }
                    PDMView.this.updatePropertyWidget(propfqn, val);
                }
                PDMView.this.resetModifiedFlag();
            }
        });
        UIUtil.createPushbox(buttons, "Reset to Current", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!UI.question(PDMView.this.getShell(), "Warning", "This operation cannot be undone.\n\nContinue?")) {
                    return;
                }
                for (String propfqn : alldefs.keySet()) {
                    Object val = PDMView.this.pm.getValue(propfqn);
                    PDMView.this.updatePropertyWidget(propfqn, val);
                }
                PDMView.this.resetModifiedFlag();
            }
        });
        this.pack(true);
    }

    void updatePropertyWidget(String propfqn, Object storedValue) {
        IPropertyDefinition def = PropertyUtil.getDefinition(this.pdm, propfqn);
        if (def.getType() instanceof IPropertyTypeBoolean) {
            this.updateWidgetBooleanProperty(propfqn, storedValue);
        } else if (def.getType() instanceof IPropertyTypeString) {
            this.updateWidgetStringProperty(propfqn, storedValue);
        } else if (def.getType() instanceof PropertyTypeInteger) {
            this.updateWidgetIntegerProperty(propfqn, storedValue);
        } else if (def.getType() instanceof PropertyTypeSelection) {
            this.updateWidgetSelectionProperty(propfqn, storedValue);
        }
    }

    void updateWidgetBooleanProperty(String propfqn, Object storedValue) {
        Boolean v;
        Button w = (Button)this.controlmap.get(propfqn);
        IPropertyDefinition def = PropertyUtil.getDefinition(this.pdm, propfqn);
        IPropertyTypeBoolean t = (IPropertyTypeBoolean)def.getType();
        Boolean bl = v = storedValue != null ? (Boolean)storedValue : this.pm.getBooleanUnsafe(propfqn);
        if (v == null && (v = t.getDefault()) == null) {
            return;
        }
        w.setSelection(v.booleanValue());
    }

    void updateWidgetStringProperty(String propfqn, Object storedValue) {
        String v;
        Text w = (Text)this.controlmap.get(propfqn);
        IPropertyDefinition def = PropertyUtil.getDefinition(this.pdm, propfqn);
        IPropertyTypeString t = (IPropertyTypeString)def.getType();
        String string = v = storedValue != null ? (String)storedValue : this.pm.getStringUnsafe(propfqn);
        if (v == null && (v = t.getDefault()) == null) {
            return;
        }
        w.setText(v);
    }

    void updateWidgetIntegerProperty(String propfqn, Object storedValue) {
        Integer v;
        Text w = (Text)this.controlmap.get(propfqn);
        IPropertyDefinition def = PropertyUtil.getDefinition(this.pdm, propfqn);
        IPropertyTypeInteger t = (IPropertyTypeInteger)def.getType();
        Integer n = v = storedValue != null ? (Integer)storedValue : this.pm.getIntegerUnsafe(propfqn);
        if (v == null && (v = t.getDefault()) == null) {
            return;
        }
        w.setText(Integer.toString(v));
    }

    void updateWidgetSelectionProperty(String propfqn, Object storedValue) {
        Integer v;
        Combo w = (Combo)this.controlmap.get(propfqn);
        IPropertyDefinition def = PropertyUtil.getDefinition(this.pdm, propfqn);
        PropertyTypeSelection t = (PropertyTypeSelection)def.getType();
        Integer n = v = storedValue != null ? (Integer)storedValue : this.pm.getIntegerUnsafe(propfqn);
        if (v == null && (v = t.getDefault()) == null) {
            return;
        }
        int i = 0;
        for (PropertyTypeSelection.E e : t.getEntries()) {
            if (Integer.valueOf(e.getId()).equals(v)) {
                w.select(i);
                break;
            }
            ++i;
        }
    }

    private void setModifiedFlag(Control ctl, boolean modified) {
        if (this.globalDisableModFlagRecording) {
            return;
        }
        ctl.setData(flagModified, (Object)modified);
    }

    private boolean hasModifiedFlag(Control ctl) {
        return Boolean.TRUE.equals(ctl.getData(flagModified));
    }

    private void resetModifiedFlag() {
        for (Control ctl : this.controlmap.values()) {
            ctl.setData(flagModified, (Object)false);
        }
    }

    public PropertyChangeObject retrieveChanges(PropertyChangeObject co) {
        if (co == null) {
            co = new PropertyChangeObject();
        }
        for (Control ctl : this.controlmap.values()) {
            if (!this.hasModifiedFlag(ctl)) continue;
            IPropertyType proptype = (IPropertyType)ctl.getData(flagPropertyType);
            String propfqn = (String)ctl.getData(flagPropertyFQN);
            boolean r = true;
            if (proptype instanceof IPropertyTypeBoolean) {
                boolean selected = ((Button)ctl).getSelection();
                r = this.pm.setBoolean(propfqn, selected, co);
            } else if (proptype instanceof IPropertyTypeInteger) {
                if (proptype instanceof PropertyTypeSelection) {
                    try {
                        int index = ((Combo)ctl).getSelectionIndex();
                        PropertyTypeSelection.E e = (PropertyTypeSelection.E)((Combo)ctl).getData("sel_" + index);
                        int id = e.getId();
                        r = this.pm.setInteger(propfqn, id, co);
                    }
                    catch (NumberFormatException e) {
                        logger.catching(e);
                    }
                } else {
                    try {
                        int val = Integer.parseInt(((Text)ctl).getText());
                        r = this.pm.setInteger(propfqn, val, co);
                    }
                    catch (NumberFormatException e) {
                        logger.catching(e);
                    }
                }
            } else if (proptype instanceof IPropertyTypeString) {
                String text = ((Text)ctl).getText();
                r = this.pm.setString(propfqn, text, co);
            }
            if (r) continue;
            UI.warn("Illegal value for property: " + propfqn);
        }
        return co;
    }
}

