/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.OverridesView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OverridesDialog
extends JebDialog {
    public static final int RETCODE_OKAY = 0;
    public static final int RETCODE_OPEN_LEGACY_DIALOG = 1;
    IRcpClientContext context;
    OverridesView v;
    IInteractiveUnit sourceUnit;
    ITextDocument sourceDoc;
    long sourceItemId;
    String sourceAddress;
    int retcode = 0;

    public OverridesDialog(Shell parent, IRcpClientContext context) {
        super(parent, "Overrides", true, false);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.context = context;
    }

    @Override
    public Integer open() {
        super.open();
        return this.retcode;
    }

    public void setSource(IInteractiveUnit sourceUnit, ITextDocument sourceDoc, long sourceItemId, String sourceAddress) {
        this.sourceUnit = sourceUnit;
        this.sourceDoc = sourceDoc;
        this.sourceItemId = sourceItemId;
        this.sourceAddress = sourceAddress;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        this.v = new OverridesView(parent, (RcpClientContext)this.context);
        this.v.setLayoutData(UIUtil.createGridDataFill(true, true));
        this.v.setSource(this.sourceUnit, this.sourceDoc, this.sourceItemId, this.sourceAddress);
        this.createButtons(parent, new int[]{256, 0x10000000, 0x30000000}, 0);
        this.v.setFocus();
        if (OverridesDialog.getStandardWidgetManager() != null) {
            OverridesDialog.getStandardWidgetManager().wrapWidget((Control)this.v, ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "&Legacy Dialog ...";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 256) {
            this.shell.close();
        } else if (buttonId == 0x30000000) {
            this.retcode = 1;
            this.shell.close();
        } else if (buttonId == 0x10000000) {
            String msg = "Overrides.\n";
            UI.info(this.shell, "Help", msg);
        }
    }
}

