/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientProperties;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsChanges;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsSimpleViewDevelopment;
import com.pnfsoftware.jeb.rcpclient.dialogs.options.OptionsSimpleViewGeneral;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabFolderView;
import com.pnfsoftware.jeb.rcpclient.util.BrowserUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OptionsDialog
extends JebDialog {
    private static final String GENERAL = S.s(361);
    private static final String DEV = S.s(271);
    public static final String CLIENT = "Client";
    public static final String ENGINES = "Engines";
    public static final String PROJECT_SPECIFIC = "Project-specific";
    private static final String[] advancedTabs = new String[]{"Client", "Engines", "Project-specific"};
    private static final String[] simpleTabs = new String[]{GENERAL, DEV};
    private RcpClientProperties clientProperties;
    private IPropertyManager clientPM;
    private IPropertyManager corePM;
    private IPropertyManager prjPM;
    private boolean blockModeChange;
    private boolean lazyInit;
    private boolean expandOnFiltering;
    private OptionsChanges changes = new OptionsChanges();
    private boolean advancedOptions = false;
    private boolean saveChanges = false;
    private TabFolderView tabman;

    public OptionsDialog(Shell parent, RcpClientProperties clientProperties, IPropertyManager clientPM, IPropertyManager corePM, IPropertyManager prjPM) {
        super(parent, S.s(616), true, true);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.clientProperties = clientProperties;
        if (clientPM == null && corePM == null && prjPM == null) {
            throw new IllegalArgumentException("Please provide at least one property manager.");
        }
        this.clientPM = clientPM;
        this.corePM = corePM;
        this.prjPM = prjPM;
        boolean advanced = false;
        if (clientProperties != null) {
            advanced = clientProperties.getOptionsDialogAdvancedMode();
        }
        if (clientPM == null || corePM == null) {
            advanced = true;
            this.blockModeChange = true;
        }
        this.setMode(advanced);
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setExpandOnFiltering(boolean expandOnFiltering) {
        this.expandOnFiltering = expandOnFiltering;
    }

    public boolean isExpandOnFiltering() {
        return this.expandOnFiltering;
    }

    @Override
    public Boolean open() {
        super.open();
        if (!this.saveChanges) {
            return false;
        }
        OptionsChanges.Changes engChanges = this.changes.get(ENGINES);
        if (engChanges == null) {
            return false;
        }
        return engChanges.hasChanges();
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 4);
        this.shell.setMinimumSize(600, 500);
        this.tabman = new TabFolderView(parent, 2048, true, this.lazyInit);
        this.tabman.setLayoutData(UIUtil.createGridDataSpanHorizontally(4, true, true));
        CTabFolder folder = this.tabman.getContainer();
        if (this.clientPM != null) {
            this.changes.addPropertyManager(CLIENT, this.clientPM);
        }
        if (this.corePM != null) {
            this.changes.addPropertyManager(ENGINES, this.corePM);
        }
        if (this.prjPM != null) {
            this.changes.addPropertyManager(PROJECT_SPECIFIC, this.prjPM);
        }
        if (this.clientPM != null && this.corePM != null) {
            this.tabman.addEntry(GENERAL, (Control)new OptionsSimpleViewGeneral((Composite)folder, this.changes), !this.advancedOptions);
            this.tabman.addEntry(DEV, (Control)new OptionsSimpleViewDevelopment((Composite)folder, this.changes), !this.advancedOptions);
        }
        this.createButtons(parent, 288, 32);
        Button btnHelp = UIUtil.createPushbox(parent, S.s(365), e -> BrowserUtil.openInBrowser("https://www.pnfsoftware.com/jeb/manual"));
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        btnHelp.setLayoutData((Object)data);
        for (TabFolderView.Entry e2 : this.tabman.getEntries()) {
            if (!e2.hasTab()) continue;
            this.tabman.showEntry(e2, true);
            break;
        }
    }

    @Override
    protected void onButtonClick(int style) {
        if (style == -5) {
            this.setMode(!this.advancedOptions);
        } else {
            super.onButtonClick(style);
        }
    }

    @Override
    protected void onConfirm() {
        this.changes.saveAllChanges(null);
        this.saveChanges = true;
        super.onConfirm();
    }

    private void setMode(boolean advancedOptions) {
        if (advancedOptions == this.advancedOptions) {
            return;
        }
        if (this.tabman != null) {
            if (advancedOptions) {
                for (String e : advancedTabs) {
                    this.tabman.showEntry(e, e.equals(CLIENT));
                }
                for (String e : simpleTabs) {
                    this.tabman.hideEntry(e);
                }
                this.tabman.hideEntry(GENERAL);
            } else {
                for (String e : advancedTabs) {
                    this.tabman.hideEntry(e);
                }
                for (String e : simpleTabs) {
                    this.tabman.showEntry(e, e.equals(GENERAL));
                }
            }
        }
        this.updateButtonText(advancedOptions);
        this.advancedOptions = advancedOptions;
        if (this.clientProperties != null) {
            this.clientProperties.setOptionsDialogAdvancedMode(advancedOptions);
        }
    }

    private void updateButtonText(boolean advancedOptions) {
        Button b = this.getButtonByStyle(-5);
        if (b != null) {
            b.setText(advancedOptions ? "<< " + S.s(614) : S.s(613) + " >>");
            b.getParent().getParent().pack();
        }
    }
}

