/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.IUnitNotification;
import com.pnfsoftware.jeb.core.units.NotificationType;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class NotificationSelectorDialog
extends DataFrameDialog {
    RcpClientContext context;
    List<Notification> entries;
    private int selectedIndex = -1;

    public NotificationSelectorDialog(Shell parent, RcpClientContext context) {
        super(parent, S.s(602), false, null);
        this.context = context;
    }

    @Override
    public Integer open() {
        this.reload();
        String msg = Strings.ff("Project Notifications:", new Object[0]);
        this.setMessage(msg);
        this.selectedIndex = super.open();
        return this.selectedIndex;
    }

    public Notification getSelectedEntry() {
        if (!this.shell.isDisposed()) {
            throw new IllegalStateException("Shell be called only after the dialog was closed");
        }
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return this.entries.get(this.selectedIndex);
    }

    @Override
    protected void createButtons(Composite parent) {
        this.createButtons(parent, new int[]{32, 256, 0x30000000, 0x40000000}, 32);
        this.hideButton(32);
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 256) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Navigate";
        }
        if (btnId == 0x40000000) {
            return "Refresh";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.nav();
            super.onButtonClick(buttonId);
        } else if (buttonId == 0x30000000) {
            this.nav();
        } else if (buttonId == 0x40000000) {
            this.reload();
            this.refresh();
        } else {
            super.onButtonClick(buttonId);
        }
    }

    private boolean nav() {
        int index = this.getSelectedRow();
        if (index < 0 || index >= this.entries.size()) {
            return false;
        }
        return this.nav(this.entries.get(index));
    }

    private boolean nav(Notification e) {
        return GraphicalActionExecutor.gotoAddress(this.context, e.unit, e.notification.getAddress());
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame(S.s(785), S.s(779), S.s(268), S.s(52), S.s(424), S.s(203));
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        this.entries = this.getEntries();
        for (Notification n : this.entries) {
            String path = UnitUtil.buildFullyQualifiedUnitPath(n.unit);
            try {
                NotificationType type = n.notification.getType();
                String desc = n.notification.getDescription();
                String addr = null;
                String label = null;
                String comment = null;
                try {
                    addr = n.notification.getAddress();
                    if (n.unit instanceof IAddressableUnit) {
                        label = ((IAddressableUnit)n.unit).getAddressLabel(addr);
                    }
                    if (n.unit instanceof IInteractiveUnit) {
                        comment = ((IInteractiveUnit)n.unit).getInlineComment(addr);
                    }
                }
                catch (Exception ex) {
                    this.context.getErrorHandler().processThrowableSilent(ex);
                }
                df.addRow(new Object[]{path, type, desc, addr, label, comment});
            }
            catch (Exception ex) {
                this.context.getErrorHandler().processThrowableSilent(ex);
            }
        }
    }

    List<Notification> getEntries() {
        IRuntimeProject prj = this.context.getOpenedProject();
        if (prj == null) {
            return Collections.emptyList();
        }
        ArrayList<Notification> entries = new ArrayList<Notification>();
        for (IUnit unit : RuntimeProjectUtil.getAllUnits(prj)) {
            for (IUnitNotification n : unit.getNotificationManager().getNotifications()) {
                entries.add(new Notification(unit, n));
            }
        }
        return entries;
    }

    public static class Notification {
        public IUnit unit;
        public IUnitNotification notification;

        public Notification(IUnit unit, IUnitNotification notification) {
            this.unit = unit;
            this.notification = notification;
        }
    }
}

