/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryEntry;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.type.TypeLibraryService;
import com.pnfsoftware.jeb.rcpclient.IGraphicalTaskExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCheckStateProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ListTypelibsDialog
extends JebDialog {
    private IGraphicalTaskExecutor executor;
    private TypeLibraryService tls;
    private FilteredTableViewer ftv;

    public ListTypelibsDialog(Shell parent, IGraphicalTaskExecutor executor) {
        super(parent, "Type libraries", true, true, "typelibsDialog");
        this.setVisualBounds(-1, 90, -1, -1);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.executor = executor;
    }

    public void setInput(TypeLibraryService tls) {
        this.tls = tls;
    }

    @Override
    public Object open() {
        return super.open();
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        FilteredTableView ft = new FilteredTableView(parent, 32, new String[]{"Loaded", "Targets", "Group", S.s(591), S.s(268), S.s(86), S.s(341)});
        GridData data = UIUtil.createGridDataFill(true, true);
        data.minimumHeight = 200;
        ft.setLayoutData(data);
        this.ftv = new FilteredTableViewer(ft);
        ContentProviderListener p = new ContentProviderListener();
        this.ftv.setContentProvider(p);
        this.ftv.setCheckStateProvider(new DefaultCheckStateProvider(p));
        this.ftv.setLabelProvider(new LabelProvider());
        ft.addTableEventListener(p);
        this.ftv.setInput(this.tls);
        this.createOkayButton(parent);
        if (ListTypelibsDialog.getStandardWidgetManager() != null) {
            ListTypelibsDialog.getStandardWidgetManager().wrapWidget((Control)ft, "listTypelibs");
        }
    }

    class ContentProviderListener
    implements ITableEventListener,
    IFilteredTableContentProvider {
        private TypeLibraryService tls0;

        ContentProviderListener() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.tls0 = (TypeLibraryService)newInput;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            List<TypeLibraryEntry> r = this.tls0.getAvailables();
            Object[] a = r.toArray(new TypeLibraryEntry[r.size()]);
            Arrays.sort(a);
            return a;
        }

        @Override
        public boolean isChecked(Object row) {
            if (row instanceof TypeLibraryEntry) {
                TypeLibraryEntry e = (TypeLibraryEntry)row;
                return e.getTypelib() != null;
            }
            return false;
        }

        @Override
        public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
            if (row instanceof TypeLibraryEntry) {
                boolean r;
                boolean isLoaded;
                TypeLibraryEntry e = (TypeLibraryEntry)row;
                boolean bl = isLoaded = e.getTypelib() != null;
                if (isChecked && !isLoaded) {
                    if (ListTypelibsDialog.this.executor == null) {
                        this.tls0.load(e);
                    } else {
                        ListTypelibsDialog.this.executor.executeTask("Loading type library...", () -> this.tls0.load(e));
                    }
                } else if (!isChecked && isLoaded && !(r = this.tls0.unload(e))) {
                    UI.error("Unloading failed");
                }
                ListTypelibsDialog.this.ftv.refresh();
            }
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 7;
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof TypeLibraryEntry) {
                TypeLibraryEntry e = (TypeLibraryEntry)element;
                TypeLibraryMetadata hdr = e.getMetadataHeader();
                switch (key) {
                    case 0: {
                        return e.getTypelib() != null ? S.s(828) : S.s(594);
                    }
                    case 1: {
                        return Strings.join(", ", hdr.getProcessorTypes());
                    }
                    case 2: {
                        int groupId = hdr.getGroupId();
                        return TypeLibraryService.groupIdToName(groupId);
                    }
                    case 3: {
                        return hdr.getName();
                    }
                    case 4: {
                        return hdr.getDescription();
                    }
                    case 5: {
                        return hdr.getAuthor();
                    }
                    case 6: {
                        return e.getFile().getPath();
                    }
                }
            }
            return null;
        }
    }
}

