/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.CodelessLibraryID;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.CodelessLibraryVersion;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.CodelessSignatureManager;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.CodelessSignaturePackageEntry;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.ExecutableModelMetadata;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.LibraryIdentificationResults;
import com.pnfsoftware.jeb.core.units.code.asm.sig.codeless.MatchingState;
import com.pnfsoftware.jeb.rcpclient.IGraphicalTaskExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.dialogs.TextDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCheckStateProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ListMatchedCodelessSigDialog
extends JebDialog {
    private IGraphicalTaskExecutor executor;
    private FilteredTableViewer ftv;
    private CodelessSignatureManager manager;
    private INativeCodeUnit<IInstruction> matchableUnit;

    public ListMatchedCodelessSigDialog(Shell parent, IGraphicalTaskExecutor executor) {
        super(parent, "Codeless signature libraries", true, true, "matchedCodelessSigsDialog");
        this.setVisualBounds(-1, 90, -1, -1);
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        this.executor = executor;
    }

    public void setInput(CodelessSignatureManager manager) {
        this.manager = manager;
        this.matchableUnit = this.getMatchableUnit();
    }

    private INativeCodeUnit<IInstruction> getMatchableUnit() {
        INativeCodeUnit<IInstruction> matchableUnit = this.manager.getMatchableUnit();
        if (matchableUnit == null || !matchableUnit.isProcessed()) {
            return null;
        }
        return matchableUnit;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        FilteredTableView ft = new FilteredTableView(parent, 32, new String[]{"Matched", "Library", S.s(818), S.s(341)});
        GridData data = UIUtil.createGridDataFill(true, true);
        data.minimumHeight = 200;
        ft.setLayoutData(data);
        this.ftv = new FilteredTableViewer(ft);
        ContentProviderListener p = new ContentProviderListener(this.matchableUnit);
        this.ftv.setContentProvider(p);
        this.ftv.setCheckStateProvider(new DefaultCheckStateProvider(p));
        this.ftv.setLabelProvider(new LabelProvider(this.manager, this.matchableUnit));
        ft.addTableEventListener(p);
        this.ftv.setInput(this.manager);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2));
        this.createOkayButton(buttons);
        UIUtil.createPushbox(buttons, "Automatic library identification", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                final StringBuilder result = new StringBuilder();
                ListMatchedCodelessSigDialog.this.executor.executeTask(Strings.ff("Identifying statically-linked libraries...", new Object[0]), new Runnable(){

                    @Override
                    public void run() {
                        if (ListMatchedCodelessSigDialog.this.matchableUnit == null) {
                            UI.error("No suitable code unit was found.");
                            return;
                        }
                        LibraryIdentificationResults results = ListMatchedCodelessSigDialog.this.manager.identifyLibraries(ListMatchedCodelessSigDialog.this.matchableUnit);
                        if (results == null) {
                            UI.error("Identification failed!");
                            return;
                        }
                        Map<CodelessSignaturePackageEntry, Long> hitsMap = results.getHitsMap();
                        if (hitsMap == null || hitsMap.isEmpty()) {
                            result.append("No known libraries were identified");
                        } else {
                            CodelessLibraryID libId;
                            HashMap bestResults = new HashMap();
                            for (Map.Entry<CodelessSignaturePackageEntry, Long> entry : results.getHitsMap().entrySet()) {
                                libId = entry.getKey().getMetadata().getLibraryId();
                                CodelessLibraryVersion libVer = entry.getKey().getMetadata().getLibraryVersion();
                                long hits = entry.getValue();
                                if (hits == 0L) continue;
                                Couple curResult = (Couple)bestResults.get((Object)libId);
                                if (curResult == null || (Long)curResult.getSecond() < hits) {
                                    ArrayList<CodelessLibraryVersion> versions = new ArrayList<CodelessLibraryVersion>();
                                    versions.add(libVer);
                                    bestResults.put(libId, new Couple(versions, hits));
                                    continue;
                                }
                                if ((Long)curResult.getSecond() != hits) continue;
                                ((List)curResult.getFirst()).add(libVer);
                            }
                            for (Map.Entry<CodelessSignaturePackageEntry, Long> entry : bestResults.entrySet()) {
                                libId = (CodelessLibraryID)((Object)entry.getKey());
                                List libVersions = (List)((Couple)((Object)entry.getValue())).getFirst();
                                result.append(Strings.ff("%s found!", new Object[]{libId}));
                                result.append(Strings.LINESEP);
                                result.append(Strings.ff(" -> possible version(s): %s", libVersions));
                                result.append(Strings.LINESEP);
                                result.append(Strings.LINESEP);
                            }
                        }
                    }
                });
                ListMatchedCodelessSigDialog.this.displayText("Identified Libraries", result.toString(), false);
            }
        });
        if (ListMatchedCodelessSigDialog.getStandardWidgetManager() != null) {
            ListMatchedCodelessSigDialog.getStandardWidgetManager().wrapWidget((Control)ft, "listCodelessSigs");
        }
    }

    private String displayText(String caption, String text, boolean editable) {
        String[] lines;
        int maxcolcnt = 0;
        for (String line : lines = Strings.splitLines(text)) {
            if (line.length() <= maxcolcnt) continue;
            maxcolcnt = line.length();
        }
        int rowcnt = Math.min(Math.max(10, lines.length), 40);
        int colcnt = Math.min(Math.max(40, maxcolcnt), 80);
        TextDialog dlg = new TextDialog(this.getShell(), caption, text, null);
        dlg.setEditable(editable);
        dlg.setColumnCount(colcnt);
        dlg.setLineCount(rowcnt);
        return dlg.open();
    }

    class ContentProviderListener
    implements ITableEventListener,
    IFilteredTableContentProvider {
        private CodelessSignatureManager manager0;
        private INativeCodeUnit<IInstruction> matchableUnit0;

        public ContentProviderListener(INativeCodeUnit<IInstruction> matchableUnit) {
            this.matchableUnit0 = matchableUnit;
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.manager0 = (CodelessSignatureManager)newInput;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return this.manager0.getAvailablePackages().toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            if (row instanceof CodelessSignaturePackageEntry) {
                if (this.matchableUnit0 == null) {
                    return false;
                }
                CodelessSignaturePackageEntry e = (CodelessSignaturePackageEntry)row;
                return this.manager0.isMatched(this.matchableUnit0, e);
            }
            return false;
        }

        @Override
        public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
            if (row instanceof CodelessSignaturePackageEntry) {
                final CodelessSignaturePackageEntry e = (CodelessSignaturePackageEntry)row;
                if (this.matchableUnit0 == null) {
                    UI.error("No suitable code unit was found.");
                    ListMatchedCodelessSigDialog.this.ftv.refresh();
                    return;
                }
                boolean isMatched = this.manager0.isMatched(this.matchableUnit0, e);
                if (isChecked && !isMatched) {
                    ExecutableModelMetadata metadata = e.getMetadata();
                    final StringBuilder result = new StringBuilder();
                    ListMatchedCodelessSigDialog.this.executor.executeTask(Strings.ff("Matching %s %s...", metadata.getLibraryId().getName(), metadata.getLibraryVersion().getStringVersion()), new Runnable(){

                        @Override
                        public void run() {
                            MatchingState finalState = ContentProviderListener.this.manager0.match(ContentProviderListener.this.matchableUnit0, e);
                            if (finalState == null) {
                                UI.error("No match results were generated.");
                                return;
                            }
                            if (!ContentProviderListener.this.manager0.importState(ContentProviderListener.this.matchableUnit0, finalState)) {
                                UI.error("Results could not be imported.");
                                return;
                            }
                            result.append(finalState.getResultLog());
                        }
                    });
                    ListMatchedCodelessSigDialog.this.displayText("Matching Results", result.length() != 0 ? result.toString() : "None", false);
                } else if (!isChecked && isMatched) {
                    UI.error("Codeless signature libraries cannot be unloaded.");
                }
                ListMatchedCodelessSigDialog.this.ftv.refresh();
            }
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        private CodelessSignatureManager manager;
        private INativeCodeUnit<IInstruction> matchableUnit;

        public LabelProvider(CodelessSignatureManager manager, INativeCodeUnit<IInstruction> matchableUnit) {
            this.manager = manager;
            this.matchableUnit = matchableUnit;
        }

        @Override
        public int getColumns(Object row) {
            return 4;
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof CodelessSignaturePackageEntry) {
                CodelessSignaturePackageEntry e = (CodelessSignaturePackageEntry)element;
                ExecutableModelMetadata metadata = e.getMetadata();
                switch (key) {
                    case 0: {
                        return this.matchableUnit != null && this.manager.isMatched(this.matchableUnit, e) ? S.s(828) : S.s(594);
                    }
                    case 1: {
                        return metadata.getLibraryId().getName();
                    }
                    case 2: {
                        return metadata.getLibraryVersion().getStringVersion();
                    }
                    case 3: {
                        return e.getFile().getPath();
                    }
                }
            }
            return null;
        }
    }
}

