/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.IPlugin;
import com.pnfsoftware.jeb.core.IPluginFileEntry;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.android.ir.IDOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.IERoutineContext;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ast.opt.ICOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.ir.opt.IEOptimizer;
import com.pnfsoftware.jeb.core.units.code.asm.decompiler.opt.IOptimizer;
import com.pnfsoftware.jeb.core.units.code.java.IJOptimizer;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCheckStateProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class ListDecompPluginsDialog
extends JebDialog {
    IEnginesContext engctx;
    boolean isDexdec;
    IDecompilerUnit decomp;
    IPropertyManager pm;

    public ListDecompPluginsDialog(Shell parent, IEnginesContext engctx, boolean isDexdec, IDecompilerUnit decomp) {
        super(parent, ListDecompPluginsDialog.genCaption(decomp, isDexdec), true, false, "decompPluginsDialog");
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        if (engctx == null) {
            throw new IllegalArgumentException("Needs an engctx");
        }
        if (isDexdec && decomp != null && !(decomp instanceof IDexDecompilerUnit)) {
            throw new IllegalArgumentException();
        }
        this.engctx = engctx;
        this.isDexdec = isDexdec;
        this.decomp = decomp;
        this.pm = decomp != null ? decomp.getPropertyManager() : engctx.getPropertyManager();
    }

    private static String genCaption(IUnit decomp, boolean isDexdec) {
        String base = Strings.ff("%s external plugins", isDexdec ? "dexdec" : "gendec");
        if (decomp != null) {
            return base + " (" + UnitUtil.buildFullyQualifiedUnitPath(decomp) + ")";
        }
        return base;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        if (!this.engctx.getPropertyManager().getBoolean("LoadPythonPlugins")) {
            UIUtil.createLabel(parent, "/!\\ Python script plugins are disabled in your options. You must enable this option to allow the back-end to load such plugins.");
        }
        FilteredTableView ft = new FilteredTableView(parent, 32, new String[]{S.s(779), S.s(591), S.s(268), S.s(818), S.s(86), S.s(341)});
        ft.setLayoutData(UIUtil.createGridDataFill(true, true));
        FilteredTableViewer ftv = new FilteredTableViewer(ft);
        ContentProviderListener p = new ContentProviderListener();
        ftv.setContentProvider(p);
        ftv.setCheckStateProvider(new DefaultCheckStateProvider(p));
        ftv.setLabelProvider(new LabelProvider());
        ft.addTableEventListener(p);
        ftv.setInput(this.engctx);
        this.createButtons(parent, new int[]{32}, 32);
        if (ListDecompPluginsDialog.getStandardWidgetManager() != null) {
            ListDecompPluginsDialog.getStandardWidgetManager().wrapWidget((Control)ft, "listDecompPlugins");
        }
    }

    @Override
    protected String getButtonText(int btnId, String defaultBtnText) {
        if (btnId == 32) {
            return "Close";
        }
        if (btnId == 0x30000000) {
            return "Edit...";
        }
        return super.getButtonText(btnId, defaultBtnText);
    }

    @Override
    protected void onButtonClick(int buttonId) {
        if (buttonId != 0x30000000) {
            super.onButtonClick(buttonId);
        }
    }

    private String getPropNameBase() {
        if (this.isDexdec) {
            return ".parsers.dcmp_dex.";
        }
        return ".parsers.native.decomp.";
    }

    class ContentProviderListener
    implements ITableEventListener,
    IFilteredTableContentProvider {
        Collection<String> disabled;

        ContentProviderListener() {
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            String s = ListDecompPluginsDialog.this.pm.getString(ListDecompPluginsDialog.this.getPropNameBase() + "ListOfDisabledExternalPlugins");
            this.disabled = DecompilerHelper.parsePluginNamesListProperty(s);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IEnginesContext) {
                IEnginesContext cfr_ignored_0 = (IEnginesContext)inputElement;
                RcpClientContext client = null;
                final ArrayList<IPluginFileEntry<IPlugin>> plugins = new ArrayList<IPluginFileEntry<IPlugin>>();
                if (client == null) {
                    this.retrievePlugins(plugins);
                } else {
                    client.executeTask("Retrieving plugins...", false, new Runnable(){

                        @Override
                        public void run() {
                            ContentProviderListener.this.retrievePlugins(plugins);
                        }
                    });
                }
                return plugins.toArray();
            }
            return ArrayUtil.NO_OBJECT;
        }

        private List<IPluginFileEntry<IPlugin>> retrievePlugins(List<IPluginFileEntry<IPlugin>> plugins) {
            if (ListDecompPluginsDialog.this.isDexdec) {
                List<IPluginFileEntry<IPlugin>> r = ListDecompPluginsDialog.this.engctx.getPluginManager().getPluginEntries(IDOptimizer.class);
                plugins.addAll(r);
                r = ListDecompPluginsDialog.this.engctx.getPluginManager().getPluginEntries(IJOptimizer.class);
                plugins.addAll(r);
            } else {
                List<IPluginFileEntry<IOptimizer<IERoutineContext>>> r = ListDecompPluginsDialog.this.engctx.getPluginManager().getPluginEntries(IEOptimizer.class);
                plugins.addAll(r);
                r = ListDecompPluginsDialog.this.engctx.getPluginManager().getPluginEntries(ICOptimizer.class);
                plugins.addAll(r);
            }
            return plugins;
        }

        @Override
        public boolean isChecked(Object row) {
            if (row instanceof IPluginFileEntry) {
                Object plugin = ((IPluginFileEntry)row).getPluginObject();
                return !this.disabled.contains(plugin.getPluginInformation().getName());
            }
            return false;
        }

        @Override
        public void onTableEvent(Object row, boolean isSelected, boolean isChecked) {
            if (row instanceof IPluginFileEntry) {
                Object plugin = ((IPluginFileEntry)row).getPluginObject();
                String name = plugin.getPluginInformation().getName();
                if (isChecked) {
                    this.disabled.remove(name);
                } else {
                    this.disabled.add(name);
                }
                String s = DecompilerHelper.createPluginNamesListProperty(this.disabled);
                ListDecompPluginsDialog.this.pm.setString(ListDecompPluginsDialog.this.getPropNameBase() + "ListOfDisabledExternalPlugins", s);
            }
        }
    }

    static class LabelProvider
    extends DefaultCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public int getColumns(Object row) {
            return 6;
        }

        @Override
        public String getStringAt(Object element, int key) {
            if (element instanceof IPluginFileEntry) {
                IPluginFileEntry e = (IPluginFileEntry)element;
                boolean script = e.isScriptPlugin();
                File file = e.getFile();
                Object p = e.getPluginObject();
                IPluginInformation pi = p.getPluginInformation();
                switch (key) {
                    case 0: {
                        if (p instanceof IDOptimizer) {
                            return "dexdec-ir";
                        }
                        if (p instanceof IJOptimizer) {
                            return "dexdec-ast";
                        }
                        if (p instanceof IEOptimizer) {
                            return "gendec-ir";
                        }
                        if (p instanceof ICOptimizer) {
                            return "gendec-ast";
                        }
                        return "?";
                    }
                    case 1: {
                        return pi == null ? p.getClass().getName() : pi.getName();
                    }
                    case 2: {
                        return pi == null ? null : pi.getDescription();
                    }
                    case 3: {
                        return pi == null ? null : pi.getAuthor();
                    }
                    case 4: {
                        return pi == null ? null : (pi.getVersion() == null ? null : pi.getVersion().toString());
                    }
                    case 5: {
                        return script && file != null ? file.getPath() : null;
                    }
                }
            }
            return null;
        }
    }
}

