/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ILine;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.properties.IPropertyManager;
import com.pnfsoftware.jeb.core.units.IAddressableUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ContentAssistedText2;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IContentDescriptionProvider;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class JumpToDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(JumpToDialog.class);
    public static final String propDisableAutoLoad = ".ui.dialogs.goto.DisableAutoLoadUnitAddresses";
    public static final String propDisableDescription = ".ui.dialogs.goto.DisableAutoGeneratedDescription";
    public static final String propCaseSensitive = ".ui.dialogs.goto.AutoCompletCaseSensitive";
    private TextHistory textHistory;
    private IUnit unit;
    private IPropertyManager pm;
    private ITextDocument doc;
    private ContentAssistedText2 cat;
    private String initialValue;
    private String input;
    private boolean acCaseSensitive;
    private boolean disableAutoGenDescription;

    public JumpToDialog(Shell parent) {
        this(parent, null, null);
    }

    public JumpToDialog(Shell parent, TextHistory textHistory) {
        this(parent, textHistory, null);
    }

    public JumpToDialog(Shell parent, TextHistory textHistory, IUnit unit) {
        this(parent, textHistory, unit, null, null);
    }

    public JumpToDialog(Shell parent, TextHistory textHistory, IUnit unit, ITextDocument doc, IPropertyManager pm) {
        super(parent, S.s(420), true, true, null);
        this.scrolledContainer = true;
        this.textHistory = textHistory;
        this.unit = unit;
        this.pm = pm;
        this.doc = doc;
    }

    public void setInitialValue(String initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public String open() {
        super.open();
        return this.input;
    }

    @Override
    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Group c0 = new Group(parent, 0);
        c0.setText("Target address");
        c0.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        c0.setLayout((Layout)new GridLayout(1, false));
        this.cat = new ContentAssistedText2((Composite)c0, 2048, null, this.textHistory, true);
        this.cat.setContentDescriptionProvider(new CPDescriptionProvider());
        this.cat.setLayoutData(UIUtil.createGridDataFillHorizontally());
        if (this.initialValue != null) {
            this.cat.getWidget().setText(this.initialValue);
            this.cat.getWidget().selectAll();
        }
        UIUtil.disableTabOutput((Control)this.cat);
        final Button btn_case = new Button((Composite)c0, 32);
        btn_case.setText("Case sens&itive");
        if (this.pm == null) {
            btn_case.setEnabled(false);
        } else {
            btn_case.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JumpToDialog.this.acCaseSensitive = btn_case.getSelection();
                    JumpToDialog.this.pm.setBoolean(JumpToDialog.propCaseSensitive, JumpToDialog.this.acCaseSensitive);
                    JumpToDialog.this.cat.setCaseSensitive(JumpToDialog.this.acCaseSensitive);
                }
            });
            this.acCaseSensitive = this.pm.getBoolean(propCaseSensitive);
            btn_case.setSelection(this.acCaseSensitive);
            this.cat.setCaseSensitive(this.acCaseSensitive);
        }
        Group c1 = new Group(parent, 0);
        c1.setText("Options");
        c1.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        c1.setLayout((Layout)new GridLayout(1, false));
        final Button btn = new Button((Composite)c1, 32);
        btn.setText("Do not preload &well-known addresses");
        if (this.pm == null) {
            btn.setEnabled(false);
            this.loadExtras();
        } else {
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean disabled = btn.getSelection();
                    JumpToDialog.this.pm.setBoolean(JumpToDialog.propDisableAutoLoad, disabled);
                    if (disabled) {
                        JumpToDialog.this.cat.setExtras(null);
                    } else {
                        JumpToDialog.this.loadExtras();
                    }
                }
            });
            if (this.pm.getBoolean(propDisableAutoLoad)) {
                btn.setSelection(true);
            } else {
                this.loadExtras();
            }
        }
        final Button btn2 = new Button((Composite)c1, 32);
        btn2.setText("Do not generate &description snippets");
        if (this.pm == null) {
            btn2.setEnabled(false);
        } else {
            btn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    JumpToDialog.this.disableAutoGenDescription = btn2.getSelection();
                    JumpToDialog.this.pm.setBoolean(JumpToDialog.propDisableDescription, JumpToDialog.this.disableAutoGenDescription);
                }
            });
            this.disableAutoGenDescription = this.pm.getBoolean(propDisableDescription);
            btn2.setSelection(this.disableAutoGenDescription);
        }
        Button btn3 = UIUtil.createPushbox((Composite)c1, "Clear History", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JumpToDialog.this.textHistory != null) {
                    if (JumpToDialog.this.textHistory.size() > 0) {
                        JumpToDialog.this.textHistory.clear();
                        UI.info("The history was cleared");
                    }
                    JumpToDialog.this.cat.setHistory(JumpToDialog.this.textHistory);
                }
            }
        });
        if (this.textHistory == null) {
            btn3.setEnabled(false);
        }
        this.createOkayCancelButtons(parent);
    }

    private void loadExtras() {
        if (this.unit instanceof IAddressableUnit) {
            this.cat.setExtras(((IAddressableUnit)this.unit).getWellKnownAddresses(-1, null));
        }
    }

    @Override
    protected void onConfirm() {
        this.cat.confirm();
        this.input = this.cat.getText();
        super.onConfirm();
    }

    class CPDescriptionProvider
    implements IContentDescriptionProvider {
        CPDescriptionProvider() {
        }

        @Override
        public String generate(String content) {
            block9: {
                if (JumpToDialog.this.disableAutoGenDescription) {
                    return null;
                }
                if (JumpToDialog.this.unit == null || content == null) {
                    return null;
                }
                if (JumpToDialog.this.doc == null) {
                    return null;
                }
                try {
                    String addr = content;
                    ICoordinates coord = JumpToDialog.this.doc.addressToCoordinates(addr);
                    if (coord == null) {
                        return null;
                    }
                    ITextDocumentPart part = JumpToDialog.this.doc.getDocumentPart(coord.getAnchorId(), 100, 0);
                    if (part == null) {
                        return null;
                    }
                    int index = TextPartUtil.coordinatesToLineIndex(part, coord);
                    if (index >= 0 && index < part.getLines().size()) {
                        int i = 0;
                        StringBuilder sb = new StringBuilder();
                        for (ILine iLine : part.getLines().subList(index, part.getLines().size())) {
                            if (i >= 100) break;
                            sb.append(iLine.getText());
                            sb.append(Strings.LINESEP);
                            ++i;
                        }
                        return sb.toString();
                    }
                }
                catch (Exception e) {
                    if (!Licensing.isDebugBuild()) break block9;
                    logger.catching(e);
                }
            }
            return null;
        }
    }
}

