/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.core.events.JebEvent;
import com.pnfsoftware.jeb.core.events.JebEventSource;
import com.pnfsoftware.jeb.core.units.code.android.controlflow.CFG;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFGFormatter;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.DataFrameDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.collect.ReferenceCounter;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.events.Event;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JebSelfMonitorDialog
extends DataFrameDialog {
    private static final ILogger logger = GlobalLog.getLogger(JebSelfMonitorDialog.class);
    private RcpClientContext context;
    private Thread refreshThread;
    private volatile boolean done;

    public JebSelfMonitorDialog(Shell parent, RcpClientContext context) {
        super(parent, "Self-monitor", false, null);
        this.context = context;
        if (Licensing.isDebugBuild() && this.hasInstance()) {
            throw new IllegalStateException("This dialog already exists!");
        }
    }

    @Override
    public Integer open() {
        this.reload();
        int ret = super.open();
        this.done = true;
        try {
            this.refreshThread.interrupt();
            this.refreshThread.join(5000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Self-monitor dialog refresh thread is still running!", e);
        }
        return ret;
    }

    @Override
    public void createContents(Composite parent) {
        super.createContents(parent);
        this.refreshThread = ThreadUtil.start(new Runnable(){

            @Override
            public void run() {
                Display display = JebSelfMonitorDialog.this.getShell().getDisplay();
                while (!JebSelfMonitorDialog.this.done) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    UIExecutor.sync(display, new Runnable(){

                        @Override
                        public void run() {
                            if (JebSelfMonitorDialog.this.done) {
                                return;
                            }
                            JebSelfMonitorDialog.this.reload();
                            JebSelfMonitorDialog.this.refresh();
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void createButtons(Composite parent) {
    }

    private void reload() {
        DataFrame df = this.getDataFrame();
        if (df == null) {
            df = new DataFrame("Key", "Value");
            this.setDataFrame(df);
        } else {
            df.clear();
        }
        int cnt = this.readDebugAtomicInt(JebEvent.class, "ccnt");
        df.addRow("JebEvent creation count", this.f(cnt));
        cnt = this.readDebugAtomicInt(Event.class, "ccnt");
        df.addRow("Event object creation count", this.f(cnt));
        cnt = this.readDebugAtomicInt(JebEventSource.class, "onEventCallCount");
        df.addRow("JEB onEvent call count", this.f(cnt));
        cnt = this.readDebugAtomicInt(EventSource.class, "onEventCallCount");
        df.addRow("onEvent call count", this.f(cnt));
        try {
            cnt = ((Map)Class.forName("com.pnfsoftware.jeb.corei.parsers.asm.items.AbstractNativeItem").getField("currentItems").get(null)).size();
        }
        catch (Exception exception) {
            cnt = -1;
        }
        df.addRow("Native Object Count", this.f(cnt));
        cnt = CFGFormatter.cfgfwccnt.get();
        df.addRow("Native CFG formatted with chains", this.f(cnt));
        cnt = CFG.cfgfwccnt.get();
        df.addRow("Dalvik CFG formatted with chains", this.f(cnt));
        try {
            Class<?> clz = Class.forName("com.pnfsoftware.jeb.corei.parsers.dexdec.ir.emu.Sandbox");
            cnt = this.readDebugAtomicInt(clz, "s_dbgActionCount");
            df.addRow("dexdec_sb: s_dbgActionCount", this.f(cnt));
            cnt = this.readDebugAtomicInt(clz, "s_dbgActionCountReqThreadCreation");
            df.addRow("dexdec_sb: s_dbgActionCountReqThreadCreation", this.f(cnt));
            ReferenceCounter refcntmap = (ReferenceCounter)clz.getField("s_dbgActionMapReqThreadCreation").get(null);
            Map map = refcntmap.copyToMap();
            ArrayList entries = new ArrayList(map.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return -Integer.compare(o1.getValue(), o2.getValue());
                }
            });
            int reqcnt = Math.min(10, entries.size());
            for (int i = 0; i < reqcnt; ++i) {
                Map.Entry e = (Map.Entry)entries.get(i);
                df.addRow("dexdec_sb: " + (String)e.getKey(), this.f((Integer)e.getValue()));
            }
        }
        catch (Exception ex) {
            logger.catching(ex);
        }
    }

    private String f(int cnt) {
        return cnt == -1 ? "N/A" : Integer.toString(cnt);
    }

    private int readDebugAtomicInt(Class<?> cl, String fieldName) {
        try {
            return ((AtomicInteger)cl.getField(fieldName).get(null)).get();
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

