/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.IWidgetManager;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.util.SwtUtil;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public abstract class JebDialog
extends Dialog {
    private static IWidgetManager standardWidgetManager;
    private final IWidgetManager widgetManager;
    private final String widgetName;
    private int widthMinRatio;
    private int widthMaxRatio;
    private int heightMinRatio;
    private int heightMaxRatio;
    private boolean shellMoved;
    private boolean shellResized;
    protected Shell shell;
    protected boolean doNotOpenShell;
    protected boolean doNotDispatchEvents;
    protected ShellWrapper.BoundsRestorationType boundsRestorationType = ShellWrapper.BoundsRestorationType.POSITION;
    protected boolean scrolledContainer;
    protected boolean modelessSingleInstance;
    protected boolean doNotCloseOnEscape;
    static Map<Class<?>, List<JebDialog>> instances;
    public static final int idOk = 32;
    public static final int idCancel = 256;
    public static final int idYes = 64;
    public static final int idNo = 128;
    public static final int idHelp = 0x10000000;
    public static final int idApply = 0x20000000;
    public static final int idSave = 8192;
    public static final int idCustomBtn1 = 0x30000000;
    public static final int idCustomBtn2 = 0x40000000;
    public static final int idCustomBtn3 = 0x50000000;
    public static final int idCustomBtn4 = 0x60000000;
    public static final int idCustomBtn5 = 0x70000000;
    public static final int idCustomBtn6 = Integer.MIN_VALUE;
    private static final Map<Integer, Btn> defbtnmap;
    private Map<Integer, Button> buttons = new HashMap<Integer, Button>();

    public static void setStandardWidgetManager(IWidgetManager widgetManager) {
        standardWidgetManager = widgetManager;
    }

    public static IWidgetManager getStandardWidgetManager() {
        return standardWidgetManager;
    }

    public JebDialog(Shell parent, String caption, boolean resizable, boolean modal) {
        this(parent, caption, resizable, modal, null);
    }

    public JebDialog(Shell parent, String caption, boolean resizable, boolean modal, String widgetName) {
        this(parent, 0x860 | (resizable ? 16 : 0) | (modal ? 65536 : 0), caption, widgetName);
    }

    public JebDialog(Shell parent, int style, String caption, String widgetName) {
        super(JebDialog.checkShell(parent), style);
        if ((style & 0) == 0 && this.modelessSingleInstance && this.hasInstance()) {
            throw new IllegalStateException("An instance of this dialog already exists");
        }
        if (caption != null) {
            this.setText(caption);
        }
        this.widgetManager = standardWidgetManager;
        if (Strings.isBlank(widgetName)) {
            widgetName = ((Object)((Object)this)).getClass().getName();
        }
        this.widgetName = widgetName;
        this.setVisualBounds(20, 80, 20, 80);
    }

    private static Shell checkShell(Shell shell) {
        if (shell == null) {
            RcpClientContext context;
            Display d = Display.getCurrent();
            if (d != null) {
                shell = d.getActiveShell();
            }
            if (shell == null && (context = RcpClientContext.getInstance()) != null && (shell = context.getActiveShell()) == null) {
                RuntimeException e = new RuntimeException("Unexpected null shell");
                context.getErrorHandler().processThrowable(e, false, false, true, null, null, null);
            }
        }
        if (shell == null) {
            throw new RuntimeException("A shell dialog cannot be instantiated - make sure to execute UI code in the UI thread");
        }
        return shell;
    }

    public void setText(String text) {
        super.setText(text);
        if (this.shell != null) {
            this.shell.setText(super.getText());
        }
    }

    public void setBoundsRestorationType(ShellWrapper.BoundsRestorationType boundsRestorationType) {
        this.boundsRestorationType = boundsRestorationType;
    }

    public ShellWrapper.BoundsRestorationType getBoundsRestorationType() {
        return this.boundsRestorationType;
    }

    public void setVisualBounds(int widthMinRatio, int widthMaxRatio, int heightMinRatio, int heightMaxRatio) {
        if (widthMinRatio >= 0 && widthMinRatio <= 100) {
            this.widthMinRatio = widthMinRatio;
            if (this.widthMaxRatio < this.widthMinRatio) {
                this.widthMaxRatio = this.widthMinRatio;
            }
        }
        if (widthMaxRatio >= 0 && widthMaxRatio <= 100) {
            this.widthMaxRatio = widthMaxRatio;
            if (this.widthMaxRatio < this.widthMinRatio) {
                this.widthMinRatio = this.widthMaxRatio;
            }
        }
        if (heightMinRatio >= 0 && heightMinRatio <= 100) {
            this.heightMinRatio = heightMinRatio;
            if (this.heightMaxRatio < this.heightMinRatio) {
                this.heightMaxRatio = this.heightMinRatio;
            }
        }
        if (heightMaxRatio >= 0 && heightMaxRatio <= 100) {
            this.heightMaxRatio = heightMaxRatio;
            if (this.heightMaxRatio < this.heightMinRatio) {
                this.heightMinRatio = this.heightMaxRatio;
            }
        }
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public IWidgetManager getWidgetManager() {
        return this.widgetManager;
    }

    public Object open() {
        Composite ctl;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        Shell dock = UI.getDockShell();
        Rectangle superBounds = dock.getBounds();
        int wmax = this.widthMaxRatio * superBounds.width / 100;
        int wmin = this.widthMinRatio * superBounds.width / 100;
        int hmax = this.heightMaxRatio * superBounds.height / 100;
        int hmin = this.heightMinRatio * superBounds.height / 100;
        this.shell = UI.newShellPopup(parent, this.getStyle());
        this.shell.setText(this.getText());
        UIUtil.setWidgetName((Widget)this.shell, this.widgetName);
        ShellWrapper shellWrapper = ShellWrapper.wrap(this.shell, this.widgetManager);
        if (this.boundsRestorationType == null) {
            this.boundsRestorationType = ShellWrapper.BoundsRestorationType.NONE;
        }
        boolean hasRecordedBounds = shellWrapper != null && shellWrapper.hasRecordedBounds();
        ScrolledComposite sctl = null;
        this.shell.setLayout((Layout)new FillLayout());
        if (this.scrolledContainer) {
            sctl = new ScrolledComposite((Composite)this.shell, 768);
            sctl.setExpandHorizontal(true);
            sctl.setExpandVertical(true);
            ctl = new Composite((Composite)sctl, 0);
            sctl.setContent((Control)ctl);
        } else {
            ctl = new Composite((Composite)this.shell, 0);
        }
        this.createContents(ctl);
        if (this.scrolledContainer) {
            sctl.setMinSize(ctl.computeSize(-1, -1));
        }
        this.shell.pack();
        ShellWrapper.BoundsRestorationType rtype = this.boundsRestorationType;
        if (hasRecordedBounds) {
            switch (rtype) {
                case POSITION: {
                    this.shell.setLocation(shellWrapper.getRecordedPosition());
                    rtype = ShellWrapper.BoundsRestorationType.SIZE;
                    break;
                }
                case SIZE: {
                    this.shell.setSize(shellWrapper.getRecordedSize());
                    rtype = ShellWrapper.BoundsRestorationType.POSITION;
                    break;
                }
                case SIZE_AND_POSITION: {
                    this.shell.setBounds(shellWrapper.getRecordedBounds());
                    rtype = ShellWrapper.BoundsRestorationType.NONE;
                    break;
                }
                default: {
                    rtype = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
                    break;
                }
            }
        } else {
            rtype = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
        }
        if (rtype.shouldSetSize()) {
            int x;
            int y;
            boolean smallerWidth = false;
            boolean smallerHeight = false;
            Point dlgsize = this.shell.getSize();
            if (dlgsize.x > wmax) {
                dlgsize.x = wmax;
                smallerWidth = true;
            } else if (dlgsize.x < wmin) {
                dlgsize.x = wmin;
            }
            if (dlgsize.y > hmax) {
                dlgsize.y = hmax;
                smallerHeight = true;
            } else if (dlgsize.y < hmin) {
                dlgsize.y = hmin;
            }
            if (smallerWidth && !smallerHeight && (y = this.shell.computeSize((int)dlgsize.x, (int)-1).y) >= hmin && y <= hmax) {
                dlgsize.y = y;
            }
            if (!smallerWidth && smallerHeight && (x = this.shell.computeSize((int)-1, (int)dlgsize.y).x) >= wmin && x <= wmax) {
                dlgsize.x = x;
            }
            this.shell.setSize(dlgsize);
        }
        if (rtype.shouldSetPosition()) {
            Point dlgsize = this.shell.getSize();
            int x = superBounds.x + (superBounds.width - dlgsize.x) / 2;
            int y = superBounds.y + (superBounds.height - dlgsize.y) / 2;
            if (x < superBounds.x) {
                x = superBounds.x;
            }
            if (y < superBounds.y) {
                y = superBounds.y;
            }
            this.shell.setLocation(x, y);
        }
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 4) {
                    e.doit = JebDialog.this.allowKeyboardEnterExecution(e);
                } else if (e.detail == 2 && JebDialog.this.doNotCloseOnEscape) {
                    e.doit = false;
                }
            }
        });
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                JebDialog.this.shellMoved = true;
            }

            public void controlResized(ControlEvent e) {
                JebDialog.this.shellResized = true;
            }
        });
        if (shellWrapper != null) {
            shellWrapper.setFlags(false, false);
        }
        if (!this.doNotOpenShell) {
            this.shell.open();
            final JebDialog dlg = this;
            Maps.putMulti(instances, ((Object)((Object)dlg)).getClass(), dlg);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Maps.removeMulti(instances, ((Object)((Object)dlg)).getClass(), dlg);
                }
            });
        }
        if (!this.doNotDispatchEvents) {
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                SwtUtil.sleep(display);
            }
        }
        return null;
    }

    public boolean hasInstance() {
        return JebDialog.hasInstance(((Object)((Object)this)).getClass());
    }

    public static boolean hasInstance(Class<? extends JebDialog> cl) {
        List<JebDialog> list = instances.get(cl);
        return list != null && !list.isEmpty();
    }

    public static <T extends JebDialog> List<? extends T> getInstances(Class<T> cl) {
        List<JebDialog> list = instances.get(cl);
        return list == null ? Collections.emptyList() : list;
    }

    public static <T extends JebDialog> T getInstance(Class<T> cl) {
        List<JebDialog> list = instances.get(cl);
        return (T)((Object)(list == null || list.isEmpty() ? null : list.get(0)));
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean wasMoved() {
        return this.shellMoved;
    }

    public boolean wasResized() {
        return this.shellResized;
    }

    public void setFocus() {
        this.shell.setFocus();
    }

    public void setVisible(boolean visible) {
        this.shell.setVisible(visible);
    }

    protected abstract void createContents(Composite var1);

    public static Set<Integer> getDefaultButtonIds() {
        return defbtnmap.keySet();
    }

    protected Button getButtonByStyle(int style) {
        return this.buttons.get(style);
    }

    protected final Composite createOkayButton(Composite parent) {
        return this.createButtons(parent, 32, 32);
    }

    protected final Composite createOkayCancelButtons(Composite parent) {
        return this.createButtons(parent, 288, 32);
    }

    protected final Composite createButtons(Composite parent, int aggrButtonIds, int defaultButtonId) {
        aggrButtonIds |= defaultButtonId;
        ArrayList<Btn> avails = new ArrayList<Btn>();
        for (int id : defbtnmap.keySet()) {
            if ((aggrButtonIds & id) == 0) continue;
            avails.add(defbtnmap.get(id));
        }
        return this.createButtons(parent, 0, avails, defaultButtonId);
    }

    protected final Composite createButtons(Composite parent, int[] buttonIds, int defaultButtonId) {
        ArrayList<Btn> avails = new ArrayList<Btn>();
        for (int id : buttonIds) {
            Btn btn = defbtnmap.get(id);
            if (btn != null) {
                avails.add(defbtnmap.get(id));
                continue;
            }
            avails.add(new Btn(id, "AnonymousButton" + id));
        }
        return this.createButtons(parent, 0, avails, defaultButtonId);
    }

    protected final Composite createButtons(Composite parent, int style, List<Btn> buttons, int defaultButtonId) {
        Composite buttonsPanel = new Composite(parent, style);
        if (parent.getLayout() instanceof GridLayout) {
            int cols = buttons.size();
            buttonsPanel.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(cols));
        }
        buttonsPanel.setLayout((Layout)new RowLayout(256));
        for (Btn button : buttons) {
            int buttonId = button.getId();
            String buttonText = button.getText();
            Button btnwidget = UIUtil.createPushbox(buttonsPanel, this.getButtonText(buttonId, buttonText), e -> this.onButtonClick(buttonId));
            btnwidget.setLayoutData((Object)new RowData());
            this.buttons.put(buttonId, btnwidget);
            if (buttonId != defaultButtonId) continue;
            this.shell.setDefaultButton(btnwidget);
        }
        return buttonsPanel;
    }

    protected boolean hideButton(int btnId) {
        return this.hideButton(btnId, true);
    }

    protected boolean hideButton(int btnId, boolean hide) {
        Button btn = this.getButtonByStyle(btnId);
        if (btn == null || !(btn.getLayoutData() instanceof RowData)) {
            return false;
        }
        btn.setVisible(!hide);
        ((RowData)btn.getLayoutData()).exclude = hide;
        btn.getParent().pack(true);
        return true;
    }

    protected String getButtonText(int btnId, String defaultBtnText) {
        return defaultBtnText;
    }

    protected void onButtonClick(int buttonId) {
        if (buttonId == 32) {
            this.onConfirm();
        } else if (buttonId == 256) {
            this.onCancel();
        } else if (buttonId == 64) {
            this.onButtonYes();
        } else if (buttonId == 128) {
            this.onButtonNo();
        } else {
            this.shell.close();
        }
    }

    protected void onConfirm() {
        this.shell.close();
    }

    protected void onCancel() {
        this.shell.close();
    }

    protected void onButtonYes() {
        this.shell.close();
    }

    protected void onButtonNo() {
        this.shell.close();
    }

    protected boolean allowKeyboardEnterExecution(Event e) {
        return !FilterText.isSelected();
    }

    protected final void applyStandardGridDataForDialogWidget(Control ctl) {
        GridData data = new GridData(4, 4, true, true);
        ctl.setLayoutData((Object)data);
    }

    static {
        instances = new HashMap();
        defbtnmap = new HashMap<Integer, Btn>();
        defbtnmap.put(32, new Btn(32, 605));
        defbtnmap.put(256, new Btn(256, 105));
        defbtnmap.put(64, new Btn(64, 828));
        defbtnmap.put(128, new Btn(128, 594));
        defbtnmap.put(0x10000000, new Btn(0x10000000, 365));
        defbtnmap.put(0x20000000, new Btn(0x20000000, "Apply"));
        defbtnmap.put(8192, new Btn(8192, "Save"));
    }

    public static class Btn {
        int id;
        Integer textId;
        String text;

        public Btn(int id, int stringId) {
            this.id = id;
            this.textId = stringId;
        }

        public Btn(int id, String text) {
            this.id = id;
            this.text = text;
        }

        public int getId() {
            return this.id;
        }

        public String getText() {
            if (this.text != null) {
                return this.text;
            }
            return S.s(this.textId);
        }

        public String toString() {
            return this.getText();
        }
    }
}

