/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.api.GraphDialogExtensions;
import com.pnfsoftware.jeb.core.units.UnitAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ColorUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphMode;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphPlaceholder;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.GraphVertexAdapter;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.L;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.R;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.XYGraph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.ForceDirectedLayout;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.model.ILabelProvider;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;

public class GraphDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(GraphDialog.class);
    private RcpClientContext context;
    private Digraph model;
    private GraphDialogExtensions ext;
    private boolean propShowLabels = true;
    private boolean propShowTooltips = false;
    private GraphPlaceholder<CustomGraph> gp;
    private CustomGraph gg;

    public GraphDialog(Shell parent, String caption, RcpClientContext context, boolean doNotDispatchEvents) {
        super(parent, 3312, caption, null);
        this.context = context;
        this.doNotDispatchEvents = doNotDispatchEvents;
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
    }

    public void setModel(Digraph model) {
        this.model = model;
    }

    public Digraph getModel() {
        return this.model;
    }

    public void setExtensions(GraphDialogExtensions ext) {
        this.ext = ext;
    }

    @Override
    protected void createContents(Composite parent) {
        ForceDirectedLayout l;
        parent.setLayout((Layout)new FillLayout());
        if (this.model == null) {
            throw new IllegalStateException("Set a model (directed graph definition) before opening the dialog for rendering");
        }
        this.gp = new GraphPlaceholder<CustomGraph>(parent, 0, true, true){

            @Override
            protected CustomGraph createGraph(GraphPlaceholder<CustomGraph> gp, CustomGraph previousGraph) {
                return new CustomGraph(gp);
            }
        };
        this.gg = this.gp.getGraph();
        new ContextMenu((Control)this.gg).addContextMenu(new IContextMenu(){

            @Override
            public void fillContextMenu(IMenuManager menuman) {
                menuman.add(new Action("Navigate"){

                    @Override
                    public boolean isEnabled() {
                        return GraphDialog.this.context != null && GraphDialog.this.ext != null && GraphDialog.this.gg.getHoveredPoint() != null;
                    }

                    @Override
                    public void run() {
                        P p = GraphDialog.this.gg.getHoveredPoint();
                        if (p != null) {
                            GraphDialog.this.navigateNode(p);
                        }
                    }
                });
                menuman.add(new Action("Rename"){

                    @Override
                    public boolean isEnabled() {
                        return GraphDialog.this.ext != null && GraphDialog.this.gg.getHoveredPoint() != null;
                    }

                    @Override
                    public void run() {
                        P p = GraphDialog.this.gg.getHoveredPoint();
                        if (p != null) {
                            GraphDialog.this.renameNode(p);
                        }
                    }
                });
                menuman.add(new Action("Toggle Mark"){

                    @Override
                    public boolean isEnabled() {
                        return GraphDialog.this.ext != null && GraphDialog.this.gg.getHoveredPoint() != null;
                    }

                    @Override
                    public void run() {
                        P p = GraphDialog.this.gg.getHoveredPoint();
                        if (p != null) {
                            GraphDialog.this.toggleMarkOnNode(p);
                        }
                    }
                });
            }
        });
        String helpmsg = "Mouse controls:\n- mouse wheel to drag the graph\n- CTRL (COMMAND on macOS) + mouse wheel to zoom in/out\n- left button down on canvas to drag the graph\n- left button down on a node to drag the vertex\n- right click to bring the context menu and action handlers (rename, navigate)\n- double-click on a node to navigate (if the extension supports it)\n\nKeyboards controls:\n- arrows to navigate\n- [ (open bracket) to zoom out\n- ] (close bracket) to zoom in\n- \\ (slash) to center the graph and reset the zoom level\n- SPACE bar to cycle to the next rendering mode\n- L to toggle labels on/off\n- T to toggle tool tips on/off\n\nRendering:\nUse a com.pnfsoftware.jeb.client.api.GraphDialogExtensions object to customize rendering.\n";
        this.gp.addHelpButtonToToolbar(helpmsg);
        this.gp.addModesBoxToToolbar();
        final Button wLabels = this.gp.addCheckbox("Labels", this.propShowLabels);
        wLabels.setToolTipText("If unticked, only high-centrality nodes will have their labels displayed");
        wLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphDialog.this.setShowLabels(wLabels.getSelection());
            }
        });
        final Button wTooltips = this.gp.addCheckbox("Tooltips", this.propShowTooltips);
        wTooltips.setToolTipText("Display additional information when hovering on a node");
        wTooltips.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GraphDialog.this.setShowTooltips(wTooltips.getSelection());
            }
        });
        this.gg.addGraphVertexListener(new GraphVertexAdapter(){
            ToolTip tip;

            @Override
            public void onVertexDoubleClicked(XYGraph graph, P p) {
                GraphDialog.this.navigateNode(p);
            }

            @Override
            public void onVertexHoverIn(XYGraph graph, P p) {
                String desc;
                if (!GraphDialog.this.propShowTooltips) {
                    return;
                }
                Object s = graph.generateLabelForVertex(p);
                if (Strings.isBlank((CharSequence)s)) {
                    return;
                }
                if (GraphDialog.this.ext != null && !Strings.isBlank(desc = GraphDialog.this.ext.getDescription(p.getId()))) {
                    s = (String)s + "\n" + desc;
                }
                this.tip = new ToolTip(GraphDialog.this.getShell(), 0);
                Point loc = GraphDialog.this.getShell().getDisplay().map((Control)graph, null, graph.convertCoord(p));
                this.tip.setLocation(loc);
                this.tip.setMessage((String)s);
                this.tip.setAutoHide(true);
                this.tip.setVisible(true);
            }

            @Override
            public void onVertexHoverOut(XYGraph graph, P p) {
                if (this.tip != null && !this.tip.isDisposed()) {
                    this.tip.setMessage(" ");
                    Rectangle bounds = this.tip.getDisplay().getBounds();
                    this.tip.setLocation(bounds.width, bounds.height);
                    this.tip.setAutoHide(true);
                    this.tip.setVisible(true);
                    this.tip.dispose();
                    this.tip = null;
                }
            }
        });
        GraphDialogExtensions.LayoutMode layoutMode = null;
        if (this.ext != null) {
            layoutMode = this.ext.getLayoutMode();
        }
        if (layoutMode == null) {
            layoutMode = GraphDialogExtensions.LayoutMode.FDC;
        }
        if (layoutMode == GraphDialogExtensions.LayoutMode.FDC || layoutMode == GraphDialogExtensions.LayoutMode.FDC_NO_WEIGHT) {
            this.determineVerticesWeights(this.model);
            P[] initial_vertex_points = this.layoutVerticesBasedOnCentrality(this.model, 1.0, 1.0);
            l = new ForceDirectedLayout(this.model, 100, 1.0, 1.0, initial_vertex_points);
            l.layout();
            if (layoutMode == GraphDialogExtensions.LayoutMode.FDC_NO_WEIGHT) {
                for (Digraph.V v : this.model.getVertices()) {
                    v.setWeight(0.0);
                    v.setVertexCentralityScore(0.0);
                }
            }
        } else {
            throw new RuntimeException("Unsupported layout mode: " + layoutMode);
        }
        List<P> points = Arrays.asList(l.getPoints());
        List<L> lines = this.generateLinesForEdges(this.model);
        this.gg.setLabelProvider(new ILabelProvider(){

            @Override
            public String getLabel(int vertexId) {
                Digraph.V v = GraphDialog.this.model.getVertex(vertexId);
                String label = v.getLabel();
                return label != null ? label : "" + vertexId;
            }
        });
        this.gg.setParameters(points, lines, true);
        this.gg.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == ' ') {
                    GraphDialog.this.gg.cycleMode();
                } else if (e.character == 'l') {
                    boolean sel = !wLabels.getSelection();
                    wLabels.setSelection(sel);
                    GraphDialog.this.setShowLabels(sel);
                } else if (e.character == 't') {
                    boolean sel = !wTooltips.getSelection();
                    wTooltips.setSelection(sel);
                    GraphDialog.this.setShowTooltips(sel);
                }
            }
        });
        this.gg.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    GraphDialog.this.shell.close();
                } else {
                    e.doit = true;
                }
            }
        });
        this.gg.setMode(1);
    }

    void setShowLabels(boolean show) {
        this.propShowLabels = show;
        this.gg.refreshGraph();
    }

    void setShowTooltips(boolean show) {
        this.propShowTooltips = show;
        this.gg.refreshGraph();
    }

    private void navigateNode(P p) {
        if (this.ext == null) {
            return;
        }
        int vertexId = this.model.getVertex(p.getId()).getId();
        UnitAddress<?> ua = this.ext.getUnitAddress(vertexId);
        if (ua != null) {
            GraphicalActionExecutor.gotoAddress(this.context, ua.getUnit(), ua.getAddress());
        }
    }

    private void renameNode(P p) {
        if (this.ext == null) {
            return;
        }
        int vertexId = this.model.getVertex(p.getId()).getId();
        String name = UI.ask(this.getShell(), "Rename", "Node name:", this.model.getVertexLabel(vertexId));
        if (name != null && this.ext.processNewVertexName(vertexId, name)) {
            this.model.setVertexLabel(vertexId, name);
        }
    }

    private void toggleMarkOnNode(P p) {
        int vertexId;
        if (this.ext == null) {
            return;
        }
        Digraph.V v = this.model.getVertex(p.getId());
        boolean mark = this.ext.getVertexMark(vertexId = v.getId());
        if (this.ext.processVertexMark(vertexId, !mark)) {
            logger.info("Mark not set! (node %s)", v);
        }
    }

    private List<L> generateLinesForEdges(Digraph g) {
        ArrayList<L> lines = new ArrayList<L>();
        for (Digraph.E e : g.getEdges()) {
            lines.add(new L(e.getSrc().getId(), e.getDst().getId()));
        }
        return lines;
    }

    private List<P> selectPointsInBounds(Collection<P> points, R bounds) {
        ArrayList<P> r = new ArrayList<P>();
        for (P p : points) {
            if (!bounds.contains(p)) continue;
            r.add(p);
        }
        return r;
    }

    private void determineVerticesWeights(Digraph g) {
        double minweight = Double.MAX_VALUE;
        double maxweight = -1.7976931348623157E308;
        for (Digraph.V v : g.getVertices()) {
            if (v.getWeight() == null) continue;
            if (v.getWeight() < minweight) {
                minweight = v.getWeight();
            }
            if (!(v.getWeight() > maxweight)) continue;
            maxweight = v.getWeight();
        }
        for (Digraph.V v : g.getVertices()) {
            if (v.getWeight() != null) {
                v.setWeight((v.getWeight() - minweight) / (maxweight - minweight));
                continue;
            }
            v.setWeight(0.0);
        }
        if (g.getEdgeCount() <= 5000) {
            this.model.computeEdgeBetweenness();
            double max_vcscore = -1.7976931348623157E308;
            for (Digraph.V v : g.getVertices()) {
                if (!(v.getVertexCentralityScore() > max_vcscore)) continue;
                max_vcscore = v.getVertexCentralityScore();
            }
            for (Digraph.V v : g.getVertices()) {
                v.normalizeVertexCentralityScore(max_vcscore);
            }
            for (Digraph.V v : g.getVertices()) {
                v.setWeight(0.3 * v.getWeight() + 0.7 * v.getVertexCentralityScore());
            }
        } else {
            this.model.resetEdgeBetweennessScores();
        }
    }

    private P[] layoutVerticesBasedOnCentrality(Digraph g, double w, double h) {
        int cnt = g.getVertexCount();
        P[] initial_points = new P[cnt];
        List<Integer> indices = g.getVertexIndexesByDescendingCentrality();
        Assert.a(indices.size() == cnt);
        double d = Math.sqrt(w * h / (double)cnt);
        double x0 = w / 2.0;
        double y0 = h / 2.0;
        int dir = 0;
        int dir_change_count = 0;
        int requested_inline = 1;
        int inline = 0;
        for (int i = 0; i < cnt; ++i) {
            int vertex_index = indices.get(i);
            initial_points[vertex_index] = new P(g.getVertexByIndex(vertex_index).getId(), x0, y0);
            switch (dir) {
                case 0: {
                    x0 += d;
                    break;
                }
                case 1: {
                    y0 += d;
                    break;
                }
                case 2: {
                    x0 -= d;
                    break;
                }
                default: {
                    y0 -= d;
                }
            }
            if (++inline != requested_inline) continue;
            dir = (dir + 1) % 4;
            if (++dir_change_count % 2 == 0) {
                ++requested_inline;
            }
            inline = 0;
        }
        return initial_points;
    }

    class CustomGraph
    extends XYGraph {
        static final int MODE_ALL = 0;
        static final int MODE_RELEVANT = 1;
        static final int MODE_FILTERED = 2;
        static final int MODE_FILTERED_RELEVANT = 3;
        static final int MODE_DEFAUT = 1;
        private static final int DEFAULT_MAX_NODE_DENSITY = 30000;

        CustomGraph(Composite parent) {
            super(parent);
            this.addSupportedMode(new GraphMode(0, "All nodes", null));
            this.addSupportedMode(new GraphMode(1, "High-score nodes", null));
            this.addSupportedMode(new GraphMode(2, "Filtered nodes (custom)", null));
            this.addSupportedMode(new GraphMode(3, "Filtered high-score nodes (custom)", null));
        }

        @Override
        protected Collection<P> determineVisibleVertices(Collection<P> points) {
            this.setActiveNodeAnimationEnabled(true);
            if (this.getModeId() == 0) {
                return points;
            }
            if (this.getModeId() == 2) {
                if (GraphDialog.this.ext == null) {
                    return points;
                }
                ArrayList<P> r = new ArrayList<P>();
                if (GraphDialog.this.ext != null) {
                    for (P p : points) {
                        if (!GraphDialog.this.ext.getShowVertex(GraphDialog.this.model.getVertex(p.getId()).getId())) continue;
                        r.add(p);
                    }
                }
                return r;
            }
            if (this.getModeId() == 1 || this.getModeId() == 3) {
                int surface = this.getClientArea().width * this.getClientArea().height;
                int density = -1;
                if (GraphDialog.this.ext != null) {
                    density = GraphDialog.this.ext.getCanvasNodeDensity();
                }
                if (density <= 0) {
                    density = 30000;
                }
                int maxNodes = surface / density;
                List<P> r = GraphDialog.this.selectPointsInBounds(points, this.getGraphBounds());
                r.sort((a, b) -> -Double.compare(GraphDialog.this.model.getVertex(a.getId()).getWeight(), GraphDialog.this.model.getVertex(b.getId()).getWeight()));
                if (r.size() >= maxNodes) {
                    r = r.subList(0, maxNodes);
                }
                if (this.getModeId() == 3 && GraphDialog.this.ext != null) {
                    Iterator<P> it = r.iterator();
                    while (it.hasNext()) {
                        P p = it.next();
                        if (GraphDialog.this.ext.getShowVertex(GraphDialog.this.model.getVertex(p.getId()).getId())) continue;
                        it.remove();
                    }
                }
                return r;
            }
            return points;
        }

        @Override
        protected Collection<L> determineVisibleEdges(Collection<P> visiblePoints, Collection<L> edges) {
            if (this.getModeId() == 0) {
                return edges;
            }
            HashSet<Integer> visibleVertexIds = new HashSet<Integer>();
            for (P p : visiblePoints) {
                visibleVertexIds.add(p.getId());
            }
            ArrayList<L> r = new ArrayList<L>();
            for (L edge : edges) {
                int srcId = edge.getSrcId();
                int dstId = edge.getDstId();
                if (!visibleVertexIds.contains(srcId) && !visibleVertexIds.contains(dstId)) continue;
                r.add(edge);
            }
            return r;
        }

        @Override
        protected void drawVertex(GC gc, P p, Point pt) {
            Color col;
            Digraph.V v = GraphDialog.this.model.getVertex(p.getId());
            double w = v.getWeight();
            if (p == this.getHoveredPoint() || p == this.getSelectedPoint() || this.getActivePointsStatus() && this.isActivePoint(p)) {
                col = UIAssetManager.getInstance().getColor(0);
            } else {
                int rgb = -1;
                if (GraphDialog.this.ext != null) {
                    rgb = GraphDialog.this.ext.getVertexColor(v.getId());
                }
                if (rgb < 0) {
                    int r = Math.min(192, (int)((1.0 - w) * 255.0));
                    boolean marked = false;
                    if (GraphDialog.this.ext != null) {
                        marked = GraphDialog.this.ext.getVertexMark(v.getId());
                    }
                    col = marked ? UIAssetManager.getInstance().getColor(r, 255, r) : UIAssetManager.getInstance().getColor(255, r, r);
                } else {
                    col = UIAssetManager.getInstance().getColor(rgb);
                    col = ColorUtil.transformC(col, null, null, (int)((1.0 - w) * 100.0));
                }
            }
            GraphDialogExtensions.VertexShape shape = null;
            if (GraphDialog.this.ext != null) {
                shape = GraphDialog.this.ext.getVertexShape(v.getId());
            }
            if (shape == null) {
                shape = GraphDialogExtensions.VertexShape.CIRCLE_FILLED;
            }
            int pr = (int)(28.0 * w) + 10;
            if (shape == GraphDialogExtensions.VertexShape.CIRCLE_FILLED) {
                gc.setBackground(col);
                gc.setForeground(gc.getDevice().getSystemColor(-1));
                gc.fillOval(pt.x - pr / 2, pt.y - pr / 2, pr, pr);
            } else if (shape == GraphDialogExtensions.VertexShape.SQUARE_FILLED) {
                gc.setBackground(col);
                gc.setForeground(gc.getDevice().getSystemColor(-1));
                gc.fillRectangle(pt.x - pr / 2, pt.y - pr / 2, pr, pr);
            } else if (shape == GraphDialogExtensions.VertexShape.CIRCLE) {
                gc.setBackground(gc.getDevice().getSystemColor(-1));
                gc.setForeground(col);
                gc.drawOval(pt.x - pr / 2, pt.y - pr / 2, pr, pr);
            } else if (shape == GraphDialogExtensions.VertexShape.SQUARE) {
                gc.setBackground(gc.getDevice().getSystemColor(-1));
                gc.setForeground(col);
                gc.drawRectangle(pt.x - pr / 2, pt.y - pr / 2, pr, pr);
            } else {
                gc.drawPoint(pt.x, pt.y);
            }
        }

        @Override
        protected void drawVertexLabel(GC gc, P p, Point pt) {
            Double vcs;
            Digraph.V v = GraphDialog.this.model.getVertex(p.getId());
            if (!GraphDialog.this.propShowLabels && ((vcs = v.getVertexCentralityScore()) == null || vcs < 0.8)) {
                return;
            }
            super.drawVertexLabel(gc, p, pt);
        }

        @Override
        protected void drawEdge(GC gc, L l, Point a, Point b) {
            int id;
            Digraph.V v1 = null;
            Digraph.V v2 = null;
            if (GraphDialog.this.ext != null) {
                v1 = GraphDialog.this.model.getVertex(l.getSrcId());
                v2 = GraphDialog.this.model.getVertex(l.getDstId());
            }
            int rgb = -1;
            boolean highlight = false;
            P pt = this.getHoveredPoint();
            if (pt != null) {
                id = pt.getId();
                boolean bl = highlight = id == l.getSrcId() || id == l.getDstId();
            }
            if (!highlight && (pt = this.getSelectedPoint()) != null) {
                id = pt.getId();
                boolean bl = highlight = id == l.getSrcId() || id == l.getDstId();
            }
            if (highlight) {
                rgb = 0;
            }
            if (rgb < 0 && GraphDialog.this.ext != null) {
                rgb = GraphDialog.this.ext.getEdgeColor(v1.getId(), v2.getId());
            }
            if (rgb < 0) {
                rgb = 0xC0C0C0;
            }
            Color col = UIAssetManager.getInstance().getColor(rgb);
            gc.setForeground(col);
            GraphDialogExtensions.EdgeStyle style = null;
            if (GraphDialog.this.ext != null) {
                style = GraphDialog.this.ext.getEdgeStyle(v1.getId(), v2.getId());
            }
            if (style == null || style == GraphDialogExtensions.EdgeStyle.SOLID) {
                gc.setLineStyle(1);
            } else if (style == GraphDialogExtensions.EdgeStyle.DASHED) {
                gc.setLineStyle(2);
            } else if (style == GraphDialogExtensions.EdgeStyle.DOTTED) {
                gc.setLineStyle(3);
            }
            gc.drawLine(a.x, a.y, b.x, b.y);
            if (GraphDialog.this.ext != null) {
                Integer r = GraphDialog.this.ext.displayEdgesOrientation();
                if (r == null) {
                    r = 50;
                }
                if (r >= 0 && r <= 100) {
                    double arPosRatio = (double)r.intValue() / 100.0;
                    int width0 = gc.getLineWidth();
                    gc.setLineWidth(1);
                    int X = a.x - b.x;
                    int Y = a.y - b.y;
                    double LEN = Math.sqrt(X * X + Y * Y);
                    double arX = (double)(X * 10) / LEN;
                    double arY = (double)(Y * 10) / LEN;
                    double cosR = Math.cos(0.5);
                    double sinR = Math.sin(0.5);
                    double e1 = arX * cosR;
                    double e2 = arY * sinR;
                    double e3 = arX * sinR;
                    double e4 = arY * cosR;
                    double roX = e1 - e2;
                    double roY = e3 + e4;
                    double deltaX = arPosRatio * (double)(b.x - a.x) + (double)a.x;
                    double deltaY = arPosRatio * (double)(b.y - a.y) + (double)a.y;
                    gc.drawLine((int)(roX + deltaX), (int)(roY + deltaY), (int)deltaX, (int)deltaY);
                    roX = e1 + e2;
                    roY = -e3 + e4;
                    gc.drawLine((int)(roX + deltaX), (int)(roY + deltaY), (int)deltaX, (int)deltaY);
                    gc.setLineWidth(width0);
                }
            }
        }

        @Override
        protected void postDrawing(GC gc) {
            if (this.isDragging()) {
                return;
            }
            int x = 2;
            P p = this.getHoveredPoint();
            if (p != null) {
                Object text = this.generateLabelForVertex(p);
                Digraph.V v = GraphDialog.this.model.getVertex(p.getId());
                text = (String)text + Strings.ff(" (vcs=%.3f w=%.3f)", v.getVertexCentralityScore(), v.getWeight());
                Point dim = gc.stringExtent((String)text);
                gc.setForeground(this.getDisplay().getSystemColor(2));
                gc.drawString((String)text, x, this.getClientArea().height - dim.y, true);
                int cfr_ignored_0 = dim.x;
            }
        }
    }
}

