/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FormDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(FormDialog.class);
    public static final int INLINE = 1;
    private String description;
    private Label wValidatorInfoLabel;
    private List<E> entries = new ArrayList<E>();
    private List<String> values;

    public FormDialog(Shell parent, String caption, String description) {
        super(parent, caption, true, true);
        this.scrolledContainer = true;
        this.description = description;
    }

    public void addTextInput(String hdr) {
        this.addTextInput(hdr, null, 0);
    }

    public void addTextInput(String hdr, String defval, int flags) {
        this.addTextInput(hdr, defval, flags, 0, 0, null);
    }

    public void addTextInput(String hdr, String defval, int flags, int minColumnCount, int minLineCount, Predicate<String> validator) {
        this.entries.add(new E(hdr, defval, flags, minColumnCount, minLineCount, validator));
    }

    public String[] open() {
        super.open();
        if (this.values == null) {
            return null;
        }
        return this.values.toArray(new String[this.values.size()]);
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        if (this.description != null) {
            Label wDescriptionLabel = new Label(parent, 0);
            wDescriptionLabel.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
            wDescriptionLabel.setText(this.description);
        }
        int validatorCount = 0;
        int ientry = 0;
        for (final E e : this.entries) {
            int len;
            Composite wparent = parent;
            if ((e.flags & 1) != 0) {
                wparent = UIUtil.createCompositeGrid(parent, 0, 1, 2, 0);
            }
            Label label = new Label(wparent, 0);
            label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, false, false));
            Object hdr = e.hdr;
            if (hdr == null) {
                hdr = "Entry_" + ientry;
            }
            label.setText((String)hdr);
            int minColumnCount = e.minColumnCount;
            if (e.defval != null && (len = e.defval.length()) > minColumnCount) {
                minColumnCount = len;
            }
            minColumnCount = Math.max(4, minColumnCount);
            int minLineCount = Math.max(1, e.minLineCount);
            final Text w = minLineCount >= 2 ? UIUtil.createTextboxInGrid(wparent, 2626, minColumnCount, minLineCount, true, true) : UIUtil.createTextboxInGrid(wparent, 2048, minColumnCount, 1, true, false);
            e.w = w;
            if (e.defval != null) {
                w.setText(e.defval);
            }
            UIUtil.disableTabOutput((Control)w);
            if (e.validator != null) {
                w.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                        if (e.validator != null) {
                            if (!e.validator.test(w.getText())) {
                                w.setBackground(w.getDisplay().getSystemColor(3));
                            } else {
                                w.setBackground(null);
                            }
                        }
                    }
                });
                ++validatorCount;
            }
            ++ientry;
        }
        if (validatorCount > 0) {
            this.wValidatorInfoLabel = new Label(parent, 0);
            this.wValidatorInfoLabel.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        }
        this.createOkayCancelButtons(parent);
    }

    @Override
    protected void onConfirm() {
        boolean failed = false;
        for (E e : this.entries) {
            String text;
            if (e.validator == null || e.validator.test(text = e.w.getText())) continue;
            failed = true;
        }
        if (failed) {
            if (this.wValidatorInfoLabel != null) {
                this.wValidatorInfoLabel.setText("Some fields contain invalid data.");
            }
            return;
        }
        if (this.wValidatorInfoLabel != null) {
            this.wValidatorInfoLabel.setText("");
        }
        this.values = new ArrayList<String>(this.entries.size());
        for (E e : this.entries) {
            this.values.add(e.w.getText());
        }
        super.onConfirm();
    }

    static class E {
        String hdr;
        String defval;
        int flags;
        int minColumnCount;
        int minLineCount;
        Predicate<String> validator;
        private Text w;

        E(String hdr, String defval, int flags, int minColumnCount, int minLineCount, Predicate<String> validator) {
            this.hdr = hdr;
            this.defval = defval;
            this.flags = flags;
            this.minColumnCount = minColumnCount;
            this.minLineCount = minLineCount;
            this.validator = validator;
        }
    }
}

