/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ContentAssistedText;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FinderManager;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFinder;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FindTextDialog
extends JebDialog {
    private static final ILogger logger = GlobalLog.getLogger(FindTextDialog.class);
    private static WeakIdentityHashMap<Object, FindTextDialog> usermap = new WeakIdentityHashMap();
    private boolean showTickboxForLegacyFindDialog;
    private boolean preferLegacyFindDialog;
    private FinderManager<?> findman;
    private TextHistory textHistory;
    private ContentAssistedText searchField;
    private Button btn_binary;
    private Button btn_case_sensitive;
    private Button btn_regex;
    private Button btn_reverse;
    private Button btn_wraparound;
    private boolean validRegex;
    private boolean wantsRegex;
    private boolean optmod;
    private KeyAdapter kl = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            Object o;
            if (e.stateMask == SWT.MOD1 && e.keyCode == 102 && (o = FindTextDialog.this.getOwnerObject()) instanceof Control) {
                ((Control)o).setFocus();
            }
        }
    };

    public static String debugPrint() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<Object, FindTextDialog> e : usermap.entrySet()) {
            Strings.ff(sb, "entry %d: %s -> %s (disposed: %b)\n", new Object[]{i, e.getKey(), e.getValue(), e.getValue().getShell().isDisposed()});
            ++i;
        }
        return sb.toString();
    }

    public static FindTextDialog getInstance(Object owner) {
        return usermap.get(owner);
    }

    public FindTextDialog(Shell parent, FinderManager<?> finder, TextHistory textHistory) {
        this(parent, finder, textHistory, true, null, null);
    }

    public FindTextDialog(Shell parent, FinderManager<?> findman, TextHistory textHistory, boolean modal, Control owner, String ownerName) {
        super(parent, FindTextDialog.generateTitle(ownerName), true, modal);
        this.scrolledContainer = true;
        if (findman == null) {
            throw new NullPointerException();
        }
        this.findman = findman;
        this.textHistory = textHistory;
        if (!modal && owner != null) {
            owner.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (!FindTextDialog.this.shell.isDisposed()) {
                        FindTextDialog.this.shell.dispose();
                    }
                }
            });
        }
    }

    private static String generateTitle(String ownerName) {
        Object title = S.s(345);
        if (ownerName != null) {
            title = (String)title + " (" + Strings.truncateWithSuffix(ownerName, 24, "...") + ")";
        }
        return title;
    }

    private void setOwnerObject(Object owner) {
        usermap.put(owner, this);
    }

    private void unsetOwnerObject(Object owner) {
        usermap.remove(owner);
    }

    private Object getOwnerObject() {
        for (Object o : usermap.keySet()) {
            if (usermap.get(o) != this) continue;
            return o;
        }
        return null;
    }

    public void setShowTickboxForLegacyFindDialog(boolean enabled) {
        this.showTickboxForLegacyFindDialog = enabled;
    }

    public void setPreferLegacyFindDialog(boolean selected) {
        this.preferLegacyFindDialog = selected;
    }

    public boolean isPreferLegacyFindDialog() {
        return this.preferLegacyFindDialog;
    }

    public Object open(Object owner) {
        try {
            this.setOwnerObject(owner);
            Object object = this.open();
            return object;
        }
        finally {
            this.unsetOwnerObject(owner);
        }
    }

    @Override
    public Object open() {
        super.open();
        return null;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent);
        if (this.showTickboxForLegacyFindDialog) {
            Composite c = UIUtil.createCompositeGrid(parent, 0, 1, 3, 0);
            Button btn = UIUtil.createCheckbox(c, "Tick to set this (legacy) Find dialog as the default one for searches in unit text documents", (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FindTextDialog.this.preferLegacyFindDialog = ((Button)e.widget).getSelection();
                }
            });
            btn.setSelection(this.preferLegacyFindDialog);
        }
        Group areaSearch = new Group(parent, 0);
        areaSearch.setText("Pattern");
        areaSearch.setLayoutData((Object)new GridData(4, 128, true, false));
        areaSearch.setLayout((Layout)new GridLayout(1, false));
        Group areaOptions = new Group(parent, 0);
        areaOptions.setText(S.s(616));
        areaOptions.setLayoutData((Object)new GridData(4, 128, true, false));
        areaOptions.setLayout((Layout)new GridLayout(2, false));
        Composite areaAction = new Composite(parent, 0);
        areaAction.setLayout((Layout)new RowLayout(256));
        this.searchField = new ContentAssistedText((Composite)areaSearch, 2048, UI.acc("String:", 115), this.textHistory, true);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.searchField.setLayoutData(data);
        this.searchField.selectAll();
        this.searchField.setFocus();
        this.btn_binary = new Button((Composite)areaSearch, 32);
        this.btn_binary.setText(UI.acc("Binary Search", 98));
        this.btn_binary.setToolTipText("Hex string with optional wildcard '?', or string suffixed by '/[encoding]'.\nExamples:\n  90909090909090CCCCCC00000050 (an odd count of nybbles is required)\n  89 45 FC (spaces are optional, can be used for clarity)\n  89 4? FC ?? A4 (note the full-byte and half-byte wildcards)\n  hey/ (uses default encoding; if utf-8, equivalent to searching: 68 65 79)\n  hey/ascii (uses ascii encoding, equivalent to searching: 68 65 79)\n");
        this.btn_binary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.optmod = true;
                FindTextDialog.this.update();
            }
        });
        this.btn_binary.setEnabled(this.findman.getBinaryFinder() != null);
        this.btn_case_sensitive = new Button((Composite)areaOptions, 32);
        this.btn_case_sensitive.setText(UI.acc(S.s(109), 105));
        this.btn_case_sensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.optmod = true;
            }
        });
        this.btn_regex = new Button((Composite)areaOptions, 32);
        this.btn_regex.setText(UI.acc(S.s(676), 120));
        this.btn_regex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.optmod = true;
            }
        });
        this.btn_wraparound = new Button((Composite)areaOptions, 32);
        this.btn_wraparound.setText(UI.acc(S.s(826), 119));
        this.btn_wraparound.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.optmod = true;
            }
        });
        this.btn_reverse = new Button((Composite)areaOptions, 32);
        this.btn_reverse.setText(UI.acc(S.s(684), 114));
        this.btn_reverse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.optmod = true;
            }
        });
        UIUtil.createPushbox(areaAction, S.s(345), e -> this.search());
        UIUtil.createPushbox(areaAction, S.s(201), e -> this.shell.close());
        UIUtil.createPushbox(areaAction, S.s(365), e -> this.help());
        FindTextOptions opt = this.findman.getLastUsedFinder() != null ? this.findman.getLastUsedFinder().getFindTextOptions(false) : this.getFinder().getFindTextOptions(true);
        this.btn_binary.setSelection(opt.isBinary());
        this.load(opt);
        this.update();
        this.btn_regex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindTextDialog.this.wantsRegex = FindTextDialog.this.btn_regex.getSelection();
            }
        });
        this.searchField.getWidget().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r' && e.doit) {
                    FindTextDialog.this.search();
                }
            }
        });
        this.searchField.getWidget().addKeyListener((KeyListener)this.kl);
        this.btn_binary.addKeyListener((KeyListener)this.kl);
        this.btn_case_sensitive.addKeyListener((KeyListener)this.kl);
        this.btn_regex.addKeyListener((KeyListener)this.kl);
        this.btn_reverse.addKeyListener((KeyListener)this.kl);
        this.btn_wraparound.addKeyListener((KeyListener)this.kl);
        this.searchField.getWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindTextDialog.this.optmod = true;
                FindTextDialog.this.validateRegex();
            }
        });
        this.validateRegex();
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                FindTextDialog.this.optmod = true;
            }
        });
    }

    private void help() {
        String msg = "A simple search performs a textual search in the document buffer.\n(Looking for 'global find'? Use the Omnibox for project-wide search!)\n\nBinary search is available if the document offers a binary view. The search string is written in hex, with optional wildcards '?' (or '.') to specify unknown nybble. It can also be a string suffixed by /[encoding]\n\nExamples:\n  90909090909090CCCCCC00000050 (an odd count of nybbles is required)\n  89 45 FC (spaces are optional, can be used for clarity)\n  89 4? FC ?? A4 (note the full-byte and half-byte wildcards)\n  hey/ (uses default encoding; if utf-8, equivalent to searching: 68 65 79)\n  hey/ascii (uses ascii encoding, equivalent to searching: 68 65 79)\n\n";
        UI.info(this.shell, "Help", msg);
    }

    private void load(FindTextOptions opt) {
        this.searchField.setText(opt.getSearchString());
        this.searchField.selectAll();
        this.btn_case_sensitive.setSelection(opt.isCaseSensitive());
        this.btn_regex.setSelection(opt.isRegularExpression());
        this.btn_reverse.setSelection(opt.isReverseSearch());
        this.btn_wraparound.setSelection(opt.isWrapAround());
    }

    private void update() {
        IFinder<?> finder = this.getFinder();
        this.btn_case_sensitive.setEnabled(finder.supportCaseInsensitive());
        this.btn_regex.setEnabled(finder.supportRegex());
        this.btn_reverse.setEnabled(finder.supportReverseSearch());
        this.btn_wraparound.setEnabled(finder.supportWrapAround());
    }

    private IFinder<?> getFinder() {
        if (this.btn_binary == null) {
            return this.findman.getLastUsedFinder();
        }
        if (this.btn_binary.getSelection()) {
            return this.findman.getBinaryFinder();
        }
        return this.findman.getDefaultFinder();
    }

    private void search() {
        String value = this.searchField.getText();
        if (value.length() <= 0) {
            return;
        }
        this.searchField.confirm();
        FindTextOptions opt = this.getFinder().getFindTextOptions(true);
        opt.setSearchString(value);
        opt.setBinary(this.btn_binary.getSelection());
        opt.setCaseSensitive(this.btn_case_sensitive.getSelection());
        opt.setRegularExpression(this.btn_regex.getSelection());
        opt.setWrapAround(this.btn_wraparound.getSelection());
        opt.setReverseSearch(this.btn_reverse.getSelection());
        this.findman.search(opt);
        this.getShell().setFocus();
    }

    private void validateRegex() {
        try {
            Pattern.compile(this.searchField.getText());
            this.validRegex = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.validRegex = false;
        }
        if (!this.validRegex) {
            this.btn_regex.setSelection(false);
            this.btn_regex.setEnabled(false);
        } else {
            this.btn_regex.setEnabled(true);
            this.btn_regex.setSelection(this.wantsRegex);
        }
    }
}

