/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeedbackDialog
extends TitleAreaDialog {
    private static final ILogger logger = GlobalLog.getLogger(FeedbackDialog.class);
    int mode;
    RcpClientContext context;
    Text txtSuggestion;

    public FeedbackDialog(Shell shell, int mode, RcpClientContext context) {
        super(shell);
        this.mode = mode;
        this.context = context;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Feedback");
        if (this.mode == 0) {
            this.setTitle("Optional survey");
            this.setMessage("What is the most important feature you would like to have in JEB next?");
        } else {
            this.setTitle("Feedback form");
            this.setMessage("Use this form to send us suggestions, feature requests, bug reports, etc.", 1);
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        this.txtSuggestion = new Text(container, 2050);
        this.txtSuggestion.setLayoutData((Object)data);
        return area;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Send", true);
        this.createButton(parent, 1, "Cancel", false);
    }

    @Override
    protected void okPressed() {
        final String suggestion = this.txtSuggestion.getText();
        if (Strings.countNonBlankCharacters(suggestion) < 3) {
            UI.error("Cannot submit a blank answer!");
            this.txtSuggestion.setFocus();
            return;
        }
        String r = this.context.executeNetworkTask(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    String url = "https://www.pnfsoftware.com/submitsurvey?survey=productSurvey1&licenseid=" + Licensing.license_id;
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("suggestion", suggestion);
                    return FeedbackDialog.this.context.getNetworkUtility().post(url, null, params);
                }
                catch (IOException e) {
                    UI.error("An error occurred.\n\nException: " + e.getMessage());
                    return null;
                }
            }
        });
        (new Object[1])[0] = r;
        UI.info("Thank you!");
        this.setReturnCode(0);
        this.close();
    }
}

