/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DirectorySelectorView;
import com.pnfsoftware.jeb.util.encoding.Conversion;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDecompiledCodeDialog
extends JebDialog {
    private Text wFilter;
    private ExportStatus exportStatus;
    private State exportState = State.ALL;
    private Text wItemTimeout;
    private Integer itemTimeout;
    private Text wTotalTimeout;
    private Integer totalTimeout;
    private String initialFilter;
    private String initialDirectory;
    private DirectorySelectorView wOutputDir;
    private String outputDir;
    private Button wMerge;
    private boolean merge;
    private Text wOutputMergedFile;
    private String outputFile;
    private Button wResume;
    private boolean resume;
    public Boolean optAllow_OnlyDecompiledItems = true;
    public Boolean optAllow_CurrentSourceUnit = true;
    public Boolean optAllow_MergeAll = true;
    public Boolean optAllow_Resume = true;

    public ExportDecompiledCodeDialog(Shell parent) {
        this(parent, null);
    }

    public ExportDecompiledCodeDialog(Shell parent, String optTitle) {
        super(parent, optTitle != null ? optTitle : S.s(327), true, true);
        this.scrolledContainer = true;
    }

    public void setInitialState(State state) {
        this.exportState = state;
    }

    public void setInitialState(ExportStatus state) {
        this.setInitialState(state.state);
        this.setInitialFilter(state.filter);
    }

    public State getState() {
        return this.exportState;
    }

    public void setInitialFilter(String initialFilter) {
        this.initialFilter = initialFilter;
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectory = initialDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDir;
    }

    public boolean isMergeFiles() {
        return this.merge;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public boolean shoudResume() {
        return this.resume;
    }

    public void setInitialItemTimeoutSec(int itemTimeout) {
        if (itemTimeout >= 0) {
            this.itemTimeout = itemTimeout;
        }
    }

    public int getItemTimeoutSec() {
        if (this.itemTimeout == null) {
            return -1;
        }
        return this.itemTimeout;
    }

    public void setInitialTotalTimeoutSec(int totalTimeout) {
        if (totalTimeout >= 0) {
            this.totalTimeout = totalTimeout;
        }
    }

    public int getTotalTimeoutSec() {
        if (this.totalTimeout == null) {
            return -1;
        }
        return this.totalTimeout;
    }

    @Override
    public ExportStatus open() {
        super.open();
        return this.exportStatus;
    }

    @Override
    public void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        Group c0 = new Group(parent, 0);
        c0.setText(S.s(324));
        GridData exportGridData = UIUtil.createGridDataFillHorizontally();
        exportGridData.horizontalSpan = 1;
        c0.setLayoutData((Object)exportGridData);
        c0.setLayout((Layout)new GridLayout(1, false));
        Button btnAll = new Button((Composite)c0, 16);
        btnAll.setText(S.s(54));
        btnAll.addSelectionListener((SelectionListener)new ExportSelectionListener(State.ALL));
        Button btnFilter = new Button((Composite)c0, 16);
        btnFilter.setText(S.s(343));
        btnFilter.addSelectionListener((SelectionListener)new ExportSelectionListener(State.FILTER));
        this.wFilter = new Text((Composite)c0, 2048);
        this.wFilter.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.wFilter.setMessage(S.s(343));
        Button btnDecomp = null;
        if (this.optAllow_OnlyDecompiledItems != null) {
            btnDecomp = new Button((Composite)c0, 16);
            btnDecomp.setText(S.s(607));
            btnDecomp.addSelectionListener((SelectionListener)new ExportSelectionListener(State.DECOMPILED));
            btnDecomp.setEnabled(this.optAllow_OnlyDecompiledItems.booleanValue());
        }
        Button btnCurrent = null;
        Text currentUnitText = null;
        if (this.optAllow_CurrentSourceUnit != null) {
            btnCurrent = new Button((Composite)c0, 16);
            btnCurrent.setText(S.s(228));
            btnCurrent.addSelectionListener((SelectionListener)new ExportSelectionListener(State.CURRENT));
            btnCurrent.setEnabled(this.optAllow_CurrentSourceUnit.booleanValue());
            currentUnitText = new Text((Composite)c0, 2048);
            currentUnitText.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            currentUnitText.setEnabled(false);
        }
        switch (this.exportState) {
            case ALL: {
                btnAll.setSelection(true);
                btnAll.setFocus();
                this.wFilter.setEnabled(false);
                if (btnCurrent == null) break;
                btnCurrent.setEnabled(false);
                break;
            }
            case FILTER: {
                btnFilter.setSelection(true);
                btnFilter.setFocus();
                if (btnCurrent == null) break;
                btnCurrent.setEnabled(false);
                break;
            }
            case DECOMPILED: {
                if (btnDecomp == null) break;
                btnDecomp.setSelection(true);
                btnDecomp.setFocus();
                this.wFilter.setEnabled(false);
                if (btnCurrent == null) break;
                btnCurrent.setEnabled(false);
                break;
            }
            case CURRENT: {
                if (btnCurrent == null) break;
                btnCurrent.setSelection(true);
                btnCurrent.setFocus();
                this.wFilter.setEnabled(false);
                if (this.initialFilter == null) break;
                currentUnitText.setText(this.initialFilter);
            }
        }
        Group c01 = new Group(parent, 0);
        c01.setText("Timeouts");
        c01.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        c01.setLayout((Layout)new GridLayout(1, false));
        String notes = "Timeouts specified in your global settings apply. You may specify additional timeouts below (in seconds):";
        Label label = UIUtil.createLabel((Composite)c01, notes);
        label.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1));
        Composite c02 = new Composite((Composite)c01, 0);
        UIUtil.setStandardLayout(c02, 4);
        UIUtil.createLabel(c02, "Timeout (per item): ");
        this.wItemTimeout = UIUtil.createTextboxInGrid(c02, 2048, 5, 1);
        if (this.itemTimeout != null) {
            this.wItemTimeout.setText(this.itemTimeout.toString());
        }
        UIUtil.createLabel(c02, "Timeout (total): ");
        this.wTotalTimeout = UIUtil.createTextboxInGrid(c02, 2048, 5, 1);
        if (this.totalTimeout != null) {
            this.wTotalTimeout.setText(this.totalTimeout.toString());
        }
        Group c1 = new Group(parent, 0);
        c1.setText("Destination");
        c1.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        c1.setLayout((Layout)new GridLayout(1, false));
        this.wOutputDir = new DirectorySelectorView((Composite)c1, S.s(269) + ": ", this.initialDirectory);
        this.wOutputDir.setLayoutData(UIUtil.createGridDataFillHorizontally());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.wOutputDir.setLayoutData(gd);
        if (this.optAllow_MergeAll != null) {
            this.wMerge = new Button((Composite)this.wOutputDir, 32);
            this.wMerge.setText("Merge to one file: ");
            this.wMerge.setEnabled(this.optAllow_MergeAll.booleanValue());
            this.wMerge.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ExportDecompiledCodeDialog.this.wMerge.getSelection()) {
                        ExportDecompiledCodeDialog.this.wOutputMergedFile.setEnabled(true);
                    } else {
                        ExportDecompiledCodeDialog.this.wOutputMergedFile.setEnabled(false);
                    }
                }
            });
            this.wOutputMergedFile = new Text((Composite)this.wOutputDir, 2048);
            this.wOutputMergedFile.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            this.wOutputMergedFile.setMessage("File name");
            this.wOutputMergedFile.setEnabled(false);
        }
        if (this.optAllow_Resume != null) {
            this.wResume = new Button(parent, 32);
            this.wResume.setText("Resume");
            this.wResume.setEnabled(this.optAllow_Resume.booleanValue());
        }
        if (this.initialFilter != null) {
            this.wFilter.setText(this.initialFilter);
        }
        Composite buttons = this.createButtons(parent, 288, 32);
        GridData gdButtons = new GridData();
        gdButtons.verticalIndent = 20;
        buttons.setLayoutData((Object)gdButtons);
    }

    @Override
    protected void onConfirm() {
        if (Strings.isBlank(this.wOutputDir.getText())) {
            MessageDialog.openError(this.shell, "Empty directory", "Destination directory cannot be empty. Please select one.");
            return;
        }
        if (this.getMergeValue() && Strings.isBlank(this.getMergedFileName())) {
            MessageDialog.openError(this.shell, "Empty file name", "File name cannot be empty. Please enter one.");
            return;
        }
        if (this.getResumeValue() && this.getMergeValue()) {
            MessageDialog.openError(this.shell, "Incompatible options", "Resume cannot be performed on merged decompilation.");
            return;
        }
        if (this.exportState == State.FILTER && !Strings.isBlank(this.wFilter.getText())) {
            try {
                Pattern.compile(this.wFilter.getText());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                MessageDialog.openError(this.getShell(), "Invalid filter", "Filter cannot be compiled. See some examples of filters:\n\n -  'sub' will match any function containing the expression 'sub', for example: 'sub_8E88', '_ptr_sub_F950'. It is equivalent to '.*sub.*'\n\n -  '^android\\.support\\.' will match any package in android.support\n\nUse \\ to escape any metacharacter or surround literal expression between \\Q and \\E\n\nSee https://docs.oracle.com/javase/10/docs/api/java/util/regex/Pattern.html for more details.");
                return;
            }
        }
        this.exportStatus = new ExportStatus(this.exportState, this.wFilter.getText());
        this.itemTimeout = Conversion.stringToInt(this.wItemTimeout.getText(), 0);
        this.totalTimeout = Conversion.stringToInt(this.wTotalTimeout.getText(), 0);
        this.outputDir = this.wOutputDir.getText();
        this.outputFile = this.getMergedFileName();
        this.merge = this.getMergeValue();
        this.resume = this.getResumeValue();
        super.onConfirm();
    }

    private boolean getMergeValue() {
        return this.wMerge != null && this.wMerge.getSelection();
    }

    private String getMergedFileName() {
        return this.wOutputMergedFile == null ? null : this.wOutputMergedFile.getText();
    }

    private boolean getResumeValue() {
        return this.wResume != null && this.wResume.getSelection();
    }

    @Override
    protected void onCancel() {
        this.exportStatus = null;
        super.onCancel();
    }

    public static enum State {
        ALL,
        FILTER,
        DECOMPILED,
        CURRENT;

    }

    public static class ExportStatus {
        private State state;
        private String filter;

        public ExportStatus(State state, String filter) {
            this.state = state;
            this.filter = filter;
        }

        public State getState() {
            return this.state;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    private class ExportSelectionListener
    extends SelectionAdapter {
        private State state;

        public ExportSelectionListener(State state) {
            this.state = state;
        }

        public void widgetSelected(SelectionEvent e) {
            switch (this.state) {
                case ALL: 
                case CURRENT: 
                case DECOMPILED: {
                    ExportDecompiledCodeDialog.this.wFilter.setEnabled(false);
                    break;
                }
                case FILTER: {
                    ExportDecompiledCodeDialog.this.wFilter.setEnabled(true);
                }
            }
            ExportDecompiledCodeDialog.this.exportState = this.state;
        }
    }
}

