/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.dialogs;

import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethod;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexMethodData;
import com.pnfsoftware.jeb.core.units.code.android.dex.IDexType;
import com.pnfsoftware.jeb.rcpclient.dialogs.JebDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.ShellWrapper;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DexMethodEditorDialog
extends JebDialog {
    private static final LinkedHashMap<Integer, String> inlmodemap = new LinkedHashMap();
    private IDexMethod m;
    private List<Text> wParamNames = new ArrayList<Text>();
    private Combo wInliningMode;
    private boolean success;

    public DexMethodEditorDialog(Shell parent, IDexUnit dex, IDexMethod m) {
        super(parent, "Dex Method Editor", true, true);
        if (m == null) {
            throw new IllegalArgumentException("No method provided");
        }
        this.m = m;
        this.boundsRestorationType = ShellWrapper.BoundsRestorationType.SIZE_AND_POSITION;
    }

    @Override
    public Boolean open() {
        super.open();
        return this.success;
    }

    @Override
    protected void createContents(Composite parent) {
        UIUtil.setStandardLayout(parent, 1);
        Composite g0 = UIUtil.createCompositeGrid(parent, 0, 1, 2, 0);
        UIUtil.createLabel(g0, "Method: ");
        Text wMsig = UIUtil.createTextboxInGrid(g0, 2056, 80, 1, true, false);
        wMsig.setText(this.m.getSignature(true, false, true, true));
        List<IDexType> types = this.m.getParameterTypes();
        if (types.isEmpty()) {
            UIUtil.createLabelInGridLayout(parent, 0, "This method does not have parameters", 2);
        } else {
            Group g = UIUtil.createGroupGrid(parent, 0, "Parameters", 1, 2);
            UIUtil.createLabel((Composite)g, "Type");
            UIUtil.createLabel((Composite)g, "Name");
            int i = 0;
            for (IDexType t : types) {
                String ptype = t.getSignature(true, false, true);
                UIUtil.createLabel((Composite)g, 2048, ptype);
                String pname = this.m.getParameterName(i);
                Text t1 = UIUtil.createTextboxInGrid((Composite)g, 2048, 30, 1, true, false);
                t1.setText(Strings.safe(pname));
                t1.selectAll();
                this.wParamNames.add(t1);
                if (i == 0) {
                    t1.setFocus();
                }
                ++i;
            }
        }
        IDexMethodData md = this.m.getData();
        if (md != null) {
            Group c = UIUtil.createGroupGrid(parent, 0, "Flags", 1, 2);
            String desc = "Description: The 'inlining mode' is a custom flag that may be set on internal dex methods. It may be used by other components to determine how to optimize method calls. The dex decompiler optimizers attempt to honor this flag.";
            Label labelDesc = UIUtil.createWrappedLabel((Composite)c, 16896, desc);
            GridData griddata = UIUtil.createGridDataForText((Control)labelDesc, 50, -1, true);
            griddata.horizontalSpan = 2;
            labelDesc.setLayoutData((Object)griddata);
            UIUtil.createLabel((Composite)c, 0, "Inlining Mode: ");
            this.wInliningMode = new Combo((Composite)c, 2056);
            for (String mode : inlmodemap.values()) {
                this.wInliningMode.add(mode);
            }
            this.wInliningMode.pack();
            int index = new ArrayList<Integer>(inlmodemap.keySet()).indexOf(md.getInlineMode());
            if (index >= 0) {
                this.wInliningMode.select(index);
            }
        }
        this.createOkayCancelButtons(parent);
    }

    @Override
    public void onConfirm() {
        int idx;
        int i = 0;
        for (Text wName : this.wParamNames) {
            String name = wName.getText();
            this.m.setParameterName(i, name, false, true);
            ++i;
        }
        if (this.wInliningMode != null && (idx = this.wInliningMode.getSelectionIndex()) >= 0) {
            int mode = new ArrayList<Integer>(inlmodemap.keySet()).get(idx);
            this.m.getData().setInlineMode(mode);
        }
        this.success = true;
        super.onConfirm();
    }

    static {
        inlmodemap.put(0, "AUTO (inlining limited to simple cases)");
        inlmodemap.put(1, "BLOCKED (must not inline)");
        inlmodemap.put(2, "ALLOWED (may inline, even complex cases)");
        inlmodemap.put(3, "FORCED (should inline if possible)");
    }
}

